/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.filter;

import com.appdynamics.sim.agent.extensions.servers.config.ReportMetricsConfig;
import com.appdynamics.sim.agent.extensions.servers.model.Component;
import com.appdynamics.sim.agent.extensions.servers.model.filter.FilterPredicate;
import com.appdynamics.sim.agent.extensions.servers.model.filter.PrioritizationFilter;
import com.appdynamics.sim.agent.extensions.servers.model.filter.PrioritizationFilterResult;
import com.google.common.base.Optional;
import java.util.LinkedHashSet;
import java.util.Set;
import lombok.Generated;

class SinglePredicateWhitelistFilter<COMPONENT extends Component<?>>
implements PrioritizationFilter<COMPONENT> {
    private final FilterPredicate<COMPONENT> predicate;

    @Override
    public PrioritizationFilterResult<COMPONENT> apply(Optional<PrioritizationFilterResult<COMPONENT>> prevPrioritization, Set<COMPONENT> components, ReportMetricsConfig configuration) {
        LinkedHashSet<Component> filteredSet = new LinkedHashSet<Component>();
        this.predicate.refresh();
        for (Component component : components) {
            if (!this.predicate.apply(component)) continue;
            filteredSet.add(component);
        }
        return PrioritizationFilterResult.combinedWithWhitelistOf(prevPrioritization, filteredSet);
    }

    public static <STATIC_COMPONENT extends Component<?>> SinglePredicateWhitelistFilter<STATIC_COMPONENT> of(FilterPredicate<STATIC_COMPONENT> predicate) {
        return new SinglePredicateWhitelistFilter<STATIC_COMPONENT>(predicate);
    }

    @Generated
    public SinglePredicateWhitelistFilter(FilterPredicate<COMPONENT> predicate) {
        this.predicate = predicate;
    }
}

