/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.filter;

import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataLong;
import com.appdynamics.sim.agent.extensions.servers.model.MonitoredProcessClass;
import com.appdynamics.sim.agent.extensions.servers.model.filter.IComponentRankingMethod;
import com.appdynamics.sim.agent.extensions.servers.util.Pair;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.google.common.collect.UnmodifiableIterator;
import com.singularity.ee.util.system.SystemUtilsTranslateable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessRankingMethod<RAWDATA>
implements IComponentRankingMethod<MonitoredProcessClass<RAWDATA>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessRankingMethod.class);
    private static final Ordering<MonitoredProcessClass<?>> CPU_ORDERING = Ordering.compound(Arrays.asList(new Ordering[]{new DescCpuOrdering(), new ClassIdOrdering()}));
    private static final Ordering<MonitoredProcessClass<?>> MEM_ORDERING = Ordering.compound(Arrays.asList(new Ordering[]{new DescMemOrdering(), new ClassIdOrdering()}));
    private static final Ordering<ProcessScore> PROCESS_SCORE_ORDERING = Ordering.compound(Arrays.asList(new Ordering[]{new DescendingScoreOrdering(), new ProcessClassIdOrdering()}));
    private final Map<String, MonitoredProcessClass<RAWDATA>> classIdToProcessClassInstanceMap = new HashMap<String, MonitoredProcessClass<RAWDATA>>();
    private static Pattern criticalProcessesSelectorPattern = Pattern.compile("");
    private static final int DEFAULT_MAX_PROCESSES_MONITORED = 1000;
    private final int maxProcesses = SystemUtilsTranslateable.getIntProperty((String)"appdynamics.machine.agent.maxProcesses", (int)1000);

    @Override
    public Set<MonitoredProcessClass<RAWDATA>> rank(Set<MonitoredProcessClass<RAWDATA>> prioritySet, Set<MonitoredProcessClass<RAWDATA>> totalSet) {
        this.populateClassIdToProcessClassInstanceMap(totalSet);
        LinkedHashSet<MonitoredProcessClass<RAWDATA>> rankedSet = this.rankByCustomProcessScores(totalSet);
        return rankedSet;
    }

    @VisibleForTesting
    LinkedHashSet<MonitoredProcessClass<RAWDATA>> rankByHighestUsage(@NonNull Set<MonitoredProcessClass<RAWDATA>> monitoredProcessClasses) {
        if (monitoredProcessClasses == null) {
            throw new NullPointerException("monitoredProcessClasses is marked non-null but is null");
        }
        ImmutableList cpuSortedClasses = CPU_ORDERING.immutableSortedCopy(monitoredProcessClasses);
        ImmutableList memSortedClasses = MEM_ORDERING.immutableSortedCopy(monitoredProcessClasses);
        UnmodifiableIterator oneIter = cpuSortedClasses.iterator();
        UnmodifiableIterator otherIter = memSortedClasses.iterator();
        LinkedHashSet<MonitoredProcessClass<RAWDATA>> rankedMonitoredProcessClasses = new LinkedHashSet<MonitoredProcessClass<RAWDATA>>(monitoredProcessClasses.size());
        while (oneIter.hasNext() || otherIter.hasNext()) {
            if (oneIter.hasNext()) {
                rankedMonitoredProcessClasses.add((MonitoredProcessClass)oneIter.next());
            }
            if (!otherIter.hasNext()) continue;
            UnmodifiableIterator tempIter = oneIter;
            oneIter = otherIter;
            otherIter = tempIter;
        }
        return rankedMonitoredProcessClasses;
    }

    @VisibleForTesting
    LinkedHashSet<MonitoredProcessClass<RAWDATA>> rankByCustomProcessScores(@NonNull Set<MonitoredProcessClass<RAWDATA>> monitoredProcessClasses) {
        if (monitoredProcessClasses == null) {
            throw new NullPointerException("monitoredProcessClasses is marked non-null but is null");
        }
        Iterator<MonitoredProcessClass<RAWDATA>> iterator = monitoredProcessClasses.iterator();
        if (iterator.hasNext()) {
            criticalProcessesSelectorPattern = iterator.next().getCriticalProcessSelectorPattern();
        }
        List<ProcessScore> processScores = this.createProcessRankingScores(monitoredProcessClasses);
        LinkedHashSet<MonitoredProcessClass<RAWDATA>> rankedMonitoredProcessClasses = new LinkedHashSet<MonitoredProcessClass<RAWDATA>>(monitoredProcessClasses.size());
        int currentProcessCount = 0;
        log.debug("Number of processes monitored: {}", (Object)this.maxProcesses);
        HashMap<String, Set> classIdToProcessIdsToRemove = new HashMap<String, Set>();
        for (ProcessScore processScore : processScores) {
            if (++currentProcessCount > this.maxProcesses) {
                MonitoredProcessClass<RAWDATA> processClassInstance = this.classIdToProcessClassInstanceMap.get(processScore.classId);
                if (rankedMonitoredProcessClasses.contains(processClassInstance)) {
                    classIdToProcessIdsToRemove.computeIfAbsent(processScore.classId, k -> new HashSet()).add(processScore.pid.get());
                    continue;
                }
                processClassInstance.getFilteredObservations().clear();
                continue;
            }
            rankedMonitoredProcessClasses.add(this.classIdToProcessClassInstanceMap.get(processScore.classId));
        }
        for (Map.Entry entry : classIdToProcessIdsToRemove.entrySet()) {
            String classId = (String)entry.getKey();
            Set processIdsToRemove = (Set)entry.getValue();
            MonitoredProcessClass<RAWDATA> processClassInstance = this.classIdToProcessClassInstanceMap.get(classId);
            processClassInstance.getFilteredObservations().removeIf(observation -> processIdsToRemove.contains(observation.getProcessId()));
        }
        return rankedMonitoredProcessClasses;
    }

    private List<ProcessScore> createProcessRankingScores(Set<MonitoredProcessClass<RAWDATA>> totalSet) {
        ArrayList<ProcessScore> processScores = new ArrayList<ProcessScore>();
        for (MonitoredProcessClass<RAWDATA> processClass : totalSet) {
            Map<RawDataLong, Pair<RawDataLong, Double>> cpuMetrics = processClass.getCurrentProcessCpuMetrics();
            Map<RawDataLong, Pair<RawDataLong, Double>> memoryMetrics = processClass.getCurrentProcessMemoryMetrics();
            Map<RawDataLong, String> commandLineMap = processClass.getCurrentProcessCommandLineMap();
            Set<RawDataLong> pids = cpuMetrics.keySet();
            for (RawDataLong pid : pids) {
                Pair<RawDataLong, Double> cpuData = cpuMetrics.get(pid);
                Pair<RawDataLong, Double> memoryData = memoryMetrics.get(pid);
                String commandLine = commandLineMap.get(pid);
                double score = ProcessRankingMethod.calculateScore(cpuData, memoryData, commandLine, pid);
                ProcessScore processScore = new ProcessScore(pid, cpuData, memoryData, commandLine, processClass.getClassId(), score);
                processScores.add(processScore);
            }
        }
        Collections.sort(processScores, PROCESS_SCORE_ORDERING);
        return processScores;
    }

    private static double calculateScore(Pair<RawDataLong, Double> cpuData, Pair<RawDataLong, Double> memoryData, String commandLine, RawDataLong pid) {
        double cpuUsage = cpuData.getSecond();
        double memoryUsage = memoryData.getSecond();
        boolean isCriticalProcess = ProcessRankingMethod.isCriticalProcess(commandLine, pid);
        double cpuWeight = 0.5;
        double memoryWeight = 0.5;
        double criticalProcessWeight = 40.0;
        double score = cpuUsage * cpuWeight + memoryUsage * memoryWeight;
        if (isCriticalProcess) {
            score += criticalProcessWeight;
        }
        return score;
    }

    private static boolean isCriticalProcess(String commandLine, RawDataLong pid) {
        if (criticalProcessesSelectorPattern == null) {
            return false;
        }
        Matcher matcher = criticalProcessesSelectorPattern.matcher(commandLine);
        boolean isCritical = matcher.find();
        if (isCritical) {
            log.debug("Process with pid: " + pid.get() + " and commandLine: " + commandLine + " marked as a critical process");
        }
        return isCritical;
    }

    @VisibleForTesting
    public static void setCriticalProcessesSelectorPattern(Pattern criticalProcessesPattern) {
        criticalProcessesSelectorPattern = criticalProcessesPattern;
    }

    private void populateClassIdToProcessClassInstanceMap(Set<MonitoredProcessClass<RAWDATA>> totalSet) {
        this.classIdToProcessClassInstanceMap.clear();
        for (MonitoredProcessClass<RAWDATA> processClass : totalSet) {
            this.classIdToProcessClassInstanceMap.put(processClass.getClassId(), processClass);
        }
    }

    static class ProcessScore
    implements Comparable<ProcessScore> {
        RawDataLong pid;
        Pair<RawDataLong, Double> memoryData;
        Pair<RawDataLong, Double> cpuData;
        String commandLine;
        String classId;
        double score;

        @Override
        public int compareTo(ProcessScore other) {
            return PROCESS_SCORE_ORDERING.compare((Object)this, (Object)other);
        }

        @Generated
        ProcessScore(RawDataLong pid, Pair<RawDataLong, Double> memoryData, Pair<RawDataLong, Double> cpuData, String commandLine, String classId, double score) {
            this.pid = pid;
            this.memoryData = memoryData;
            this.cpuData = cpuData;
            this.commandLine = commandLine;
            this.classId = classId;
            this.score = score;
        }

        @Generated
        public static ProcessScoreBuilder builder() {
            return new ProcessScoreBuilder();
        }

        @Generated
        public String getClassId() {
            return this.classId;
        }

        @Generated
        public double getScore() {
            return this.score;
        }

        @Generated
        public static class ProcessScoreBuilder {
            @Generated
            private RawDataLong pid;
            @Generated
            private Pair<RawDataLong, Double> memoryData;
            @Generated
            private Pair<RawDataLong, Double> cpuData;
            @Generated
            private String commandLine;
            @Generated
            private String classId;
            @Generated
            private double score;

            @Generated
            ProcessScoreBuilder() {
            }

            @Generated
            public ProcessScoreBuilder pid(RawDataLong pid) {
                this.pid = pid;
                return this;
            }

            @Generated
            public ProcessScoreBuilder memoryData(Pair<RawDataLong, Double> memoryData) {
                this.memoryData = memoryData;
                return this;
            }

            @Generated
            public ProcessScoreBuilder cpuData(Pair<RawDataLong, Double> cpuData) {
                this.cpuData = cpuData;
                return this;
            }

            @Generated
            public ProcessScoreBuilder commandLine(String commandLine) {
                this.commandLine = commandLine;
                return this;
            }

            @Generated
            public ProcessScoreBuilder classId(String classId) {
                this.classId = classId;
                return this;
            }

            @Generated
            public ProcessScoreBuilder score(double score) {
                this.score = score;
                return this;
            }

            @Generated
            public ProcessScore build() {
                return new ProcessScore(this.pid, this.memoryData, this.cpuData, this.commandLine, this.classId, this.score);
            }

            @Generated
            public String toString() {
                return "ProcessRankingMethod.ProcessScore.ProcessScoreBuilder(pid=" + String.valueOf(this.pid) + ", memoryData=" + String.valueOf(this.memoryData) + ", cpuData=" + String.valueOf(this.cpuData) + ", commandLine=" + this.commandLine + ", classId=" + this.classId + ", score=" + this.score + ")";
            }
        }
    }

    @VisibleForTesting
    static class DescCpuOrdering
    extends Ordering<MonitoredProcessClass<?>> {
        DescCpuOrdering() {
        }

        public int compare(MonitoredProcessClass<?> o1, MonitoredProcessClass<?> o2) {
            return Double.compare(o2.getCpuUtilizationMovingAverage(), o1.getCpuUtilizationMovingAverage());
        }
    }

    @VisibleForTesting
    static class ClassIdOrdering
    extends Ordering<MonitoredProcessClass<?>> {
        private final Ordering<String> stringOrdering = Ordering.natural();

        ClassIdOrdering() {
        }

        public int compare(MonitoredProcessClass<?> o1, MonitoredProcessClass<?> o2) {
            return this.stringOrdering.compare((Object)o1.getClassId(), (Object)o2.getClassId());
        }
    }

    @VisibleForTesting
    static class DescMemOrdering
    extends Ordering<MonitoredProcessClass<?>> {
        DescMemOrdering() {
        }

        public int compare(MonitoredProcessClass<?> o1, MonitoredProcessClass<?> o2) {
            return Double.compare(o2.getMemKbMovingAverage(), o1.getMemKbMovingAverage());
        }
    }

    @VisibleForTesting
    static class DescendingScoreOrdering
    extends Ordering<ProcessScore> {
        DescendingScoreOrdering() {
        }

        public int compare(ProcessScore o1, ProcessScore o2) {
            return Double.compare(o2.getScore(), o1.getScore());
        }
    }

    @VisibleForTesting
    static class ProcessClassIdOrdering
    extends Ordering<ProcessScore> {
        private final Ordering<String> stringOrdering = Ordering.natural();

        ProcessClassIdOrdering() {
        }

        public int compare(ProcessScore o1, ProcessScore o2) {
            return this.stringOrdering.compare((Object)o1.getClassId(), (Object)o2.getClassId());
        }
    }
}

