/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.filter;

import com.appdynamics.sim.agent.extensions.servers.model.Component;
import com.appdynamics.sim.agent.extensions.servers.model.filter.FilterPredicate;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import java.util.regex.Pattern;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PatternFilterPredicate<COMPONENT extends Component<?>>
implements FilterPredicate<COMPONENT> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PatternFilterPredicate.class);
    private final Supplier<Optional<Pattern>> patternSupplier;
    private final DecisionIfPatternNotDefined defaultDecision;
    private final PatternType patternType;
    private Optional<Pattern> pattern = Optional.absent();

    PatternFilterPredicate(@NonNull Supplier<Optional<Pattern>> patternSupplier, @NonNull DecisionIfPatternNotDefined defaultDecision, @NonNull PatternType patternType) {
        if (patternSupplier == null) {
            throw new NullPointerException("patternSupplier is marked non-null but is null");
        }
        if (defaultDecision == null) {
            throw new NullPointerException("defaultDecision is marked non-null but is null");
        }
        if (patternType == null) {
            throw new NullPointerException("patternType is marked non-null but is null");
        }
        this.patternSupplier = patternSupplier;
        this.defaultDecision = defaultDecision;
        this.patternType = patternType;
    }

    @Override
    public void refresh() {
        this.pattern = (Optional)this.patternSupplier.get();
    }

    @Override
    public boolean apply(@NonNull COMPONENT component) {
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        if (!this.pattern.isPresent()) {
            return this.getDefaultDecisionValue();
        }
        Optional<String> value = this.getComponentValue(component);
        if (!value.isPresent()) {
            log.trace("The value supplier for the component {} did not return a valid value.", (Object)component.getId());
            return this.getDefaultDecisionValue();
        }
        boolean result = ((Pattern)this.pattern.get()).matcher((CharSequence)value.get()).matches();
        if (this.patternType == PatternType.EXCLUSION) {
            result = !result;
        }
        return result;
    }

    protected Optional<String> getComponentValue(@NonNull COMPONENT component) {
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        return Optional.fromNullable((Object)component.getId());
    }

    private boolean getDefaultDecisionValue() {
        return this.defaultDecision == DecisionIfPatternNotDefined.INCLUDE;
    }

    static enum DecisionIfPatternNotDefined {
        INCLUDE,
        EXCLUDE;

    }

    static enum PatternType {
        INCLUSION,
        EXCLUSION;

    }
}

