/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.filter;

import com.appdynamics.sim.agent.extensions.servers.model.Component;
import com.appdynamics.sim.agent.extensions.servers.model.filter.PrioritizationFilterResult;
import com.appdynamics.sim.agent.extensions.servers.model.filter.ReductionFilter;
import com.appdynamics.sim.agent.extensions.servers.model.filter.ReductionFilterResult;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;

public class LimitReductionFilter<COMPONENT extends Component<?>>
implements ReductionFilter<COMPONENT> {
    private final Supplier<Integer> maxComponents;

    @Override
    public ReductionFilterResult<COMPONENT> apply(@NonNull Optional<PrioritizationFilterResult<COMPONENT>> prioritization, @NonNull ReductionFilterResult<COMPONENT> prevReductionResult) {
        if (prioritization == null) {
            throw new NullPointerException("prioritization is marked non-null but is null");
        }
        if (prevReductionResult == null) {
            throw new NullPointerException("prevReductionResult is marked non-null but is null");
        }
        Set<COMPONENT> components = prevReductionResult.getFilteredComponents();
        int maxNumberMonitored = (Integer)this.maxComponents.get();
        LinkedHashSet<Component> filteredSet = new LinkedHashSet<Component>(maxNumberMonitored);
        Iterator<COMPONENT> iter = components.iterator();
        for (int i = 0; i < maxNumberMonitored && iter.hasNext(); ++i) {
            filteredSet.add((Component)iter.next());
        }
        return ReductionFilterResult.of(filteredSet);
    }

    @Generated
    public LimitReductionFilter(Supplier<Integer> maxComponents) {
        this.maxComponents = maxComponents;
    }
}

