/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.aix;

import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataFactory;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataString;
import com.appdynamics.sim.agent.extensions.servers.Sim;
import com.appdynamics.sim.agent.extensions.servers.config.ReportMetricsConfig;
import com.appdynamics.sim.agent.extensions.servers.model.OperatingSystem;
import com.appdynamics.sim.agent.extensions.servers.model.ToggleableReporter;
import com.appdynamics.sim.agent.extensions.servers.model.aix.AixRawData;
import com.appdynamics.voltron.utils.annotations.VisibleForAssistedInject;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.inject.Inject;
import lombok.Generated;

@VisibleForAssistedInject
public class AixOperatingSystem
extends OperatingSystem<AixRawData> {
    private AixRawData.OperatingSystem operatingSystem;

    @Inject
    private AixOperatingSystem(@Sim MachineProperties machineProperties, Predicate<ToggleableReporter<AixRawData>> isDisabledPredicate, RawDataFactory rawDataFactory) {
        super("AIX", machineProperties, isDisabledPredicate, rawDataFactory);
    }

    @Override
    public void update(AixRawData rawData, ReportMetricsConfig reportMetricsConfig) {
        this.operatingSystem = rawData.getOperatingSystem();
    }

    @Override
    protected RawDataString getRelease() {
        return this.rawDataFactory.createString(Optional.fromNullable((Object)this.operatingSystem.getRelease()));
    }

    @Override
    protected RawDataString getArchitecture() {
        return this.rawDataFactory.createString(Optional.fromNullable((Object)this.operatingSystem.getArchitecture()));
    }

    @Override
    @Generated
    public String toString() {
        return "AixOperatingSystem(super=" + super.toString() + ", operatingSystem=" + String.valueOf(this.operatingSystem) + ")";
    }
}

