/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.aix;

import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.api.util.DeltaCalculatorUtil;
import com.appdynamics.sim.agent.extensions.api.util.RateCalculatorUtil;
import com.appdynamics.sim.agent.extensions.servers.config.ReportMetricsConfig;
import com.appdynamics.sim.agent.extensions.servers.model.Network;
import com.appdynamics.sim.agent.extensions.servers.model.aix.AixRawData;
import com.appdynamics.sim.agent.extensions.servers.util.CalculationUtils;
import com.appdynamics.sim.agent.extensions.servers.util.NixUtils;
import com.appdynamics.voltron.utils.annotations.VisibleForAssistedInject;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import io.dropwizard.util.SizeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@VisibleForAssistedInject
public class AixNetwork
extends Network<AixRawData> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AixNetwork.class);
    private static final String DUPLEX = "duplex";
    private static final String HALF = "half";
    private static final String FULL = "full";
    private static final String MBPS = "mbps";
    private static final long MEGABITS_10 = 10000000L;
    private final DeltaCalculatorUtil incomingBytesCalculator = new DeltaCalculatorUtil();
    private final DeltaCalculatorUtil outgoingBytesCalculator = new DeltaCalculatorUtil();
    private final DeltaCalculatorUtil incomingPacketsCalculator = new DeltaCalculatorUtil();
    private final DeltaCalculatorUtil outgoingPacketsCalculator = new DeltaCalculatorUtil();
    private final DeltaCalculatorUtil incomingPacketErrorsCalculator = new DeltaCalculatorUtil();
    private final DeltaCalculatorUtil outgoingPacketErrorsCalculator = new DeltaCalculatorUtil();
    private final RateCalculatorUtil incomingBytesPerSecCalculator = new RateCalculatorUtil();
    private final RateCalculatorUtil outgoingBytesPerSecCalculator = new RateCalculatorUtil();
    private final RateCalculatorUtil incomingPacketsPerSecCalculator = new RateCalculatorUtil();
    private final RateCalculatorUtil outgoingPacketsPerSecCalculator = new RateCalculatorUtil();
    private AixRawData.NetworkInfoViaIfconfig networkInfoViaIfconfig;
    private AixRawData.NetworkInfoViaNetstatANR networkInfoViaNetstatANR;
    private AixRawData.NetworkInfoViaNetstatI networkInfoViaNetstatI;
    private AixRawData.NetworkInfoViaNetstatV networkInfoViaNetstatV;

    @Inject
    private AixNetwork(@Assisted String networkName, MachineProperties machineProperties, MetricsService metricsService) {
        super(networkName, machineProperties, metricsService);
    }

    @Override
    public void update(AixRawData rawData, ReportMetricsConfig reportMetricsConfig) {
        String networkName = this.getNetworkName();
        this.networkInfoViaIfconfig = rawData.getNetworkToIfconfig().get(networkName);
        this.networkInfoViaNetstatANR = rawData.getNetworkToNetstatANR().get(networkName);
        this.networkInfoViaNetstatI = rawData.getNetworkToNetstatI().get(networkName);
        this.networkInfoViaNetstatV = rawData.getNetworkToNetstatV().get(networkName);
        long incomingBytes = this.networkInfoViaNetstatV.getIncomingBytes();
        long outgoingBytes = this.networkInfoViaNetstatV.getOutgoingBytes();
        long incomingPackets = this.networkInfoViaNetstatV.getIncomingPackets();
        long outgoingPackets = this.networkInfoViaNetstatV.getOutgoingPackets();
        this.incomingBytesCalculator.calculate(incomingBytes);
        this.outgoingBytesCalculator.calculate(outgoingBytes);
        this.incomingPacketsCalculator.calculate(incomingPackets);
        this.outgoingPacketsCalculator.calculate(outgoingPackets);
        this.incomingPacketErrorsCalculator.calculate(this.networkInfoViaNetstatV.getIncomingPacketErrors());
        this.outgoingPacketErrorsCalculator.calculate(this.networkInfoViaNetstatV.getOutgoingPacketErrors());
        long timeStamp = this.networkInfoViaNetstatV.getUtcTimeStamp();
        this.incomingBytesPerSecCalculator.calculate(incomingBytes, timeStamp);
        this.outgoingBytesPerSecCalculator.calculate(outgoingBytes, timeStamp);
        this.incomingPacketsPerSecCalculator.calculate(incomingPackets, timeStamp);
        this.outgoingPacketsPerSecCalculator.calculate(outgoingPackets, timeStamp);
    }

    @Override
    protected String getNetEnabled() {
        return AixNetwork.valueToNoYesUnknown(this.networkInfoViaIfconfig.getEnabled());
    }

    @Override
    protected String getPluggedIn() {
        return AixNetwork.valueToNoYesUnknown(this.networkInfoViaIfconfig.getPluggedIn());
    }

    @Override
    protected String getStatus() {
        return AixNetwork.valueToUpDownUnknown(this.networkInfoViaIfconfig.getOperational());
    }

    @Override
    protected String getDuplex() {
        String speedInfo = this.networkInfoViaNetstatV.getSpeedInfo().toLowerCase();
        Optional<String> typeOpt = NixUtils.getFirstWordOfPair(speedInfo, -1, DUPLEX);
        if (typeOpt.isPresent()) {
            String type;
            switch (type = (String)typeOpt.get()) {
                case "half": 
                case "full": {
                    return type;
                }
            }
            log.debug("Unknown duplex type in: {}", (Object)this.networkInfoViaNetstatV.getSpeedInfo());
            return "unknown";
        }
        return HALF;
    }

    @Override
    protected String getMtu() {
        return String.valueOf(this.networkInfoViaNetstatI.getMtu());
    }

    @Override
    protected String getSpeedMb() {
        long speed = this.getSpeedBits() / 1000000L;
        return String.valueOf(speed);
    }

    @Override
    protected String getMacAddress() {
        return this.networkInfoViaNetstatV.getMacAddress();
    }

    @Override
    protected String getIpv4Addresses() {
        return this.networkInfoViaIfconfig.getIpv4();
    }

    @Override
    protected String getIpv6Addresses() {
        return this.networkInfoViaIfconfig.getIpv6();
    }

    @Override
    protected String getDefaultIpv4Gateways() {
        return this.networkInfoViaNetstatANR.getIpv4DefaultGateway();
    }

    @Override
    protected String getDefaultIpv6Gateways() {
        return this.networkInfoViaNetstatANR.getIpv6DefaultGateway();
    }

    @Override
    protected long getIncomingKb() {
        return SizeUnit.BYTES.toKilobytes(this.incomingBytesCalculator.getLastResult());
    }

    @Override
    protected long getOutgoingKb() {
        return SizeUnit.BYTES.toKilobytes(this.outgoingBytesCalculator.getLastResult());
    }

    @Override
    protected long getIncomingPackets() {
        return this.incomingPacketsCalculator.getLastResult();
    }

    @Override
    protected long getOutgoingPackets() {
        return this.outgoingPacketsCalculator.getLastResult();
    }

    @Override
    protected long getIncomingPacketErrors() {
        return this.incomingPacketErrorsCalculator.getLastResult();
    }

    @Override
    protected long getOutgoingPacketErrors() {
        return this.outgoingPacketErrorsCalculator.getLastResult();
    }

    @Override
    protected long getIncomingKbPerSec() {
        return SizeUnit.BYTES.toKilobytes(this.incomingBytesPerSecCalculator.getLastResult());
    }

    @Override
    protected long getOutgoingKbPerSec() {
        return SizeUnit.BYTES.toKilobytes(this.outgoingBytesPerSecCalculator.getLastResult());
    }

    @Override
    protected long getIncomingPacketsPerSec() {
        return this.incomingPacketsPerSecCalculator.getLastResult();
    }

    @Override
    protected long getOutgoingPacketsPerSec() {
        return this.outgoingPacketsPerSecCalculator.getLastResult();
    }

    @Override
    protected Optional<Long> getUtilizationPct() {
        long maxBits = this.getSpeedBits();
        if (this.getDuplex().equals(FULL)) {
            maxBits *= 2L;
        }
        long totalBytesPerSec = this.incomingBytesPerSecCalculator.getLastResult() + this.outgoingBytesPerSecCalculator.getLastResult();
        return Optional.of((Object)CalculationUtils.calculatePercentage(CalculationUtils.bytesToBits(totalBytesPerSec), maxBits));
    }

    private long getSpeedBits() {
        String speedInfo = this.networkInfoViaNetstatV.getSpeedInfo().toLowerCase();
        Optional<String> speedOpt = NixUtils.getFirstWordOfPair(speedInfo, 1, MBPS);
        if (speedOpt.isPresent()) {
            return Long.parseLong((String)speedOpt.get()) * 1000000L;
        }
        return 10000000L;
    }

    private static String valueToNoYesUnknown(long value) {
        if (value == 0L) {
            return "no";
        }
        if (value == 1L) {
            return "yes";
        }
        return "unknown";
    }

    private static String valueToUpDownUnknown(long value) {
        if (value == 0L) {
            return "down";
        }
        if (value == 1L) {
            return "up";
        }
        return "unknown";
    }

    @Override
    @Generated
    public String toString() {
        return "AixNetwork(super=" + super.toString() + ", incomingBytesCalculator=" + String.valueOf(this.incomingBytesCalculator) + ", outgoingBytesCalculator=" + String.valueOf(this.outgoingBytesCalculator) + ", incomingPacketsCalculator=" + String.valueOf(this.incomingPacketsCalculator) + ", outgoingPacketsCalculator=" + String.valueOf(this.outgoingPacketsCalculator) + ", incomingPacketErrorsCalculator=" + String.valueOf(this.incomingPacketErrorsCalculator) + ", outgoingPacketErrorsCalculator=" + String.valueOf(this.outgoingPacketErrorsCalculator) + ", incomingBytesPerSecCalculator=" + String.valueOf(this.incomingBytesPerSecCalculator) + ", outgoingBytesPerSecCalculator=" + String.valueOf(this.outgoingBytesPerSecCalculator) + ", incomingPacketsPerSecCalculator=" + String.valueOf(this.incomingPacketsPerSecCalculator) + ", outgoingPacketsPerSecCalculator=" + String.valueOf(this.outgoingPacketsPerSecCalculator) + ", networkInfoViaIfconfig=" + String.valueOf(this.networkInfoViaIfconfig) + ", networkInfoViaNetstatANR=" + String.valueOf(this.networkInfoViaNetstatANR) + ", networkInfoViaNetstatI=" + String.valueOf(this.networkInfoViaNetstatI) + ", networkInfoViaNetstatV=" + String.valueOf(this.networkInfoViaNetstatV) + ")";
    }
}

