/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.aix;

import com.appdynamics.agent.sim.configuration.bootstrap.BootstrapConfiguration;
import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataFactory;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataLong;
import com.appdynamics.sim.agent.extensions.servers.Sim;
import com.appdynamics.sim.agent.extensions.servers.config.ReportMetricsConfig;
import com.appdynamics.sim.agent.extensions.servers.model.Memory;
import com.appdynamics.sim.agent.extensions.servers.model.ToggleableReporter;
import com.appdynamics.sim.agent.extensions.servers.model.aix.AixRawData;
import com.appdynamics.voltron.utils.annotations.VisibleForAssistedInject;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.inject.Inject;
import io.dropwizard.util.SizeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@VisibleForAssistedInject
public class AixMemory
extends Memory<AixRawData> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AixMemory.class);
    private final RawDataFactory rawDataFactory;
    private AixRawData.Memory memory;
    private AixRawData.VmstatMemory vmstatmemory;
    private final BootstrapConfiguration bootstrapConfiguration;

    @Inject
    public AixMemory(@Sim MetricsService metricsService, MachineProperties machineProperties, Predicate<ToggleableReporter<AixRawData>> isDisabledPredicate, RawDataFactory rawDataFactory, BootstrapConfiguration bootstrapConfiguration) {
        super("AixMemory", metricsService, machineProperties, isDisabledPredicate, rawDataFactory);
        this.rawDataFactory = rawDataFactory;
        this.bootstrapConfiguration = bootstrapConfiguration;
    }

    @Override
    public void update(AixRawData rawData, ReportMetricsConfig reportMetricsConfig) {
        this.memory = rawData.getMemory();
        this.vmstatmemory = rawData.getVmstatmemory();
    }

    @Override
    protected RawDataLong getSwapTotalMb() {
        if (this.isUsingVmstatCommandOutput()) {
            return this.rawDataFactory.createLong(Long.valueOf(SizeUnit.KILOBYTES.toMegabytes(this.memory.getTotalSwapKb())));
        }
        return this.rawDataFactory.createLong(Long.valueOf(SizeUnit.KILOBYTES.toMegabytes(this.memory.getTotalSwapKb())));
    }

    @Override
    protected RawDataLong getSwapFreeMb() {
        RawDataLong swapTotalMb = this.getSwapTotalMb();
        if (!swapTotalMb.isPresent()) {
            return swapTotalMb;
        }
        if (this.isUsingVmstatCommandOutput()) {
            return this.rawDataFactory.createLong(Long.valueOf(swapTotalMb.get() - SizeUnit.KILOBYTES.toMegabytes(this.memory.getUsedSwapKb())));
        }
        return this.rawDataFactory.createLong(Long.valueOf(swapTotalMb.get() - SizeUnit.KILOBYTES.toMegabytes(this.memory.getUsedSwapKb())));
    }

    @Override
    protected RawDataLong getPhysicalTotalMb() {
        if (this.isUsingVmstatCommandOutput()) {
            return this.rawDataFactory.createLong(Long.valueOf(SizeUnit.KILOBYTES.toMegabytes(this.vmstatmemory.getVmstattotalKb())));
        }
        return this.rawDataFactory.createLong(Long.valueOf(SizeUnit.KILOBYTES.toMegabytes(this.memory.getTotalKb())));
    }

    @Override
    protected RawDataLong getPhysicalFreeMb() {
        RawDataLong physicalTotalMb = this.getPhysicalTotalMb();
        if (!physicalTotalMb.isPresent()) {
            return physicalTotalMb;
        }
        if (this.isUsingVmstatCommandOutput()) {
            return this.rawDataFactory.createLong(Long.valueOf(physicalTotalMb.get() - SizeUnit.KILOBYTES.toMegabytes(this.vmstatmemory.getVmstatusedKb())));
        }
        return this.rawDataFactory.createLong(Long.valueOf(physicalTotalMb.get() - SizeUnit.KILOBYTES.toMegabytes(this.memory.getUsedKb())));
    }

    @VisibleForTesting
    boolean isUsingVmstatCommandOutput() {
        return this.bootstrapConfiguration.getCollectMemoryMetricsUsingVmstatCommandEnabled();
    }

    @Generated
    public String toString() {
        return "AixMemory(super=" + super.toString() + ", rawDataFactory=" + String.valueOf(this.rawDataFactory) + ", memory=" + String.valueOf(this.memory) + ", vmstatmemory=" + String.valueOf(this.vmstatmemory) + ", bootstrapConfiguration=" + String.valueOf(this.bootstrapConfiguration) + ")";
    }
}

