/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.aix;

import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataFactory;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataLong;
import com.appdynamics.sim.agent.extensions.servers.config.ReportMetricsConfig;
import com.appdynamics.sim.agent.extensions.servers.config.ServersMonitorConfig;
import com.appdynamics.sim.agent.extensions.servers.model.Load;
import com.appdynamics.sim.agent.extensions.servers.model.ToggleableReporter;
import com.appdynamics.sim.agent.extensions.servers.model.aix.AixRawData;
import com.google.common.base.Predicate;
import com.google.inject.Inject;
import lombok.NonNull;

public class AixLoad
extends Load<AixRawData> {
    private AixRawData.Load load;
    private final RawDataFactory rawDataFactory;

    @Inject
    public AixLoad(@NonNull ServersMonitorConfig config, @NonNull MetricsService metricsService, Predicate<ToggleableReporter<AixRawData>> isDisabledPredicate, RawDataFactory rawDataFactory) {
        super("AixLoad", metricsService, isDisabledPredicate);
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (metricsService == null) {
            throw new NullPointerException("metricsService is marked non-null but is null");
        }
        this.rawDataFactory = rawDataFactory;
    }

    @Override
    public void update(AixRawData rawData, ReportMetricsConfig reportMetricsConfig) {
        this.load = rawData.getLoad();
    }

    @Override
    protected RawDataLong getLoadAverage1() {
        return this.rawDataFactory.createLong(Long.valueOf(this.load.getOneMinute()));
    }

    @Override
    protected RawDataLong getLoadAverage5() {
        return this.rawDataFactory.createLong(Long.valueOf(this.load.getFiveMinutes()));
    }

    @Override
    protected RawDataLong getLoadAverage15() {
        return this.rawDataFactory.createLong(Long.valueOf(this.load.getFifteenMinutes()));
    }
}

