/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.aix;

import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataFactory;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataItemUtil;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataLong;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataString;
import com.appdynamics.sim.agent.extensions.servers.Sim;
import com.appdynamics.sim.agent.extensions.servers.config.ReportMetricsConfig;
import com.appdynamics.sim.agent.extensions.servers.model.Cpu;
import com.appdynamics.sim.agent.extensions.servers.model.aix.AixRawData;
import com.appdynamics.sim.agent.extensions.servers.util.CalculationUtils;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.util.Map;

public class AixCpu
extends Cpu<AixRawData> {
    private static final String IBM = "IBM";
    private final RawDataFactory factory;
    private AixRawData.Cpu cpu;

    @Inject
    private AixCpu(@Assisted String cpuId, @Sim MachineProperties machineProperties, RawDataItemUtil rawDataItemUtil, RawDataFactory factory) {
        super(cpuId, machineProperties, rawDataItemUtil);
        this.factory = factory;
    }

    @Override
    public void update(AixRawData rawData, ReportMetricsConfig reportMetricsConfig) {
        this.cpu = rawData.getCpus().get(this.getCpuId());
    }

    @Override
    protected RawDataLong getNumLogicalProcessors() {
        return this.factory.createLong(Long.valueOf(this.cpu.getSmtThreads()));
    }

    @Override
    protected RawDataLong getNumCores() {
        return this.factory.createLong(Long.valueOf(1L));
    }

    @Override
    protected RawDataString getCpuVendor() {
        return this.factory.createString(Optional.of((Object)IBM));
    }

    @Override
    protected RawDataString getCpuModel() {
        return this.factory.createString(Optional.of((Object)this.cpu.getModel()));
    }

    @Override
    protected RawDataString getCpuMaxSpeedMhz() {
        String value = String.valueOf(CalculationUtils.hzToMhz(this.cpu.getMaxSpeedHz()));
        return this.factory.createString(Optional.of((Object)value));
    }

    @Override
    protected RawDataString getCpuCurrentSpeedMhz() {
        return this.factory.createString(Optional.of((Object)IBM));
    }

    @Override
    protected Map<String, RawDataString> getOsSpecificProperties() {
        ImmutableMap.Builder properties = new ImmutableMap.Builder();
        properties.put((Object)"CPU|{0}|SMT Enabled", (Object)this.factory.createString(Optional.of((Object)this.cpu.getSmtEnabled())));
        properties.put((Object)"CPU|{0}|State", (Object)this.factory.createString(Optional.of((Object)this.cpu.getState())));
        return properties.build();
    }
}

