/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model;

import com.appdynamics.sim.agent.extensions.servers.util.UnknownValueUtil;
import lombok.Generated;

public class PerfLoadAverageCalc {
    private final double exp;
    private double loadAverage = 0.0;

    public PerfLoadAverageCalc(double samplingFrequency, double interval) {
        this.exp = Math.pow(Math.E, -(samplingFrequency / interval));
    }

    public void calculate(long processQueueLength) {
        if (UnknownValueUtil.isUnknownValue(processQueueLength)) {
            this.loadAverage = UnknownValueUtil.getUnknownValue();
        } else {
            this.loadAverage *= this.exp;
            this.loadAverage += (double)processQueueLength * (1.0 - this.exp);
        }
    }

    public String toString() {
        return String.format("%.4f", this.loadAverage);
    }

    @Generated
    public double getLoadAverage() {
        return this.loadAverage;
    }
}

