/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model;

import com.appdynamics.sim.agent.extensions.api.metrics.ExtensionMetricAggregatorType;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataFactory;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataLong;
import com.appdynamics.sim.agent.extensions.servers.Sim;
import com.appdynamics.sim.agent.extensions.servers.config.ReportMetricsConfig;
import com.appdynamics.sim.agent.extensions.servers.model.Component;
import com.appdynamics.sim.agent.extensions.servers.model.MetricNameUtil;
import com.google.common.base.Optional;
import com.singularity.ee.controller.api.constants.HardwarePerformanceMetricsTemplates;
import lombok.Generated;
import lombok.NonNull;

public abstract class Partition<T>
implements Component<T> {
    private final String partitionName;
    protected final MetricsService metricsService;
    private final String metricNameUtilization;
    private final String metricNameAvgWriteTime;
    private final String metricNameWriteKbPerSec;
    private final String metricNameWriteCountPerSec;
    private final String metricNameAvgReadTime;
    private final String metricNameReadKbPerSec;
    private final String metricNameReadCountPerSec;
    private final String metricNameSpaceUsed;
    private final String metricNameSpaceAvailable;
    private final String metricNameSpaceAvailablePct;
    private final RawDataFactory factory;
    private boolean firstTime;

    protected Partition(@NonNull String partitionName, @Sim @NonNull MetricsService metricsService, @NonNull RawDataFactory factory) {
        if (partitionName == null) {
            throw new NullPointerException("partitionName is marked non-null but is null");
        }
        if (metricsService == null) {
            throw new NullPointerException("metricsService is marked non-null but is null");
        }
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        this.partitionName = partitionName;
        this.metricsService = metricsService;
        this.firstTime = true;
        this.factory = factory;
        String normalizedPartitionName = MetricNameUtil.normalizeMetricName(partitionName);
        this.metricNameReadCountPerSec = HardwarePerformanceMetricsTemplates.format((String)"Hardware Resources|Disks|{0}|Reads/sec", (String)normalizedPartitionName);
        this.metricNameReadKbPerSec = HardwarePerformanceMetricsTemplates.format((String)"Hardware Resources|Disks|{0}|KB read/sec", (String)normalizedPartitionName);
        this.metricNameWriteCountPerSec = HardwarePerformanceMetricsTemplates.format((String)"Hardware Resources|Disks|{0}|Writes/sec", (String)normalizedPartitionName);
        this.metricNameWriteKbPerSec = HardwarePerformanceMetricsTemplates.format((String)"Hardware Resources|Disks|{0}|KB written/sec", (String)normalizedPartitionName);
        this.metricNameAvgReadTime = HardwarePerformanceMetricsTemplates.format((String)"Hardware Resources|Disks|{0}|Avg read time (ms)", (String)normalizedPartitionName);
        this.metricNameAvgWriteTime = HardwarePerformanceMetricsTemplates.format((String)"Hardware Resources|Disks|{0}|Avg write time (ms)", (String)normalizedPartitionName);
        this.metricNameUtilization = HardwarePerformanceMetricsTemplates.format((String)"Hardware Resources|Disks|{0}|Avg IO Utilization (%)", (String)normalizedPartitionName);
        this.metricNameSpaceUsed = HardwarePerformanceMetricsTemplates.format((String)"Hardware Resources|Disks|{0}|Space Used", (String)normalizedPartitionName);
        this.metricNameSpaceAvailable = HardwarePerformanceMetricsTemplates.format((String)"Hardware Resources|Disks|{0}|Space Available", (String)normalizedPartitionName);
        this.metricNameSpaceAvailablePct = HardwarePerformanceMetricsTemplates.format((String)"Hardware Resources|Disks|{0}|Space Available (%)", (String)normalizedPartitionName);
    }

    @Override
    public final void report(T rawData, ReportMetricsConfig reportMetricsConfig) {
        if (!this.firstTime) {
            this.doReporting(reportMetricsConfig);
        }
        this.firstTime = false;
    }

    @Override
    public String getId() {
        return this.partitionName;
    }

    public abstract Optional<String> getVolumeId();

    protected void doReporting(ReportMetricsConfig reportMetricsConfig) {
        if (reportMetricsConfig.isReportBasicMetrics()) {
            if (this.getReadCountPerSec().isPresent()) {
                this.metricsService.reportMetric(this.metricNameReadCountPerSec, ExtensionMetricAggregatorType.AVERAGE, this.getReadCountPerSec());
            }
            this.metricsService.reportMetric(this.metricNameReadKbPerSec, ExtensionMetricAggregatorType.AVERAGE, this.getReadKbPerSec());
            if (this.getWriteCountPerSec().isPresent()) {
                this.metricsService.reportMetric(this.metricNameWriteCountPerSec, ExtensionMetricAggregatorType.AVERAGE, this.getWriteCountPerSec());
            }
            this.metricsService.reportMetric(this.metricNameWriteKbPerSec, ExtensionMetricAggregatorType.AVERAGE, this.getWriteKbPerSec());
            this.metricsService.reportMetric(this.metricNameSpaceAvailable, ExtensionMetricAggregatorType.AVERAGE, this.getSpaceAvailableKb());
            this.metricsService.reportMetric(this.metricNameSpaceUsed, ExtensionMetricAggregatorType.AVERAGE, this.getSpaceUsedKb());
            this.metricsService.reportMetric(this.metricNameSpaceAvailablePct, ExtensionMetricAggregatorType.AVERAGE, this.getSpaceAvailablePct());
        }
        if (reportMetricsConfig.isReportSimMetrics()) {
            if (this.getAvgReadTimeMillis().isPresent()) {
                this.metricsService.reportMetric(this.metricNameAvgReadTime, ExtensionMetricAggregatorType.AVERAGE, this.getAvgReadTimeMillis());
            }
            if (this.getAvgWriteTimeMillis().isPresent()) {
                this.metricsService.reportMetric(this.metricNameAvgWriteTime, ExtensionMetricAggregatorType.AVERAGE, this.getAvgWriteTimeMillis());
            }
            if (this.getUtilization().isPresent()) {
                this.metricsService.reportMetric(this.metricNameUtilization, ExtensionMetricAggregatorType.AVERAGE, this.getUtilization());
            }
        }
    }

    protected abstract RawDataLong getReadCountPerSec();

    protected abstract RawDataLong getReadKbPerSec();

    protected abstract RawDataLong getWriteCountPerSec();

    protected abstract RawDataLong getWriteKbPerSec();

    protected abstract RawDataLong getUtilization();

    protected abstract RawDataLong getAvgReadTimeMillis();

    protected abstract RawDataLong getAvgWriteTimeMillis();

    protected abstract RawDataLong getSpaceAvailableKb();

    protected abstract RawDataLong getSpaceUsedKb();

    protected RawDataLong getSpaceAvailablePct() {
        RawDataLong spaceAvailable = this.getSpaceAvailableKb();
        RawDataLong baseValue = this.factory.createLong(Long.valueOf(100L));
        RawDataLong spaceTotal = spaceAvailable.add(this.getSpaceUsedKb());
        RawDataLong spaceAvailablePct = spaceAvailable.multiply(baseValue).divide(spaceTotal);
        return spaceAvailablePct;
    }

    @Generated
    public String toString() {
        return "Partition(partitionName=" + this.getPartitionName() + ")";
    }

    @Generated
    protected String getPartitionName() {
        return this.partitionName;
    }

    @Generated
    protected RawDataFactory getFactory() {
        return this.factory;
    }
}

