/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model;

import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataFactory;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataString;
import com.appdynamics.sim.agent.extensions.servers.Sim;
import com.appdynamics.sim.agent.extensions.servers.config.ReportMetricsConfig;
import com.appdynamics.sim.agent.extensions.servers.model.Component;
import com.appdynamics.sim.agent.extensions.servers.model.ComponentName;
import com.appdynamics.sim.agent.extensions.servers.model.ToggleableReporter;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import lombok.Generated;
import lombok.NonNull;

public abstract class OperatingSystem<T>
implements Component<T>,
ToggleableReporter<T> {
    private static final ComponentName COMPONENT_NAME = ComponentName.OPERATING_SYSTEM;
    private final String osName;
    protected final MachineProperties machineProperties;
    private final Predicate<ToggleableReporter<T>> isDisabledPredicate;
    protected final RawDataFactory rawDataFactory;

    protected OperatingSystem(@NonNull String osName, @Sim @NonNull MachineProperties machineProperties, @NonNull Predicate<ToggleableReporter<T>> isDisabledPredicate, @NonNull RawDataFactory rawDataFactory) {
        if (osName == null) {
            throw new NullPointerException("osName is marked non-null but is null");
        }
        if (machineProperties == null) {
            throw new NullPointerException("machineProperties is marked non-null but is null");
        }
        if (isDisabledPredicate == null) {
            throw new NullPointerException("isDisabledPredicate is marked non-null but is null");
        }
        if (rawDataFactory == null) {
            throw new NullPointerException("rawDataFactory is marked non-null but is null");
        }
        this.osName = osName;
        this.machineProperties = machineProperties;
        this.isDisabledPredicate = isDisabledPredicate;
        this.rawDataFactory = rawDataFactory;
    }

    @Override
    public void report(T rawData, ReportMetricsConfig reportMetricsConfig) {
        if (reportMetricsConfig.isReportSimMetrics()) {
            this.machineProperties.updateProperty("OS|Kernel|Name", this.getOsName(), Optional.absent());
            this.machineProperties.updateProperty("OS|Kernel|Release", this.getRelease(), Optional.absent());
            this.machineProperties.updateProperty("OS|Architecture", this.getArchitecture(), Optional.absent());
        }
    }

    @Override
    public final String getName() {
        return COMPONENT_NAME.toString();
    }

    @Override
    public boolean isDisabled() {
        return this.isDisabledPredicate.apply((Object)this);
    }

    @Override
    public String getId() {
        RawDataString rawOs = this.getOsName();
        if (!rawOs.isPresent()) {
            return this.osName;
        }
        return rawOs.get();
    }

    protected RawDataString getOsName() {
        return this.rawDataFactory.createString(Optional.of((Object)this.osName));
    }

    protected abstract RawDataString getRelease();

    protected abstract RawDataString getArchitecture();

    @Generated
    public String toString() {
        return "OperatingSystem(osName=" + String.valueOf(this.getOsName()) + ")";
    }
}

