/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model;

import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.metrics.ExtensionMetricAggregatorType;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.api.util.ReportingUtil;
import com.appdynamics.sim.agent.extensions.servers.Sim;
import com.appdynamics.sim.agent.extensions.servers.config.ReportMetricsConfig;
import com.appdynamics.sim.agent.extensions.servers.model.Component;
import com.appdynamics.sim.agent.extensions.servers.model.MetricNameUtil;
import com.appdynamics.sim.common.biz.shared.machines.SimMachineProperties;
import com.google.common.base.Optional;
import com.singularity.ee.controller.api.constants.HardwarePerformanceMetricsTemplates;
import lombok.Generated;
import lombok.NonNull;

public abstract class Network<T>
implements Component<T> {
    protected static final String NO = "no";
    protected static final String YES = "yes";
    protected static final String UNKNOWN = "unknown";
    protected static final String UP = "up";
    protected static final String DOWN = "down";
    protected static final long BITS_IN_MEGABITS = 1000000L;
    private final String networkName;
    private final MachineProperties machineProperties;
    private final MetricsService metricsService;
    private final String metricNameIncomingKb;
    private final String metricNameOutgoingKb;
    private final String metricNameIncomingPackets;
    private final String metricNameOutgoingPackets;
    private final String metricNameIncomingKbPerSec;
    private final String metricNameOutgoingKbPerSec;
    private final String metricNameIncomingPacketsPerSec;
    private final String metricNameOutgoingPacketsPerSec;
    private final String metricNameIncomingPacketErrorsPerMin;
    private final String metricNameOutgoingPacketErrorsPerMin;
    private final String metricNameUtilizationPct;
    private final String propertyNameNetworkName;
    private final String propertyNameNetworkMetricName;
    private final String propertyNameNetEnabled;
    private final String propertyNameOperational;
    private final String propertyNamePluggedIn;
    private final String propertyNameMacAddress;
    private final String propertyNameSpeed;
    private final String propertyNameDuplex;
    private final String propertyNameMtu;
    private final String propertyNameIpv4;
    private final String propertyNameIpv6;
    private final String propertyNameIpv4DefaultGateway;
    private final String propertyNameIpv6DefaultGateway;
    private final String normalizedNetworkName;
    private boolean firstTime;

    protected Network(@NonNull String networkName, @Sim @NonNull MachineProperties machineProperties, @Sim @NonNull MetricsService metricsService) {
        if (networkName == null) {
            throw new NullPointerException("networkName is marked non-null but is null");
        }
        if (machineProperties == null) {
            throw new NullPointerException("machineProperties is marked non-null but is null");
        }
        if (metricsService == null) {
            throw new NullPointerException("metricsService is marked non-null but is null");
        }
        this.networkName = networkName;
        this.machineProperties = machineProperties;
        this.metricsService = metricsService;
        this.firstTime = true;
        this.normalizedNetworkName = MetricNameUtil.normalizeMetricName(networkName);
        this.metricNameIncomingKb = HardwarePerformanceMetricsTemplates.format((String)"Hardware Resources|Network|{0}|Incoming KB", (String)this.normalizedNetworkName);
        this.metricNameOutgoingKb = HardwarePerformanceMetricsTemplates.format((String)"Hardware Resources|Network|{0}|Outgoing KB", (String)this.normalizedNetworkName);
        this.metricNameIncomingPackets = HardwarePerformanceMetricsTemplates.format((String)"Hardware Resources|Network|{0}|Incoming packets", (String)this.normalizedNetworkName);
        this.metricNameOutgoingPackets = HardwarePerformanceMetricsTemplates.format((String)"Hardware Resources|Network|{0}|Outgoing packets", (String)this.normalizedNetworkName);
        this.metricNameIncomingKbPerSec = HardwarePerformanceMetricsTemplates.format((String)"Hardware Resources|Network|{0}|Incoming KB/sec", (String)this.normalizedNetworkName);
        this.metricNameOutgoingKbPerSec = HardwarePerformanceMetricsTemplates.format((String)"Hardware Resources|Network|{0}|Outgoing KB/sec", (String)this.normalizedNetworkName);
        this.metricNameIncomingPacketsPerSec = HardwarePerformanceMetricsTemplates.format((String)"Hardware Resources|Network|{0}|Incoming packets/sec", (String)this.normalizedNetworkName);
        this.metricNameOutgoingPacketsPerSec = HardwarePerformanceMetricsTemplates.format((String)"Hardware Resources|Network|{0}|Outgoing packets/sec", (String)this.normalizedNetworkName);
        this.metricNameIncomingPacketErrorsPerMin = HardwarePerformanceMetricsTemplates.format((String)"Hardware Resources|Network|{0}|Incoming Errors/min", (String)this.normalizedNetworkName);
        this.metricNameOutgoingPacketErrorsPerMin = HardwarePerformanceMetricsTemplates.format((String)"Hardware Resources|Network|{0}|Outgoing Errors/min", (String)this.normalizedNetworkName);
        this.metricNameUtilizationPct = HardwarePerformanceMetricsTemplates.format((String)"Hardware Resources|Network|{0}|Avg Utilization (%)", (String)this.normalizedNetworkName);
        this.propertyNameNetworkName = SimMachineProperties.format((String)"Network Interface|{0}|Name", (String)networkName);
        this.propertyNameNetworkMetricName = SimMachineProperties.format((String)"Network Interface|{0}|MetricName", (String)networkName);
        this.propertyNameNetEnabled = SimMachineProperties.format((String)"Network Interface|{0}|Enabled", (String)networkName);
        this.propertyNameOperational = SimMachineProperties.format((String)"Network Interface|{0}|Operational State", (String)networkName);
        this.propertyNamePluggedIn = SimMachineProperties.format((String)"Network Interface|{0}|Plugged In", (String)networkName);
        this.propertyNameMacAddress = SimMachineProperties.format((String)"Network Interface|{0}|MAC Address", (String)networkName);
        this.propertyNameSpeed = SimMachineProperties.format((String)"Network Interface|{0}|Speed", (String)networkName);
        this.propertyNameDuplex = SimMachineProperties.format((String)"Network Interface|{0}|Duplex", (String)networkName);
        this.propertyNameMtu = SimMachineProperties.format((String)"Network Interface|{0}|MTU", (String)networkName);
        this.propertyNameIpv4 = SimMachineProperties.format((String)"Network Interface|{0}|IPv4 Address", (String)networkName);
        this.propertyNameIpv6 = SimMachineProperties.format((String)"Network Interface|{0}|IPv6 Address", (String)networkName);
        this.propertyNameIpv4DefaultGateway = SimMachineProperties.format((String)"Network Interface|{0}|IPv4 Default Gateway", (String)networkName);
        this.propertyNameIpv6DefaultGateway = SimMachineProperties.format((String)"Network Interface|{0}|IPv6 Default Gateway", (String)networkName);
    }

    @Override
    public final void report(T rawData, ReportMetricsConfig reportMetricsConfig) {
        if (!this.firstTime) {
            this.doReporting(reportMetricsConfig.isReportBasicMetrics(), reportMetricsConfig.isReportSimMetrics());
        }
        this.firstTime = false;
    }

    public void doReporting(boolean reportBasicMetrics, boolean reportSimMetrics) {
        if (reportBasicMetrics) {
            ReportingUtil.reportPerMinuteMetricSample((MetricsService)this.metricsService, (String)this.metricNameIncomingKb, (long)this.getIncomingKb());
            ReportingUtil.reportPerMinuteMetricSample((MetricsService)this.metricsService, (String)this.metricNameOutgoingKb, (long)this.getOutgoingKb());
            ReportingUtil.reportPerMinuteMetricSample((MetricsService)this.metricsService, (String)this.metricNameIncomingPackets, (long)this.getIncomingPackets());
            ReportingUtil.reportPerMinuteMetricSample((MetricsService)this.metricsService, (String)this.metricNameOutgoingPackets, (long)this.getOutgoingPackets());
            ReportingUtil.reportPerSecondMetricSample((MetricsService)this.metricsService, (String)this.metricNameIncomingKbPerSec, (long)this.getIncomingKbPerSec());
            ReportingUtil.reportPerSecondMetricSample((MetricsService)this.metricsService, (String)this.metricNameOutgoingKbPerSec, (long)this.getOutgoingKbPerSec());
            ReportingUtil.reportPerSecondMetricSample((MetricsService)this.metricsService, (String)this.metricNameIncomingPacketsPerSec, (long)this.getIncomingPacketsPerSec());
            ReportingUtil.reportPerSecondMetricSample((MetricsService)this.metricsService, (String)this.metricNameOutgoingPacketsPerSec, (long)this.getOutgoingPacketsPerSec());
        }
        if (reportSimMetrics) {
            ReportingUtil.reportPerMinuteMetricSample((MetricsService)this.metricsService, (String)this.metricNameIncomingPacketErrorsPerMin, (long)this.getIncomingPacketErrors());
            ReportingUtil.reportPerMinuteMetricSample((MetricsService)this.metricsService, (String)this.metricNameOutgoingPacketErrorsPerMin, (long)this.getOutgoingPacketErrors());
            Optional<Long> utilizationPct = this.getUtilizationPct();
            if (utilizationPct.isPresent()) {
                this.metricsService.reportMetric(this.metricNameUtilizationPct, ExtensionMetricAggregatorType.AVERAGE, ((Long)utilizationPct.get()).longValue());
            }
            this.machineProperties.updateProperty(this.propertyNameNetworkName, this.networkName);
            this.machineProperties.updateProperty(this.propertyNameNetworkMetricName, this.normalizedNetworkName);
            this.machineProperties.updateProperty(this.propertyNameNetEnabled, this.getNetEnabled());
            this.machineProperties.updateProperty(this.propertyNameOperational, this.getStatus());
            this.machineProperties.updateProperty(this.propertyNameSpeed, this.getSpeedMb());
            this.machineProperties.updateProperty(this.propertyNameMtu, this.getMtu());
            this.machineProperties.updateProperty(this.propertyNamePluggedIn, this.getPluggedIn());
            this.machineProperties.updateProperty(this.propertyNameDuplex, this.getDuplex());
            this.machineProperties.updateProperty(this.propertyNameMacAddress, this.getMacAddress());
            this.machineProperties.updateProperty(this.propertyNameIpv4, this.getIpv4Addresses());
            this.machineProperties.updateProperty(this.propertyNameIpv6, this.getIpv6Addresses());
            this.machineProperties.updateProperty(this.propertyNameIpv4DefaultGateway, this.getDefaultIpv4Gateways());
            this.machineProperties.updateProperty(this.propertyNameIpv6DefaultGateway, this.getDefaultIpv6Gateways());
        }
    }

    @Override
    public String getId() {
        return this.networkName;
    }

    protected abstract String getNetEnabled();

    protected abstract String getPluggedIn();

    protected abstract String getStatus();

    protected abstract String getDuplex();

    protected abstract String getMtu();

    protected abstract String getSpeedMb();

    protected abstract String getMacAddress();

    protected abstract String getIpv4Addresses();

    protected abstract String getIpv6Addresses();

    protected abstract String getDefaultIpv4Gateways();

    protected abstract String getDefaultIpv6Gateways();

    protected abstract long getIncomingPacketErrors();

    protected abstract long getOutgoingPacketErrors();

    protected abstract long getIncomingKbPerSec();

    protected abstract long getOutgoingKbPerSec();

    protected abstract long getIncomingPacketsPerSec();

    protected abstract long getOutgoingPacketsPerSec();

    protected abstract Optional<Long> getUtilizationPct();

    protected abstract long getIncomingKb();

    protected abstract long getOutgoingKb();

    protected abstract long getIncomingPackets();

    protected abstract long getOutgoingPackets();

    @Generated
    public String toString() {
        return "Network(networkName=" + this.getNetworkName() + ")";
    }

    @Generated
    public String getNetworkName() {
        return this.networkName;
    }
}

