/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model;

import com.appdynamics.agent.sim.configuration.bootstrap.BootstrapConfiguration;
import com.appdynamics.agent.sim.log.SimAgentRepetitiveLogger;
import com.appdynamics.sim.agent.extensions.api.metrics.ExtensionMetricAggregatorType;
import com.appdynamics.sim.agent.extensions.api.metrics.ExtensionMetricHoleHandlingType;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataFactory;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataLong;
import com.appdynamics.sim.agent.extensions.servers.ProcessProperties;
import com.appdynamics.sim.agent.extensions.servers.Sim;
import com.appdynamics.sim.agent.extensions.servers.config.ProcessMonitorConfig;
import com.appdynamics.sim.agent.extensions.servers.config.ReportMetricsConfig;
import com.appdynamics.sim.agent.extensions.servers.config.ServersMonitorConfig;
import com.appdynamics.sim.agent.extensions.servers.model.Component;
import com.appdynamics.sim.agent.extensions.servers.model.GpuMetricsProvider;
import com.appdynamics.sim.agent.extensions.servers.util.ExponentialMovingAverageUtil;
import com.appdynamics.sim.agent.extensions.servers.util.Pair;
import com.appdynamics.sim.processes.common.rest.SimProcessDtoState;
import com.appdynamics.sim.processes.common.rest.SimProcessMinimalDto;
import com.appdynamics.sim.processes.common.rest.SimProcessObservationDto;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.inject.Provider;
import com.singularity.ee.controller.api.constants.HardwarePerformanceMetricsTemplates;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MonitoredProcessClass<RAWDATA>
implements Component<RAWDATA> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MonitoredProcessClass.class);
    private static final long SLIDING_WINDOW_MILLIS = TimeUnit.MINUTES.toMillis(2L);
    private final String classId;
    private final MetricsService metricsService;
    private final Provider<ServersMonitorConfig> serversMonitorConfig;
    private final ExponentialMovingAverageUtil cpuAverage;
    private final ExponentialMovingAverageUtil memAverage;
    private final RawDataFactory factory;
    private final ProcessProperties processProperties;
    @VisibleForTesting
    private boolean firstTime;
    private boolean updated;
    protected final SimAgentRepetitiveLogger repetitiveLogger;
    protected BootstrapConfiguration bootstrapConfiguration;
    private final List<SimProcessObservationDto> filteredObservations;

    protected MonitoredProcessClass(@NonNull String classId, @Sim @NonNull MetricsService metricsService, @NonNull Provider<ServersMonitorConfig> serversMonitorConfig, @NonNull ProcessProperties processProperties, SimAgentRepetitiveLogger repetitiveLogger, RawDataFactory factory) {
        if (classId == null) {
            throw new NullPointerException("classId is marked non-null but is null");
        }
        if (metricsService == null) {
            throw new NullPointerException("metricsService is marked non-null but is null");
        }
        if (serversMonitorConfig == null) {
            throw new NullPointerException("serversMonitorConfig is marked non-null but is null");
        }
        if (processProperties == null) {
            throw new NullPointerException("processProperties is marked non-null but is null");
        }
        this.classId = classId;
        this.metricsService = metricsService;
        this.serversMonitorConfig = serversMonitorConfig;
        this.cpuAverage = new ExponentialMovingAverageUtil();
        this.memAverage = new ExponentialMovingAverageUtil();
        this.firstTime = true;
        this.updated = false;
        this.processProperties = processProperties;
        this.repetitiveLogger = repetitiveLogger;
        this.factory = factory;
        this.filteredObservations = new ArrayList<SimProcessObservationDto>(1);
    }

    @Override
    public String getId() {
        return this.classId;
    }

    @Override
    public final void update(RAWDATA rawData, ReportMetricsConfig reportMetricsConfig) {
        if (this.updated) {
            this.firstTime = false;
        }
        this.updated = true;
        this.filterObservations(rawData);
        this.updateMetrics(rawData, Collections.unmodifiableList(this.filteredObservations));
        double alpha = this.getAverageAlpha();
        if (this.getCpuUsedPercent().isPresent()) {
            this.cpuAverage.average(alpha, this.getCpuUsedPercent().get().longValue());
        }
        if (this.getMemoryUsedKb().isPresent()) {
            this.memAverage.average(alpha, this.getMemoryUsedKb().get().longValue());
        }
    }

    @VisibleForTesting
    void filterObservations(RAWDATA rawData) {
        ProcessMonitorConfig processMonitorConfig = ((ServersMonitorConfig)this.serversMonitorConfig.get()).getProcessMonitorConfig();
        ImmutableList<SimProcessObservationDto> allProcessObservations = this.getAllObservations(rawData);
        Pattern commandLineRegex = Pattern.compile(processMonitorConfig.getProcessSelectorRegex());
        long minLiveTime = processMonitorConfig.getMinLiveTimeMillisBeforeMonitoring();
        this.filteredObservations.clear();
        for (SimProcessObservationDto observationDto : allProcessObservations) {
            if (!commandLineRegex.matcher(observationDto.getCommandLine()).find() || observationDto.getLiveTime() < minLiveTime) continue;
            this.filteredObservations.add(observationDto);
        }
    }

    @Override
    public void report(RAWDATA rawData, ReportMetricsConfig reportMetricsConfig) {
        if (this.firstTime || this.filteredObservations.isEmpty()) {
            this.firstTime = false;
            return;
        }
        if (reportMetricsConfig.isReportSimMetrics()) {
            this.reportMetric("Hardware Resources|Process|{0}|Memory|Used (%)", ExtensionMetricAggregatorType.AVERAGE, this.getMemoryUsedPercent());
            this.reportMetric("Hardware Resources|Process|{0}|Memory|Used (KB)", ExtensionMetricAggregatorType.AVERAGE, this.getMemoryUsedKb());
            this.reportMetric("Hardware Resources|Process|{0}|Threads|Count", ExtensionMetricAggregatorType.AVERAGE, ExtensionMetricHoleHandlingType.RATE_COUNTER, this.getNumThreads());
            this.reportMetric("Hardware Resources|Process|{0}|Faults|Major Faults/sec", ExtensionMetricAggregatorType.AVERAGE, this.getMajorFaultsRate());
            this.reportMetric("Hardware Resources|Process|{0}|Faults|Minor Faults/sec", ExtensionMetricAggregatorType.AVERAGE, this.getMinorFaultsRate());
            this.reportMetric("Hardware Resources|Process|{0}|CPU|Used (%)", ExtensionMetricAggregatorType.AVERAGE, this.getCpuUsedPercent());
            this.reportMetric("Hardware Resources|Process|{0}|Memory|Virtual (KB)", ExtensionMetricAggregatorType.AVERAGE, this.getVirtualMemoryKb());
            this.reportMetric("Hardware Resources|Process|{0}|Count", ExtensionMetricAggregatorType.AVERAGE, ExtensionMetricHoleHandlingType.RATE_COUNTER, this.getProcessCount());
            this.reportGpuMetrics();
            if (this.bootstrapConfiguration.getProcessLevelMetricsEnabled().booleanValue()) {
                this.reportProcessLevelMetrics();
            }
            this.processProperties.addProcessObservations(this.filteredObservations);
        }
    }

    @VisibleForTesting
    void reportProcessLevelMetrics() {
        Map<RawDataLong, Pair<RawDataLong, Double>> cpuMetrics = this.getCurrentProcessCpuMetrics();
        Map<RawDataLong, Pair<RawDataLong, Double>> memoryMetrics = this.getCurrentProcessMemoryMetrics();
        Map<RawDataLong, SimProcessDtoState> stateMetrics = this.getCurrentProcessStateMetrics();
        Set<RawDataLong> pids = this.getProcessIdsToReport();
        for (RawDataLong pid : pids) {
            try {
                this.metricsService.reportMetric(HardwarePerformanceMetricsTemplates.format((String)"Hardware Resources|Process|{0}|{1}|CPU|Used (%)", (String)this.getClassId(), (String)pid.get().toString()), ExtensionMetricAggregatorType.AVERAGE, (RawDataLong)cpuMetrics.get((Object)pid).first);
                this.metricsService.reportMetric(HardwarePerformanceMetricsTemplates.format((String)"Hardware Resources|Process|{0}|{1}|Memory|Used (%)", (String)this.getClassId(), (String)pid.get().toString()), ExtensionMetricAggregatorType.AVERAGE, (RawDataLong)memoryMetrics.get((Object)pid).first);
                this.metricsService.reportMetric(HardwarePerformanceMetricsTemplates.format((String)"Hardware Resources|Process|{0}|{1}|State", (String)this.getClassId(), (String)pid.get().toString()), ExtensionMetricAggregatorType.AVERAGE, (long)stateMetrics.get(pid).ordinal());
            }
            catch (Exception e) {
                log.debug("Error reporting process metrics for PID: {}. Exception: {}", (Object)pid, (Object)e.toString());
            }
        }
        this.reportGpuProcessLevelMetrics(pids);
    }

    private void reportMetric(String metricNameTemplate, ExtensionMetricAggregatorType aggregatorType, RawDataLong value) {
        this.metricsService.reportMetric(HardwarePerformanceMetricsTemplates.format((String)metricNameTemplate, (String)this.classId), aggregatorType, value);
    }

    private void reportMetric(String metricNameTemplate, ExtensionMetricAggregatorType aggregatorType, ExtensionMetricHoleHandlingType holeHandlingType, RawDataLong value) {
        this.metricsService.reportMetric(HardwarePerformanceMetricsTemplates.format((String)metricNameTemplate, (String)this.classId), aggregatorType, holeHandlingType, value);
    }

    private Set<RawDataLong> getProcessIdsToReport() {
        return this.filteredObservations.stream().map(SimProcessMinimalDto::getProcessId).map(arg_0 -> ((RawDataFactory)this.factory).createLong(arg_0)).collect(Collectors.toSet());
    }

    private void reportGpuProcessLevelMetrics(Set<RawDataLong> pids) {
        GpuMetricsProvider provider = this.getGpuMetricsProvider();
        if (provider == null || !provider.hasGpuMetrics()) {
            return;
        }
        Map<RawDataLong, Pair<RawDataLong, RawDataLong>> gpuMetrics = provider.getProcessLevelGpuMetrics();
        for (RawDataLong pid : pids) {
            if (!gpuMetrics.containsKey(pid)) continue;
            Pair<RawDataLong, RawDataLong> gpuMetric = gpuMetrics.get(pid);
            this.metricsService.reportMetric(HardwarePerformanceMetricsTemplates.format((String)"Hardware Resources|Process|{0}|{1}|GPU|Used (%)", (String)this.getClassId(), (String)pid.get().toString()), ExtensionMetricAggregatorType.AVERAGE, (RawDataLong)gpuMetric.first);
            this.metricsService.reportMetric(HardwarePerformanceMetricsTemplates.format((String)"Hardware Resources|Process|{0}|{1}|GPU|Memory Used (%)", (String)this.getClassId(), (String)pid.get().toString()), ExtensionMetricAggregatorType.AVERAGE, (RawDataLong)gpuMetric.second);
        }
    }

    private void reportGpuMetrics() {
        GpuMetricsProvider provider = this.getGpuMetricsProvider();
        if (provider == null || !provider.hasGpuMetrics()) {
            return;
        }
        RawDataLong gpuUsedPercent = provider.getGpuUsedPercent();
        RawDataLong gpuMemoryUsedPercent = provider.getGpuMemoryUsedPercent();
        if (gpuUsedPercent != null && gpuMemoryUsedPercent != null) {
            this.reportMetric("Hardware Resources|Process|{0}|GPU|Used (%)", ExtensionMetricAggregatorType.AVERAGE, gpuUsedPercent);
            this.reportMetric("Hardware Resources|Process|{0}|GPU|Memory Used (%)", ExtensionMetricAggregatorType.AVERAGE, gpuMemoryUsedPercent);
        }
    }

    @VisibleForTesting
    void setFilteredObservations(List<SimProcessObservationDto> observations) {
        this.filteredObservations.clear();
        this.filteredObservations.addAll(observations);
    }

    @VisibleForTesting
    public double getAverageAlpha() {
        long samplingInterval = ((ServersMonitorConfig)this.serversMonitorConfig.get()).getSamplingInterval();
        double numPeriods = SLIDING_WINDOW_MILLIS / samplingInterval;
        return ExponentialMovingAverageUtil.getAlpha(numPeriods);
    }

    public Pattern getCriticalProcessSelectorPattern() {
        return ((ServersMonitorConfig)this.serversMonitorConfig.get()).getProcessMonitorConfig().getCriticalProcessSelectorPattern();
    }

    protected GpuMetricsProvider getGpuMetricsProvider() {
        return null;
    }

    protected Map<RawDataLong, Pair<RawDataLong, RawDataLong>> getCurrentProcessGpuMetrics() {
        return null;
    }

    @VisibleForTesting
    long getSlidingWindow() {
        return SLIDING_WINDOW_MILLIS;
    }

    public double getCpuUtilizationMovingAverage() {
        return this.cpuAverage.getOldValue();
    }

    public double getMemKbMovingAverage() {
        return this.memAverage.getOldValue();
    }

    @VisibleForTesting
    void setBootstrapConfiguration(BootstrapConfiguration bootstrapConfiguration) {
        this.bootstrapConfiguration = bootstrapConfiguration;
    }

    protected abstract void updateMetrics(RAWDATA var1, List<SimProcessObservationDto> var2);

    protected abstract ImmutableList<SimProcessObservationDto> getAllObservations(RAWDATA var1);

    protected abstract RawDataLong getMemoryUsedKb();

    protected abstract RawDataLong getMemoryUsedPercent();

    protected abstract RawDataLong getNumThreads();

    protected abstract RawDataLong getMajorFaultsRate();

    protected abstract RawDataLong getMinorFaultsRate();

    protected abstract RawDataLong getCpuUsedPercent();

    protected abstract RawDataLong getVirtualMemoryKb();

    protected abstract RawDataLong getProcessCount();

    public abstract Map<RawDataLong, Pair<RawDataLong, Double>> getCurrentProcessCpuMetrics();

    public abstract Map<RawDataLong, Pair<RawDataLong, Double>> getCurrentProcessMemoryMetrics();

    public abstract Map<RawDataLong, String> getCurrentProcessCommandLineMap();

    public abstract Map<RawDataLong, SimProcessDtoState> getCurrentProcessStateMetrics();

    @Generated
    public String toString() {
        return "MonitoredProcessClass(classId=" + this.getClassId() + ")";
    }

    @Generated
    public String getClassId() {
        return this.classId;
    }

    @Generated
    void setFirstTime(boolean firstTime) {
        this.firstTime = firstTime;
    }

    @Generated
    public List<SimProcessObservationDto> getFilteredObservations() {
        return this.filteredObservations;
    }
}

