/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model;

import com.appdynamics.sim.agent.extensions.api.metrics.ExtensionMetricAggregatorType;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataLong;
import com.appdynamics.sim.agent.extensions.servers.Sim;
import com.appdynamics.sim.agent.extensions.servers.config.ReportMetricsConfig;
import com.appdynamics.sim.agent.extensions.servers.model.Component;
import com.appdynamics.sim.agent.extensions.servers.model.ComponentName;
import com.appdynamics.sim.agent.extensions.servers.model.ToggleableReporter;
import com.google.common.base.Predicate;
import lombok.Generated;
import lombok.NonNull;

public abstract class Load<T>
implements Component<T>,
ToggleableReporter<T> {
    private static final ComponentName COMPONENT_NAME = ComponentName.LOAD;
    private String systemName;
    private final MetricsService metricsService;
    private final Predicate<ToggleableReporter<T>> isDisabledPredicate;

    protected Load(@NonNull String systemName, @Sim @NonNull MetricsService metricsService, @NonNull Predicate<ToggleableReporter<T>> isDisabledPredicate) {
        if (systemName == null) {
            throw new NullPointerException("systemName is marked non-null but is null");
        }
        if (metricsService == null) {
            throw new NullPointerException("metricsService is marked non-null but is null");
        }
        if (isDisabledPredicate == null) {
            throw new NullPointerException("isDisabledPredicate is marked non-null but is null");
        }
        this.systemName = systemName;
        this.metricsService = metricsService;
        this.isDisabledPredicate = isDisabledPredicate;
    }

    @Override
    public final String getName() {
        return COMPONENT_NAME.toString();
    }

    @Override
    public boolean isDisabled() {
        return this.isDisabledPredicate.apply((Object)this);
    }

    @Override
    public String getId() {
        return this.systemName;
    }

    @Override
    public void report(T rawData, ReportMetricsConfig reportMetricsConfig) {
        if (reportMetricsConfig.isReportSimMetrics()) {
            this.metricsService.reportMetric("Hardware Resources|Load|Last 1 minute", ExtensionMetricAggregatorType.OBSERVATION, this.getLoadAverage1());
            this.metricsService.reportMetric("Hardware Resources|Load|Last 5 minutes", ExtensionMetricAggregatorType.OBSERVATION, this.getLoadAverage5());
            this.metricsService.reportMetric("Hardware Resources|Load|Last 15 minutes", ExtensionMetricAggregatorType.OBSERVATION, this.getLoadAverage15());
        }
    }

    @Override
    public abstract void update(T var1, ReportMetricsConfig var2);

    protected abstract RawDataLong getLoadAverage1();

    protected abstract RawDataLong getLoadAverage5();

    protected abstract RawDataLong getLoadAverage15();

    @Generated
    public String toString() {
        return "Load(systemName=" + this.getSystemName() + ")";
    }

    @Generated
    protected String getSystemName() {
        return this.systemName;
    }
}

