/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model;

import com.appdynamics.agent.sim.log.SimAgentRepetitiveLogger;
import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.metrics.ExtensionMetricAggregatorType;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.servers.Sim;
import com.appdynamics.sim.agent.extensions.servers.config.ReportMetricsConfig;
import com.appdynamics.sim.agent.extensions.servers.model.ComponentFactory;
import com.appdynamics.sim.agent.extensions.servers.model.ComponentName;
import com.appdynamics.sim.agent.extensions.servers.model.Components;
import com.appdynamics.sim.agent.extensions.servers.model.Cpu;
import com.appdynamics.sim.agent.extensions.servers.model.ToggleableReporter;
import com.appdynamics.sim.agent.extensions.servers.model.filter.Filters;
import com.appdynamics.sim.agent.extensions.servers.model.transformer.Transformer;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;

public abstract class Cpus<T>
extends Components<T, Cpu<T>> {
    private static final ComponentName COMPONENT_NAME = ComponentName.CPUS;
    protected final MetricsService metricsService;
    private final MachineProperties machineProperties;
    protected boolean firstTime;

    protected Cpus(@NonNull SimAgentRepetitiveLogger repetitiveLogger, @NonNull ComponentFactory<T, Cpu<T>> cpuFactory, @Sim @NonNull MetricsService metricsService, @Sim @NonNull MachineProperties machineProperties, @NonNull Filters<Cpu<T>> filters, @NonNull Set<Transformer<Cpu<T>>> metadataTransformers, @NonNull Predicate<ToggleableReporter<T>> isDisabledPredicate) {
        super(repetitiveLogger, cpuFactory, filters, metadataTransformers, isDisabledPredicate);
        if (repetitiveLogger == null) {
            throw new NullPointerException("repetitiveLogger is marked non-null but is null");
        }
        if (cpuFactory == null) {
            throw new NullPointerException("cpuFactory is marked non-null but is null");
        }
        if (metricsService == null) {
            throw new NullPointerException("metricsService is marked non-null but is null");
        }
        if (machineProperties == null) {
            throw new NullPointerException("machineProperties is marked non-null but is null");
        }
        if (filters == null) {
            throw new NullPointerException("filters is marked non-null but is null");
        }
        if (metadataTransformers == null) {
            throw new NullPointerException("metadataTransformers is marked non-null but is null");
        }
        if (isDisabledPredicate == null) {
            throw new NullPointerException("isDisabledPredicate is marked non-null but is null");
        }
        this.metricsService = metricsService;
        this.machineProperties = machineProperties;
        this.firstTime = true;
    }

    @Override
    protected void doAggregateReporting(T rawData, Map<String, ? extends Cpu<T>> components, ReportMetricsConfig reportMetricsConfig) {
        if (this.firstTime) {
            this.firstTime = false;
            return;
        }
        if (reportMetricsConfig.isReportBasicMetrics()) {
            this.metricsService.reportMetric("Hardware Resources|CPU|%Busy", ExtensionMetricAggregatorType.AVERAGE, this.getPercentBusy());
            this.metricsService.reportMetric("Hardware Resources|CPU|%Idle", ExtensionMetricAggregatorType.AVERAGE, this.getPercentIdle());
            Optional<Long> percentStolenOpt = this.getPercentStolen();
            if (percentStolenOpt.isPresent()) {
                this.metricsService.reportMetric("Hardware Resources|CPU|%Stolen", ExtensionMetricAggregatorType.AVERAGE, ((Long)percentStolenOpt.get()).longValue());
            }
        }
        if (reportMetricsConfig.isReportSimMetrics()) {
            Optional<Long> percentIoWaitOpt;
            Optional<Long> percentSoftIrqOpt;
            Optional<Long> percentIrqOpt;
            Optional<Long> percentNiceOpt;
            Optional<Long> percentSystemOpt;
            Optional<Long> percentUserOpt = this.getPercentUser();
            if (percentUserOpt.isPresent()) {
                this.metricsService.reportMetric("Hardware Resources|CPU|User", ExtensionMetricAggregatorType.AVERAGE, ((Long)percentUserOpt.get()).longValue());
            }
            if ((percentSystemOpt = this.getPercentSystem()).isPresent()) {
                this.metricsService.reportMetric("Hardware Resources|CPU|System", ExtensionMetricAggregatorType.AVERAGE, ((Long)percentSystemOpt.get()).longValue());
            }
            if ((percentNiceOpt = this.getPercentNice()).isPresent()) {
                this.metricsService.reportMetric("Hardware Resources|CPU|%Nice", ExtensionMetricAggregatorType.AVERAGE, ((Long)percentNiceOpt.get()).longValue());
            }
            if ((percentIrqOpt = this.getPercentIRQ()).isPresent()) {
                this.metricsService.reportMetric("Hardware Resources|CPU|%Irq", ExtensionMetricAggregatorType.AVERAGE, ((Long)percentIrqOpt.get()).longValue());
            }
            if ((percentSoftIrqOpt = this.getPercentSoftIRQ()).isPresent()) {
                this.metricsService.reportMetric("Hardware Resources|CPU|%SoftIrq", ExtensionMetricAggregatorType.AVERAGE, ((Long)percentSoftIrqOpt.get()).longValue());
            }
            if ((percentIoWaitOpt = this.getPercentIoWait()).isPresent()) {
                this.metricsService.reportMetric("Hardware Resources|CPU|IOWait", ExtensionMetricAggregatorType.AVERAGE, ((Long)percentIoWaitOpt.get()).longValue());
            }
            for (String property : this.getOsSpecificProperties().keySet()) {
                this.machineProperties.updateProperty(property, this.getOsSpecificProperties().get(property));
            }
            long totalLogicalProcessors = 0L;
            for (String cpuId : components.keySet()) {
                totalLogicalProcessors += components.get(cpuId).getNumLogicalProcessors().get().longValue();
            }
            this.machineProperties.updateProperty("Total|CPU|Logical Processor Count", String.valueOf(totalLogicalProcessors));
        }
        if (reportMetricsConfig.isReportPercentileMetrics()) {
            this.metricsService.reportMetric("Hardware Resources|CPU|%Busy 95th Percentile", ExtensionMetricAggregatorType.PERCENTILE, this.getPercentBusy());
        }
    }

    @Override
    public final String getName() {
        return COMPONENT_NAME.toString();
    }

    protected abstract long getPercentBusy();

    protected abstract Optional<Long> getPercentStolen();

    protected abstract long getPercentIdle();

    protected abstract Optional<Long> getPercentUser();

    protected abstract Optional<Long> getPercentSystem();

    protected Map<String, String> getOsSpecificProperties() {
        return Collections.emptyMap();
    }

    protected abstract Optional<Long> getPercentNice();

    protected abstract Optional<Long> getPercentIRQ();

    protected abstract Optional<Long> getPercentSoftIRQ();

    protected abstract Optional<Long> getPercentIoWait();

    @Override
    @Generated
    public String toString() {
        return "Cpus(super=" + super.toString() + ")";
    }
}

