/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model;

import com.appdynamics.agent.sim.log.SimAgentRepetitiveLogger;
import com.appdynamics.sim.agent.extensions.servers.config.ReportMetricsConfig;
import com.appdynamics.sim.agent.extensions.servers.model.Component;
import com.appdynamics.sim.agent.extensions.servers.model.ComponentFactory;
import com.appdynamics.sim.agent.extensions.servers.model.ToggleableReporter;
import com.appdynamics.sim.agent.extensions.servers.model.filter.Filters;
import com.appdynamics.sim.agent.extensions.servers.model.filter.PrioritizationFilter;
import com.appdynamics.sim.agent.extensions.servers.model.filter.PrioritizationFilterResult;
import com.appdynamics.sim.agent.extensions.servers.model.filter.ReductionFilter;
import com.appdynamics.sim.agent.extensions.servers.model.filter.ReductionFilterResult;
import com.appdynamics.sim.agent.extensions.servers.model.transformer.Transformer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Components<RAWDATA, COMPONENT extends Component<RAWDATA>>
implements ToggleableReporter<RAWDATA> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Components.class);
    private final SimAgentRepetitiveLogger repetitiveLogger;
    private final ComponentFactory<RAWDATA, ? extends COMPONENT> componentFactory;
    private final Map<String, COMPONENT> components;
    private final Filters<COMPONENT> filters;
    private final Predicate<ToggleableReporter<RAWDATA>> isDisabledPredicate;
    private final Set<Transformer<COMPONENT>> metadataTransformers;

    protected Components(@NonNull SimAgentRepetitiveLogger repetitiveLogger, @NonNull ComponentFactory<RAWDATA, ? extends COMPONENT> componentFactory, @NonNull Filters<COMPONENT> filters, @NonNull Set<Transformer<COMPONENT>> metadataTransformers, @NonNull Predicate<ToggleableReporter<RAWDATA>> isDisabledPredicate) {
        if (repetitiveLogger == null) {
            throw new NullPointerException("repetitiveLogger is marked non-null but is null");
        }
        if (componentFactory == null) {
            throw new NullPointerException("componentFactory is marked non-null but is null");
        }
        if (filters == null) {
            throw new NullPointerException("filters is marked non-null but is null");
        }
        if (metadataTransformers == null) {
            throw new NullPointerException("metadataTransformers is marked non-null but is null");
        }
        if (isDisabledPredicate == null) {
            throw new NullPointerException("isDisabledPredicate is marked non-null but is null");
        }
        this.repetitiveLogger = repetitiveLogger;
        this.componentFactory = componentFactory;
        this.filters = filters;
        this.metadataTransformers = metadataTransformers;
        this.components = new LinkedHashMap<String, COMPONENT>();
        this.isDisabledPredicate = isDisabledPredicate;
    }

    @Override
    public boolean isDisabled() {
        return this.isDisabledPredicate.apply((Object)this);
    }

    @Override
    public final void update(RAWDATA rawData, ReportMetricsConfig reportMetricsConfig) {
        Set<String> currentIds = this.extractIds(rawData);
        this.components.keySet().retainAll(currentIds);
        for (String id : currentIds) {
            if (this.components.containsKey(id)) continue;
            COMPONENT component = this.componentFactory.make(id);
            this.components.put(id, component);
        }
        for (Component component : this.components.values()) {
            component.update(rawData, reportMetricsConfig);
        }
        this.doAggregateUpdate(rawData);
    }

    protected void doAggregateUpdate(RAWDATA rawData) {
    }

    @Override
    public final void report(RAWDATA rawData, ReportMetricsConfig reportMetricsConfig) {
        log.debug("The components before filtering: {}", this.components.values());
        Set<COMPONENT> filteredComponents = this.applyFilters((Set<COMPONENT>)ImmutableSet.copyOf(this.components.values()), reportMetricsConfig);
        this.applyMetadataTransformersToComponents(this.metadataTransformers, filteredComponents);
        log.debug("The components after filtering: {}", filteredComponents);
        for (Component component : filteredComponents) {
            component.report(rawData, reportMetricsConfig);
        }
        this.doAggregateReporting(rawData, this.components, reportMetricsConfig);
    }

    @VisibleForTesting
    protected void applyMetadataTransformersToComponents(@NonNull Set<Transformer<COMPONENT>> transformers, @NonNull Collection<COMPONENT> components) {
        if (transformers == null) {
            throw new NullPointerException("transformers is marked non-null but is null");
        }
        if (components == null) {
            throw new NullPointerException("components is marked non-null but is null");
        }
        for (Transformer<COMPONENT> transformer : transformers) {
            try {
                transformer.apply(components);
            }
            catch (RuntimeException e) {
                this.repetitiveLogger.warn(log, "Error executing transformer " + transformer.getClass().getSimpleName() + ". Reason: " + e.getMessage(), new Object[0]);
            }
        }
    }

    @VisibleForTesting
    protected Set<COMPONENT> applyFilters(@NonNull Set<COMPONENT> components, @NonNull ReportMetricsConfig configuration) {
        if (components == null) {
            throw new NullPointerException("components is marked non-null but is null");
        }
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        Optional<PrioritizationFilterResult<COMPONENT>> prioritization = this.applyPrioritizationFilters(Collections.unmodifiableSet(components), configuration);
        components = this.orderComponents(prioritization, components);
        Set<COMPONENT> remainingComponents = this.applyReductionFilters(prioritization, components).getFilteredComponents();
        return Collections.unmodifiableSet(remainingComponents);
    }

    private Optional<PrioritizationFilterResult<COMPONENT>> applyPrioritizationFilters(@NonNull Set<COMPONENT> components, @NonNull ReportMetricsConfig configuration) {
        if (components == null) {
            throw new NullPointerException("components is marked non-null but is null");
        }
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        Optional filterResult = Optional.absent();
        for (PrioritizationFilter<COMPONENT> filter : this.filters.getPrioritizationFilters()) {
            filterResult = Optional.of(filter.apply(filterResult, components, configuration));
        }
        return filterResult;
    }

    private Set<COMPONENT> orderComponents(@NonNull Optional<PrioritizationFilterResult<COMPONENT>> prioritization, @NonNull Set<COMPONENT> components) {
        if (prioritization == null) {
            throw new NullPointerException("prioritization is marked non-null but is null");
        }
        if (components == null) {
            throw new NullPointerException("components is marked non-null but is null");
        }
        LinkedHashSet<Component<Object>> orderedComponents = new LinkedHashSet<Component<Object>>();
        if (prioritization.isPresent()) {
            for (Component component : ((PrioritizationFilterResult)prioritization.get()).getPrioritizedComponents()) {
                if (!components.contains(component)) continue;
                orderedComponents.add(component);
            }
        }
        orderedComponents.addAll(components);
        return ImmutableSet.copyOf(orderedComponents);
    }

    protected ReductionFilterResult<COMPONENT> applyReductionFilters(@NonNull Optional<PrioritizationFilterResult<COMPONENT>> prioritization, @NonNull Set<COMPONENT> components) {
        if (prioritization == null) {
            throw new NullPointerException("prioritization is marked non-null but is null");
        }
        if (components == null) {
            throw new NullPointerException("components is marked non-null but is null");
        }
        ReductionFilterResult<COMPONENT> filterResult = ReductionFilterResult.of(components);
        for (ReductionFilter<COMPONENT> filter : this.filters.getReductionFilters()) {
            filterResult = filter.apply(prioritization, filterResult);
        }
        return filterResult;
    }

    protected void doAggregateReporting(RAWDATA rawData, Map<String, ? extends COMPONENT> components, ReportMetricsConfig reportMetricsConfig) {
    }

    protected abstract Set<String> extractIds(RAWDATA var1);

    @Generated
    public String toString() {
        return "Components(components=" + String.valueOf(this.components) + ")";
    }
}

