/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model;

import com.appdynamics.sim.agent.extensions.api.metrics.ExtensionMetricAggregatorType;
import com.appdynamics.sim.agent.extensions.api.metrics.ExtensionMetricHoleHandlingType;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.servers.Sim;
import com.appdynamics.sim.agent.extensions.servers.config.ReportMetricsConfig;
import com.appdynamics.sim.agent.extensions.servers.model.ComponentName;
import com.appdynamics.sim.agent.extensions.servers.model.ToggleableReporter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.inject.Inject;
import lombok.NonNull;

class Availability<T>
implements ToggleableReporter<T> {
    private static final int ONE_HUNDRED = 100;
    private static final ComponentName COMPONENT_NAME = ComponentName.AVAILABILITY;
    private final MetricsService metricsService;
    private final Predicate<ToggleableReporter<T>> isDisabledPredicate;

    @Inject
    @VisibleForTesting
    Availability(@Sim @NonNull MetricsService metricsService, @NonNull Predicate<ToggleableReporter<T>> isDisabledPredicate) {
        if (metricsService == null) {
            throw new NullPointerException("metricsService is marked non-null but is null");
        }
        if (isDisabledPredicate == null) {
            throw new NullPointerException("isDisabledPredicate is marked non-null but is null");
        }
        this.metricsService = metricsService;
        this.isDisabledPredicate = isDisabledPredicate;
    }

    @Override
    public void update(T rawData, ReportMetricsConfig reportMetricsConfig) {
    }

    @Override
    public final void report(T rawData, ReportMetricsConfig reportMetricsConfig) {
        if (reportMetricsConfig.isReportSimMetrics()) {
            this.metricsService.reportMetric("Hardware Resources|Machine|Availability", ExtensionMetricAggregatorType.AVAILABILITY, ExtensionMetricHoleHandlingType.RATE_COUNTER, 100L);
        }
    }

    @Override
    public final String getName() {
        return COMPONENT_NAME.toString();
    }

    @Override
    public boolean isDisabled() {
        return this.isDisabledPredicate.apply((Object)this);
    }
}

