/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.config;

import com.appdynamics.sim.agent.extensions.servers.config.AwsTagsConfig;
import com.appdynamics.sim.agent.extensions.servers.config.AzureTagsConfig;
import com.appdynamics.sim.agent.extensions.servers.config.K8sNodeTagsConfig;
import com.appdynamics.sim.agent.extensions.servers.config.K8sTagsConfig;
import com.appdynamics.sim.agent.extensions.servers.config.ServersMonitorConfig;
import com.appdynamics.sim.agent.extensions.servers.config.ServiceNowTagsConfig;
import com.appdynamics.sim.agent.extensions.servers.config.SmartAgentTagsConfig;
import com.appdynamics.sim.agent.extensions.servers.config.UrlMonitoringConfig;
import com.appdynamics.sim.common.biz.shared.machines.AgentMonitorConfig;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.Provider;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServersMonitorConfigResolver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServersMonitorConfigResolver.class);
    private static final int MISSING_CONFIG = 0;
    private final Provider<ServersMonitorConfig> agentServerMonitorConfigProvider;
    private final Provider<AgentMonitorConfig> controllerServerMonitoringConfigProvider;

    @Inject
    public ServersMonitorConfigResolver(Provider<ServersMonitorConfig> agentServerMonitoringConfigProvider, Provider<AgentMonitorConfig> controllerServerMonitoringConfigProvider) {
        this.agentServerMonitorConfigProvider = agentServerMonitoringConfigProvider;
        this.controllerServerMonitoringConfigProvider = controllerServerMonitoringConfigProvider;
    }

    public int getProcessMaxNumberMonitoredClasses() {
        return this.getProcessMaxNumberMonitoredClasses((Optional<ServersMonitorConfig>)Optional.fromNullable((Object)((ServersMonitorConfig)this.agentServerMonitorConfigProvider.get())), (Optional<AgentMonitorConfig>)Optional.fromNullable((Object)((AgentMonitorConfig)this.controllerServerMonitoringConfigProvider.get())));
    }

    public int getProcessMaxNumberMonitoredClasses(Optional<ServersMonitorConfig> serverConfig, Optional<AgentMonitorConfig> fromControllerConfig) {
        if (!serverConfig.isPresent() && !fromControllerConfig.isPresent()) {
            log.warn("Both Server Monitor Config and Agent Monitor Config is undefined, setting maximum process classes to be 0.");
            return 0;
        }
        if (!serverConfig.isPresent()) {
            Optional maxProcessClass = ((AgentMonitorConfig)fromControllerConfig.get()).getSafeMaxProcessClasses();
            if (maxProcessClass.isPresent()) {
                int maxProcessClassInt = (Integer)maxProcessClass.get();
                log.debug("Setting the max process config to {}", (Object)maxProcessClassInt);
                return maxProcessClassInt;
            }
            log.debug("Server Monitor Config is missing and Agent Monitor Config max process config is undefined, setting maximum process classes to be 0.");
            return 0;
        }
        int fromAgent = ((ServersMonitorConfig)serverConfig.get()).getProcessMonitorConfig().getMaxNumberMonitoredClasses();
        if (!fromControllerConfig.isPresent() || !((AgentMonitorConfig)fromControllerConfig.get()).getSafeMaxProcessClasses().isPresent()) {
            log.debug("Controller max process config is undefined, setting it to server configuration from agent: {}", (Object)fromAgent);
            return fromAgent;
        }
        int fromController = (Integer)((AgentMonitorConfig)fromControllerConfig.get()).getSafeMaxProcessClasses().get();
        int maxProcessClasses = Math.min(fromAgent, fromController);
        log.trace("Server max process config: {}, Controller max process config: {}, setting it to: {}", new Object[]{fromAgent, fromController, maxProcessClasses});
        return maxProcessClasses;
    }

    public boolean isPercentileMonitoringEnabled() {
        boolean agentPercentileMonitoringEnabled = ((ServersMonitorConfig)this.agentServerMonitorConfigProvider.get()).getPercentileMonitorConfig().getPercentileEnabled();
        boolean controllerPercentileMonitoringEnabled = ((AgentMonitorConfig)this.controllerServerMonitoringConfigProvider.get()).isPercentileMonitoringAllowed();
        log.trace("Server percentileEnabled: {}, Controller percentileMonitoringAllowed: {}", (Object)agentPercentileMonitoringEnabled, (Object)controllerPercentileMonitoringEnabled);
        return agentPercentileMonitoringEnabled && controllerPercentileMonitoringEnabled;
    }

    public boolean isAwsTagsEnabled() {
        boolean awsTagsEnabled = this.getAwsTagsConfig().getEnabled();
        boolean controllerAwsTagsEnabled = ((AgentMonitorConfig)this.controllerServerMonitoringConfigProvider.get()).isAwsTagsEnabled();
        log.debug("Server AwsTagsEnabled: {}, Controller AwsTagsEnabled: {}", (Object)awsTagsEnabled, (Object)controllerAwsTagsEnabled);
        return awsTagsEnabled && controllerAwsTagsEnabled;
    }

    public boolean isAzureTagsEnabled() {
        boolean azureTagsEnabled = this.getAzureTagsConfig().getEnabled();
        boolean controllerAzureTagsEnabled = ((AgentMonitorConfig)this.controllerServerMonitoringConfigProvider.get()).isAzureTagsEnabled();
        log.debug("Server AzureTagsEnabled: {}, Controller AzureTagsEnabled: {}", (Object)azureTagsEnabled, (Object)controllerAzureTagsEnabled);
        return azureTagsEnabled && controllerAzureTagsEnabled;
    }

    public boolean isK8sTagsEnabled() {
        boolean k8sTagsEnabled = this.getK8sTagsConfig().getEnabled();
        boolean controllerK8sTagsEnabled = ((AgentMonitorConfig)this.controllerServerMonitoringConfigProvider.get()).isK8sTagsEnabled();
        log.debug("Server K8sTagsEnabled: {}, Controller K8sTagsEnabled: {}", (Object)k8sTagsEnabled, (Object)controllerK8sTagsEnabled);
        return k8sTagsEnabled && controllerK8sTagsEnabled;
    }

    public boolean isK8sNodeTagsEnabled() {
        boolean k8sNodeTagsEnabled = this.getK8sNodeTagsConfig().getEnabled();
        return k8sNodeTagsEnabled;
    }

    public boolean isSmartAgentTagsEnabled() {
        boolean smartAgentTagsEnabled = this.getSmartAgentTagsConfig().getEnabled();
        return smartAgentTagsEnabled;
    }

    public boolean isServiceNowTagsEnabled() {
        boolean serviceNowTagsEnabled = this.getServiceNowTagsConfig().getEnabled();
        return serviceNowTagsEnabled;
    }

    public boolean isUrlMonitoringConfigEnabled() {
        boolean pingUrlConfigEnabled = this.getUrlMonitoringConfig().getEnabled();
        return pingUrlConfigEnabled;
    }

    public AwsTagsConfig getAwsTagsConfig() {
        return ((ServersMonitorConfig)this.agentServerMonitorConfigProvider.get()).getAwsTagsConfig();
    }

    public AzureTagsConfig getAzureTagsConfig() {
        return ((ServersMonitorConfig)this.agentServerMonitorConfigProvider.get()).getAzureTagsConfig();
    }

    public K8sTagsConfig getK8sTagsConfig() {
        return ((ServersMonitorConfig)this.agentServerMonitorConfigProvider.get()).getK8sTagsConfig();
    }

    public K8sNodeTagsConfig getK8sNodeTagsConfig() {
        return ((ServersMonitorConfig)this.agentServerMonitorConfigProvider.get()).getK8sNodeTagsConfig();
    }

    public SmartAgentTagsConfig getSmartAgentTagsConfig() {
        return ((ServersMonitorConfig)this.agentServerMonitorConfigProvider.get()).getSmartAgentTagsConfig();
    }

    public ServiceNowTagsConfig getServiceNowTagsConfig() {
        return ((ServersMonitorConfig)this.agentServerMonitorConfigProvider.get()).getServiceNowTagsConfig();
    }

    public UrlMonitoringConfig getUrlMonitoringConfig() {
        return ((ServersMonitorConfig)this.agentServerMonitorConfigProvider.get()).getUrlMonitoringConfig();
    }
}

