/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.config;

import com.appdynamics.sim.agent.extensions.servers.config.ComponentConfigMapBuilder;
import com.appdynamics.sim.agent.extensions.servers.config.ComponentMonitorConfig;
import com.appdynamics.sim.agent.extensions.servers.config.ConfigConstraintViolation;
import com.appdynamics.sim.agent.extensions.servers.config.PercentileMonitorConfig;
import com.appdynamics.sim.agent.extensions.servers.config.ServersMonitorConfig;
import com.appdynamics.sim.agent.extensions.servers.model.ComponentName;
import com.appdynamics.voltron.configuration.CustomValidator;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

public class ServersMonitorConfigBusinessValidator
implements CustomValidator<ServersMonitorConfig> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServersMonitorConfigBusinessValidator.class);
    static final long MIN_SAMPLING_INTERVAL = 1000L;
    static final long MAX_SAMPLING_INTERVAL = 60000L;
    static final long MAX_PERCENTILE_SAMPLING_INTERVAL = 5000L;
    private static final Set<ComponentName> PERCENTILE_SUPPORTED_COMPONENTS = ImmutableSet.of((Object)((Object)ComponentName.CPUS), (Object)((Object)ComponentName.MEMORY), (Object)((Object)ComponentName.VOLUMES), (Object)((Object)ComponentName.PARTITIONS));
    private static final String ROOT_VIOLATION_MESSAGE = "Error occurred while validating ServersMonitoring.yml";
    @Inject(optional=true)
    private Map<ComponentName, Set<ComponentName>> componentDependencyMapInjected;

    public void validate(String name, ServersMonitorConfig serversMonitorConfig) {
        Map<ComponentName, ComponentMonitorConfig> componentMonitorConfigMap = ComponentConfigMapBuilder.buildComponentConfigMap(serversMonitorConfig);
        ImmutableSet.Builder constraintViolationBuilder = ImmutableSet.builder();
        Set<ConstraintViolation<ServersMonitorConfig>> samplingIntervalViolations = this.validateComponentsSamplingInterval(componentMonitorConfigMap, serversMonitorConfig);
        constraintViolationBuilder.addAll(samplingIntervalViolations);
        Set<ConstraintViolation<ServersMonitorConfig>> dependencyConstraintViolations = this.validateDependentComponents(componentMonitorConfigMap);
        constraintViolationBuilder.addAll(dependencyConstraintViolations);
        ImmutableSet constraintViolations = constraintViolationBuilder.build();
        if (!constraintViolations.isEmpty()) {
            String msg = ServersMonitorConfigBusinessValidator.buildValidationExceptionMessage(constraintViolations);
            throw new ConstraintViolationException(msg, (Set)constraintViolations);
        }
    }

    private Set<ConstraintViolation<ServersMonitorConfig>> validateComponentsSamplingInterval(Map<ComponentName, ComponentMonitorConfig> componentMonitorConfigMap, ServersMonitorConfig serversMonitorConfig) {
        ImmutableSet.Builder constraintViolations = ImmutableSet.builder();
        HashSet samplingIntervals = Sets.newHashSet();
        long standardSamplingInterval = serversMonitorConfig.getSamplingInterval();
        PercentileMonitorConfig percentileMonitorConfig = serversMonitorConfig.getPercentileMonitorConfig();
        boolean isPercentileEnabled = percentileMonitorConfig.getPercentileEnabled();
        for (Map.Entry<ComponentName, ComponentMonitorConfig> componentConfigurationEntry : componentMonitorConfigMap.entrySet()) {
            ComponentName componentName = componentConfigurationEntry.getKey();
            ComponentMonitorConfig componentMonitorConfig = componentConfigurationEntry.getValue();
            long componentSamplingInterval = standardSamplingInterval;
            if (componentMonitorConfig.getSamplingInterval().isPresent()) {
                componentSamplingInterval = (Long)componentMonitorConfig.getSamplingInterval().get();
            }
            samplingIntervals.add(componentSamplingInterval);
            if (componentSamplingInterval < 1000L) {
                constraintViolations.add(this.buildViolation("'samplingInterval' for {} is smaller than the minimum valid value - {}. 'samplingInterval' can be set for each component or at the root level.", new Object[]{componentName, 1000L}));
                continue;
            }
            if (isPercentileEnabled && PERCENTILE_SUPPORTED_COMPONENTS.contains((Object)componentName)) {
                if (componentSamplingInterval <= 5000L) continue;
                constraintViolations.add(this.buildViolation("'samplingInterval' for {} is greater than the maximum valid value - {} for percentile supported components when percentile metrics are enabled. 'samplingInterval' can be set for each component or at the root level.", new Object[]{componentName, 5000L}));
                continue;
            }
            if (componentSamplingInterval <= 60000L) continue;
            constraintViolations.add(this.buildViolation("'samplingInterval' for {} is greater than the maximum valid value - {}. 'samplingInterval' can be set for each component or at the root level.", new Object[]{componentName, 60000L}));
        }
        if ((long)samplingIntervals.size() > serversMonitorConfig.getSamplingIntervalCountLimit()) {
            constraintViolations.add(this.buildViolation("Number of different sampling intervals for components is - {} which is more than the limit - {}. The number of sampling intervals limit can be configured with 'samplingIntervalCountLimit' \n Note: A high number of different sampling intervals may impact performance.", new Object[]{samplingIntervals.size(), serversMonitorConfig.getSamplingIntervalCountLimit()}));
        }
        return constraintViolations.build();
    }

    private Set<ConstraintViolation<ServersMonitorConfig>> validateDependentComponents(Map<ComponentName, ComponentMonitorConfig> componentMonitorConfigMap) {
        ImmutableSet.Builder constraintViolations = ImmutableSet.builder();
        Optional componentDependencyMap = Optional.fromNullable(this.componentDependencyMapInjected);
        if (componentDependencyMap.isPresent()) {
            for (Map.Entry dependencyEntry : ((Map)componentDependencyMap.get()).entrySet()) {
                ComponentMonitorConfig componentConfiguration;
                ComponentName componentName = (ComponentName)((Object)dependencyEntry.getKey());
                Set dependents = (Set)dependencyEntry.getValue();
                if (dependents == null || dependents.isEmpty() || !(componentConfiguration = componentMonitorConfigMap.get((Object)componentName)).getEnabled().booleanValue()) continue;
                for (ComponentName dependentComponent : dependents) {
                    ComponentMonitorConfig dependentComponentConfiguration = componentMonitorConfigMap.get((Object)dependentComponent);
                    if (dependentComponentConfiguration.getEnabled().booleanValue()) continue;
                    constraintViolations.add(this.buildViolation("{} depends on {}. {} is not enabled.", new Object[]{componentName, dependentComponent, dependentComponent}));
                }
            }
        }
        return constraintViolations.build();
    }

    private ConstraintViolation<ServersMonitorConfig> buildViolation(String message, Object[] argArray) {
        return new ConfigConstraintViolation<ServersMonitorConfig>(MessageFormatter.arrayFormat((String)message, (Object[])argArray).getMessage());
    }

    private static <T> String buildValidationExceptionMessage(Set<ConstraintViolation<T>> violations) {
        StringBuilder sb = new StringBuilder(ROOT_VIOLATION_MESSAGE).append("\n");
        sb.append("violations - ");
        for (ConstraintViolation<T> violation : violations) {
            sb.append("\n").append(violation.getMessage()).append("\n");
        }
        return sb.toString();
    }
}

