/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.config;

import com.appdynamics.sim.agent.extensions.servers.config.ComponentMonitorConfig;
import com.appdynamics.sim.agent.extensions.servers.model.transformer.TransformerConfig;
import com.appdynamics.voltron.utils.annotations.FollowObject;
import com.appdynamics.voltron.utils.overrides.OverrideIfBlank;
import com.appdynamics.voltron.utils.overrides.RegexValidation;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessMonitorConfig
implements ComponentMonitorConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessMonitorConfig.class);
    private static final int DEFAULT_MAX_CLASS_ID_LENGTH = 50;
    private static final String DEFAULT_PROCESS_SELECTOR_REGEX = "^.+[^]]$";
    private static final long DEFAULT_MINIMUM_LIVE_TIME_BEFORE_MONITORING = 60000L;
    private static final int DEFAULT_MAX_NUM_MONITORED_CLASSES = 0;
    private static final String DEFAULT_PROCESS_CLASS_SELECTOR = "";
    private static final String DEFAULT_PROCESS_CLASS_WHITELIST_REGEX = "";
    private static final List<TransformerConfig> DEFAULT_TRANSFORMERS = Collections.emptyList();
    private static final Optional<Pattern> DEFAULT_PROCESS_CLASS_SELECTOR_PATTERN = Optional.absent();
    private static final Map<String, String> DEFAULT_PROCESS_CLASS_SELECTOR_REGEX_MAP = Collections.emptyMap();
    private static final Optional<Long> DEFAULT_SAMPLING_INTERVAL = Optional.absent();
    private static final boolean DEFAULT_ENABLED = true;
    private static final String DEFAULT_CRITICAL_PROCESS_SELECTOR_REGEX = "redis|postgres|nginx|mysql";
    private static final Pattern DEFAULT_CRITICAL_PROCESS_SELECTOR_PATTERN = Pattern.compile("redis|postgres|nginx|mysql");
    @NotNull
    private Optional<Long> samplingInterval = DEFAULT_SAMPLING_INTERVAL;
    @NotNull
    @OverrideIfBlank(value="true")
    private Boolean enabled = true;
    @Max(value=200L)
    @OverrideIfBlank(value="50")
    private @Max(value=200L) int maxClassIdLength = 50;
    @NotNull
    @OverrideIfBlank(value="^.+[^]]$")
    private String processSelectorRegex = "^.+[^]]$";
    @Min(value=0L)
    @OverrideIfBlank(value="60000")
    private @Min(value=0L) long minLiveTimeMillisBeforeMonitoring = 60000L;
    @Min(value=0L)
    @OverrideIfBlank(value="0")
    @VisibleForTesting
    private @Min(value=0L) int maxNumberMonitoredClasses = 0;
    @NotNull
    @OverrideIfBlank(value="")
    @RegexValidation
    private String defaultProcessClassSelector = "";
    @NotNull
    @JsonIgnore
    private Optional<Pattern> defaultProcessClassSelectorPattern = DEFAULT_PROCESS_CLASS_SELECTOR_PATTERN;
    @NotNull
    @OverrideIfBlank(value="redis|postgres|nginx|mysql")
    @RegexValidation
    private String criticalProcessSelectorRegex = "redis|postgres|nginx|mysql";
    @NotNull
    private Pattern criticalProcessSelectorPattern = DEFAULT_CRITICAL_PROCESS_SELECTOR_PATTERN;
    @NotNull
    @RegexValidation
    private Map<String, String> processClassSelectorRegexList = DEFAULT_PROCESS_CLASS_SELECTOR_REGEX_MAP;
    @NotNull
    @FollowObject
    private List<TransformerConfig> commandLineTransformers = DEFAULT_TRANSFORMERS;

    private ProcessMonitorConfig(int maxClassIdLength, long minLiveTimeMillisBeforeMonitoring, String processSelectorRegex, int maxNumberMonitoredClasses, String defaultProcessClassSelector, Map<String, String> processClassSelectorRegexList, List<TransformerConfig> commandLineTransformers, String criticalProcessSelectorRegex) {
        this.maxClassIdLength = maxClassIdLength;
        this.minLiveTimeMillisBeforeMonitoring = minLiveTimeMillisBeforeMonitoring;
        this.setProcessSelectorRegex(processSelectorRegex);
        this.maxNumberMonitoredClasses = maxNumberMonitoredClasses;
        this.setDefaultProcessClassSelector(defaultProcessClassSelector);
        this.processClassSelectorRegexList = processClassSelectorRegexList;
        this.setCommandLineTransformers(commandLineTransformers);
        this.setCriticalProcessSelectorRegex(criticalProcessSelectorRegex);
    }

    private void setCommandLineTransformers(List<TransformerConfig> commandLineTransformers) {
        this.commandLineTransformers = (List)Optional.fromNullable(commandLineTransformers).or(DEFAULT_TRANSFORMERS);
    }

    private void setDefaultProcessClassSelector(String defaultProcessClassSelector) {
        if (StringUtils.isBlank((CharSequence)defaultProcessClassSelector)) {
            this.defaultProcessClassSelector = "";
            this.defaultProcessClassSelectorPattern = DEFAULT_PROCESS_CLASS_SELECTOR_PATTERN;
        } else {
            this.defaultProcessClassSelector = defaultProcessClassSelector;
            this.defaultProcessClassSelectorPattern = Optional.of((Object)Pattern.compile(defaultProcessClassSelector));
        }
    }

    public void setProcessSelectorRegex(String processSelectorRegex) {
        try {
            Pattern.compile(processSelectorRegex);
            this.processSelectorRegex = processSelectorRegex;
        }
        catch (Exception e) {
            this.processSelectorRegex = DEFAULT_PROCESS_SELECTOR_REGEX;
            log.warn("ServerMonitoring.yml contains invalid input for processSelectorRegex: " + processSelectorRegex + ". Use default value: ^.+[^]]$");
        }
    }

    public void setCriticalProcessSelectorRegex(String criticalProcessSelectorRegex) {
        if (StringUtils.isBlank((CharSequence)criticalProcessSelectorRegex)) {
            this.criticalProcessSelectorRegex = DEFAULT_CRITICAL_PROCESS_SELECTOR_REGEX;
            this.criticalProcessSelectorPattern = DEFAULT_CRITICAL_PROCESS_SELECTOR_PATTERN;
        } else {
            try {
                Pattern.compile(criticalProcessSelectorRegex);
                this.criticalProcessSelectorRegex = criticalProcessSelectorRegex;
                this.criticalProcessSelectorPattern = Pattern.compile(criticalProcessSelectorRegex);
            }
            catch (Exception e) {
                this.criticalProcessSelectorRegex = DEFAULT_CRITICAL_PROCESS_SELECTOR_REGEX;
                this.criticalProcessSelectorPattern = DEFAULT_CRITICAL_PROCESS_SELECTOR_PATTERN;
                log.warn("ServerMonitoring.yml contains invalid input for criticalProcessSelectorRegex: " + criticalProcessSelectorRegex + ". Using default regex value: redis|postgres|nginx|mysql");
            }
        }
    }

    @Generated
    public static ProcessMonitorConfigBuilder builder() {
        return new ProcessMonitorConfigBuilder();
    }

    @Override
    @Generated
    public Optional<Long> getSamplingInterval() {
        return this.samplingInterval;
    }

    @Override
    @Generated
    public Boolean getEnabled() {
        return this.enabled;
    }

    @Generated
    public int getMaxClassIdLength() {
        return this.maxClassIdLength;
    }

    @Generated
    public String getProcessSelectorRegex() {
        return this.processSelectorRegex;
    }

    @Generated
    public long getMinLiveTimeMillisBeforeMonitoring() {
        return this.minLiveTimeMillisBeforeMonitoring;
    }

    @Generated
    public int getMaxNumberMonitoredClasses() {
        return this.maxNumberMonitoredClasses;
    }

    @Generated
    public String getDefaultProcessClassSelector() {
        return this.defaultProcessClassSelector;
    }

    @Generated
    public Optional<Pattern> getDefaultProcessClassSelectorPattern() {
        return this.defaultProcessClassSelectorPattern;
    }

    @Generated
    public String getCriticalProcessSelectorRegex() {
        return this.criticalProcessSelectorRegex;
    }

    @Generated
    public Pattern getCriticalProcessSelectorPattern() {
        return this.criticalProcessSelectorPattern;
    }

    @Generated
    public Map<String, String> getProcessClassSelectorRegexList() {
        return this.processClassSelectorRegexList;
    }

    @Generated
    public List<TransformerConfig> getCommandLineTransformers() {
        return this.commandLineTransformers;
    }

    @Generated
    public void setSamplingInterval(Optional<Long> samplingInterval) {
        this.samplingInterval = samplingInterval;
    }

    @Generated
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setMaxClassIdLength(int maxClassIdLength) {
        this.maxClassIdLength = maxClassIdLength;
    }

    @Generated
    public void setMinLiveTimeMillisBeforeMonitoring(long minLiveTimeMillisBeforeMonitoring) {
        this.minLiveTimeMillisBeforeMonitoring = minLiveTimeMillisBeforeMonitoring;
    }

    @Generated
    public void setProcessClassSelectorRegexList(Map<String, String> processClassSelectorRegexList) {
        this.processClassSelectorRegexList = processClassSelectorRegexList;
    }

    @Generated
    public String toString() {
        return "ProcessMonitorConfig(samplingInterval=" + String.valueOf(this.getSamplingInterval()) + ", enabled=" + this.getEnabled() + ", maxClassIdLength=" + this.getMaxClassIdLength() + ", processSelectorRegex=" + this.getProcessSelectorRegex() + ", minLiveTimeMillisBeforeMonitoring=" + this.getMinLiveTimeMillisBeforeMonitoring() + ", maxNumberMonitoredClasses=" + this.getMaxNumberMonitoredClasses() + ", defaultProcessClassSelector=" + this.getDefaultProcessClassSelector() + ", defaultProcessClassSelectorPattern=" + String.valueOf(this.getDefaultProcessClassSelectorPattern()) + ", criticalProcessSelectorRegex=" + this.getCriticalProcessSelectorRegex() + ", criticalProcessSelectorPattern=" + String.valueOf(this.getCriticalProcessSelectorPattern()) + ", processClassSelectorRegexList=" + String.valueOf(this.getProcessClassSelectorRegexList()) + ", commandLineTransformers=" + String.valueOf(this.getCommandLineTransformers()) + ")";
    }

    @Generated
    public ProcessMonitorConfig(Optional<Long> samplingInterval, Boolean enabled, int maxClassIdLength, String processSelectorRegex, long minLiveTimeMillisBeforeMonitoring, int maxNumberMonitoredClasses, String defaultProcessClassSelector, Optional<Pattern> defaultProcessClassSelectorPattern, String criticalProcessSelectorRegex, Pattern criticalProcessSelectorPattern, Map<String, String> processClassSelectorRegexList, List<TransformerConfig> commandLineTransformers) {
        this.samplingInterval = samplingInterval;
        this.enabled = enabled;
        this.maxClassIdLength = maxClassIdLength;
        this.processSelectorRegex = processSelectorRegex;
        this.minLiveTimeMillisBeforeMonitoring = minLiveTimeMillisBeforeMonitoring;
        this.maxNumberMonitoredClasses = maxNumberMonitoredClasses;
        this.defaultProcessClassSelector = defaultProcessClassSelector;
        this.defaultProcessClassSelectorPattern = defaultProcessClassSelectorPattern;
        this.criticalProcessSelectorRegex = criticalProcessSelectorRegex;
        this.criticalProcessSelectorPattern = criticalProcessSelectorPattern;
        this.processClassSelectorRegexList = processClassSelectorRegexList;
        this.commandLineTransformers = commandLineTransformers;
    }

    @Generated
    public ProcessMonitorConfig() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProcessMonitorConfig)) {
            return false;
        }
        ProcessMonitorConfig other = (ProcessMonitorConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxClassIdLength() != other.getMaxClassIdLength()) {
            return false;
        }
        if (this.getMinLiveTimeMillisBeforeMonitoring() != other.getMinLiveTimeMillisBeforeMonitoring()) {
            return false;
        }
        if (this.getMaxNumberMonitoredClasses() != other.getMaxNumberMonitoredClasses()) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        Optional<Long> this$samplingInterval = this.getSamplingInterval();
        Optional<Long> other$samplingInterval = other.getSamplingInterval();
        if (this$samplingInterval == null ? other$samplingInterval != null : !this$samplingInterval.equals(other$samplingInterval)) {
            return false;
        }
        String this$processSelectorRegex = this.getProcessSelectorRegex();
        String other$processSelectorRegex = other.getProcessSelectorRegex();
        if (this$processSelectorRegex == null ? other$processSelectorRegex != null : !this$processSelectorRegex.equals(other$processSelectorRegex)) {
            return false;
        }
        String this$defaultProcessClassSelector = this.getDefaultProcessClassSelector();
        String other$defaultProcessClassSelector = other.getDefaultProcessClassSelector();
        if (this$defaultProcessClassSelector == null ? other$defaultProcessClassSelector != null : !this$defaultProcessClassSelector.equals(other$defaultProcessClassSelector)) {
            return false;
        }
        String this$criticalProcessSelectorRegex = this.getCriticalProcessSelectorRegex();
        String other$criticalProcessSelectorRegex = other.getCriticalProcessSelectorRegex();
        if (this$criticalProcessSelectorRegex == null ? other$criticalProcessSelectorRegex != null : !this$criticalProcessSelectorRegex.equals(other$criticalProcessSelectorRegex)) {
            return false;
        }
        Pattern this$criticalProcessSelectorPattern = this.getCriticalProcessSelectorPattern();
        Pattern other$criticalProcessSelectorPattern = other.getCriticalProcessSelectorPattern();
        if (this$criticalProcessSelectorPattern == null ? other$criticalProcessSelectorPattern != null : !this$criticalProcessSelectorPattern.equals(other$criticalProcessSelectorPattern)) {
            return false;
        }
        Map<String, String> this$processClassSelectorRegexList = this.getProcessClassSelectorRegexList();
        Map<String, String> other$processClassSelectorRegexList = other.getProcessClassSelectorRegexList();
        if (this$processClassSelectorRegexList == null ? other$processClassSelectorRegexList != null : !((Object)this$processClassSelectorRegexList).equals(other$processClassSelectorRegexList)) {
            return false;
        }
        List<TransformerConfig> this$commandLineTransformers = this.getCommandLineTransformers();
        List<TransformerConfig> other$commandLineTransformers = other.getCommandLineTransformers();
        return !(this$commandLineTransformers == null ? other$commandLineTransformers != null : !((Object)this$commandLineTransformers).equals(other$commandLineTransformers));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ProcessMonitorConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxClassIdLength();
        long $minLiveTimeMillisBeforeMonitoring = this.getMinLiveTimeMillisBeforeMonitoring();
        result = result * 59 + (int)($minLiveTimeMillisBeforeMonitoring >>> 32 ^ $minLiveTimeMillisBeforeMonitoring);
        result = result * 59 + this.getMaxNumberMonitoredClasses();
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        Optional<Long> $samplingInterval = this.getSamplingInterval();
        result = result * 59 + ($samplingInterval == null ? 43 : $samplingInterval.hashCode());
        String $processSelectorRegex = this.getProcessSelectorRegex();
        result = result * 59 + ($processSelectorRegex == null ? 43 : $processSelectorRegex.hashCode());
        String $defaultProcessClassSelector = this.getDefaultProcessClassSelector();
        result = result * 59 + ($defaultProcessClassSelector == null ? 43 : $defaultProcessClassSelector.hashCode());
        String $criticalProcessSelectorRegex = this.getCriticalProcessSelectorRegex();
        result = result * 59 + ($criticalProcessSelectorRegex == null ? 43 : $criticalProcessSelectorRegex.hashCode());
        Pattern $criticalProcessSelectorPattern = this.getCriticalProcessSelectorPattern();
        result = result * 59 + ($criticalProcessSelectorPattern == null ? 43 : $criticalProcessSelectorPattern.hashCode());
        Map<String, String> $processClassSelectorRegexList = this.getProcessClassSelectorRegexList();
        result = result * 59 + ($processClassSelectorRegexList == null ? 43 : ((Object)$processClassSelectorRegexList).hashCode());
        List<TransformerConfig> $commandLineTransformers = this.getCommandLineTransformers();
        result = result * 59 + ($commandLineTransformers == null ? 43 : ((Object)$commandLineTransformers).hashCode());
        return result;
    }

    @Generated
    public void setMaxNumberMonitoredClasses(int maxNumberMonitoredClasses) {
        this.maxNumberMonitoredClasses = maxNumberMonitoredClasses;
    }

    @Generated
    public static class ProcessMonitorConfigBuilder {
        @Generated
        private int maxClassIdLength;
        @Generated
        private long minLiveTimeMillisBeforeMonitoring;
        @Generated
        private String processSelectorRegex;
        @Generated
        private int maxNumberMonitoredClasses;
        @Generated
        private String defaultProcessClassSelector;
        @Generated
        private Map<String, String> processClassSelectorRegexList;
        @Generated
        private List<TransformerConfig> commandLineTransformers;
        @Generated
        private String criticalProcessSelectorRegex;

        @Generated
        ProcessMonitorConfigBuilder() {
        }

        @Generated
        public ProcessMonitorConfigBuilder maxClassIdLength(int maxClassIdLength) {
            this.maxClassIdLength = maxClassIdLength;
            return this;
        }

        @Generated
        public ProcessMonitorConfigBuilder minLiveTimeMillisBeforeMonitoring(long minLiveTimeMillisBeforeMonitoring) {
            this.minLiveTimeMillisBeforeMonitoring = minLiveTimeMillisBeforeMonitoring;
            return this;
        }

        @Generated
        public ProcessMonitorConfigBuilder processSelectorRegex(String processSelectorRegex) {
            this.processSelectorRegex = processSelectorRegex;
            return this;
        }

        @Generated
        public ProcessMonitorConfigBuilder maxNumberMonitoredClasses(int maxNumberMonitoredClasses) {
            this.maxNumberMonitoredClasses = maxNumberMonitoredClasses;
            return this;
        }

        @Generated
        public ProcessMonitorConfigBuilder defaultProcessClassSelector(String defaultProcessClassSelector) {
            this.defaultProcessClassSelector = defaultProcessClassSelector;
            return this;
        }

        @Generated
        public ProcessMonitorConfigBuilder processClassSelectorRegexList(Map<String, String> processClassSelectorRegexList) {
            this.processClassSelectorRegexList = processClassSelectorRegexList;
            return this;
        }

        @Generated
        public ProcessMonitorConfigBuilder commandLineTransformers(List<TransformerConfig> commandLineTransformers) {
            this.commandLineTransformers = commandLineTransformers;
            return this;
        }

        @Generated
        public ProcessMonitorConfigBuilder criticalProcessSelectorRegex(String criticalProcessSelectorRegex) {
            this.criticalProcessSelectorRegex = criticalProcessSelectorRegex;
            return this;
        }

        @Generated
        public ProcessMonitorConfig build() {
            return new ProcessMonitorConfig(this.maxClassIdLength, this.minLiveTimeMillisBeforeMonitoring, this.processSelectorRegex, this.maxNumberMonitoredClasses, this.defaultProcessClassSelector, this.processClassSelectorRegexList, this.commandLineTransformers, this.criticalProcessSelectorRegex);
        }

        @Generated
        public String toString() {
            return "ProcessMonitorConfig.ProcessMonitorConfigBuilder(maxClassIdLength=" + this.maxClassIdLength + ", minLiveTimeMillisBeforeMonitoring=" + this.minLiveTimeMillisBeforeMonitoring + ", processSelectorRegex=" + this.processSelectorRegex + ", maxNumberMonitoredClasses=" + this.maxNumberMonitoredClasses + ", defaultProcessClassSelector=" + this.defaultProcessClassSelector + ", processClassSelectorRegexList=" + String.valueOf(this.processClassSelectorRegexList) + ", commandLineTransformers=" + String.valueOf(this.commandLineTransformers) + ", criticalProcessSelectorRegex=" + this.criticalProcessSelectorRegex + ")";
        }
    }
}

