/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.config;

import com.appdynamics.sim.agent.extensions.servers.config.ComponentMonitorConfig;
import com.appdynamics.voltron.utils.overrides.OverrideIfBlank;
import com.appdynamics.voltron.utils.overrides.RegexValidation;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import java.util.regex.Pattern;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class NetworkMonitorConfig
implements ComponentMonitorConfig {
    private static final int DEFAULT_MAX_NUM_NETWORKS = 0;
    private static final String DEFAULT_NETWORK_BLACKLIST_SELECTOR_REGEX = "";
    private static final Optional<Pattern> DEFAULT_NETWORK_BLACKLIST_SELECTOR_PATTERN = Optional.absent();
    private static final String DEFAULT_NETWORK_WHITELIST_SELECTOR_REGEX = "";
    private static final Optional<Pattern> DEFAULT_NETWORK_WHITELIST_SELECTOR_PATTERN = Optional.absent();
    private static final Optional<Long> DEFAULT_SAMPLING_INTERVAL = Optional.absent();
    private static final boolean DEFAULT_ENABLED = true;
    @NotNull
    private Optional<Long> samplingInterval = DEFAULT_SAMPLING_INTERVAL;
    @NotNull
    @OverrideIfBlank(value="true")
    private Boolean enabled = true;
    @Min(value=0L)
    @OverrideIfBlank(value="0")
    @VisibleForTesting
    private @Min(value=0L) int maxNumberNetworks = 0;
    @NotNull
    @RegexValidation
    private String blacklistSelectorRegex = "";
    @NotNull
    @JsonIgnore
    private Optional<Pattern> blacklistSelectorPattern = DEFAULT_NETWORK_BLACKLIST_SELECTOR_PATTERN;
    @NotNull
    @RegexValidation
    private String whitelistSelectorRegex = "";
    @NotNull
    @JsonIgnore
    private Optional<Pattern> whitelistSelectorPattern = DEFAULT_NETWORK_WHITELIST_SELECTOR_PATTERN;

    public void setBlacklistSelectorRegex(String selectorRegex) {
        if (StringUtils.isBlank((CharSequence)selectorRegex)) {
            this.blacklistSelectorRegex = "";
            this.blacklistSelectorPattern = DEFAULT_NETWORK_BLACKLIST_SELECTOR_PATTERN;
        } else {
            this.blacklistSelectorRegex = selectorRegex;
            this.blacklistSelectorPattern = Optional.of((Object)Pattern.compile(selectorRegex));
        }
    }

    public void setWhitelistSelectorRegex(String selectorRegex) {
        if (StringUtils.isBlank((CharSequence)selectorRegex)) {
            this.whitelistSelectorRegex = "";
            this.whitelistSelectorPattern = DEFAULT_NETWORK_WHITELIST_SELECTOR_PATTERN;
        } else {
            this.whitelistSelectorRegex = selectorRegex;
            this.whitelistSelectorPattern = Optional.of((Object)Pattern.compile(selectorRegex));
        }
    }

    @Generated
    public NetworkMonitorConfig() {
    }

    @Override
    @Generated
    public Optional<Long> getSamplingInterval() {
        return this.samplingInterval;
    }

    @Override
    @Generated
    public Boolean getEnabled() {
        return this.enabled;
    }

    @Generated
    public int getMaxNumberNetworks() {
        return this.maxNumberNetworks;
    }

    @Generated
    public String getBlacklistSelectorRegex() {
        return this.blacklistSelectorRegex;
    }

    @Generated
    public Optional<Pattern> getBlacklistSelectorPattern() {
        return this.blacklistSelectorPattern;
    }

    @Generated
    public String getWhitelistSelectorRegex() {
        return this.whitelistSelectorRegex;
    }

    @Generated
    public Optional<Pattern> getWhitelistSelectorPattern() {
        return this.whitelistSelectorPattern;
    }

    @Generated
    public void setSamplingInterval(Optional<Long> samplingInterval) {
        this.samplingInterval = samplingInterval;
    }

    @Generated
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public String toString() {
        return "NetworkMonitorConfig(samplingInterval=" + String.valueOf(this.getSamplingInterval()) + ", enabled=" + this.getEnabled() + ", maxNumberNetworks=" + this.getMaxNumberNetworks() + ", blacklistSelectorRegex=" + this.getBlacklistSelectorRegex() + ", blacklistSelectorPattern=" + String.valueOf(this.getBlacklistSelectorPattern()) + ", whitelistSelectorRegex=" + this.getWhitelistSelectorRegex() + ", whitelistSelectorPattern=" + String.valueOf(this.getWhitelistSelectorPattern()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NetworkMonitorConfig)) {
            return false;
        }
        NetworkMonitorConfig other = (NetworkMonitorConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxNumberNetworks() != other.getMaxNumberNetworks()) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        Optional<Long> this$samplingInterval = this.getSamplingInterval();
        Optional<Long> other$samplingInterval = other.getSamplingInterval();
        if (this$samplingInterval == null ? other$samplingInterval != null : !this$samplingInterval.equals(other$samplingInterval)) {
            return false;
        }
        String this$blacklistSelectorRegex = this.getBlacklistSelectorRegex();
        String other$blacklistSelectorRegex = other.getBlacklistSelectorRegex();
        if (this$blacklistSelectorRegex == null ? other$blacklistSelectorRegex != null : !this$blacklistSelectorRegex.equals(other$blacklistSelectorRegex)) {
            return false;
        }
        String this$whitelistSelectorRegex = this.getWhitelistSelectorRegex();
        String other$whitelistSelectorRegex = other.getWhitelistSelectorRegex();
        return !(this$whitelistSelectorRegex == null ? other$whitelistSelectorRegex != null : !this$whitelistSelectorRegex.equals(other$whitelistSelectorRegex));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof NetworkMonitorConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxNumberNetworks();
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        Optional<Long> $samplingInterval = this.getSamplingInterval();
        result = result * 59 + ($samplingInterval == null ? 43 : $samplingInterval.hashCode());
        String $blacklistSelectorRegex = this.getBlacklistSelectorRegex();
        result = result * 59 + ($blacklistSelectorRegex == null ? 43 : $blacklistSelectorRegex.hashCode());
        String $whitelistSelectorRegex = this.getWhitelistSelectorRegex();
        result = result * 59 + ($whitelistSelectorRegex == null ? 43 : $whitelistSelectorRegex.hashCode());
        return result;
    }

    @Generated
    public void setMaxNumberNetworks(int maxNumberNetworks) {
        this.maxNumberNetworks = maxNumberNetworks;
    }
}

