/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.collector;

import com.appdynamics.agent.sim.extensions.scheduling.CollectorProcess;
import com.appdynamics.sim.agent.extensions.api.scheduling.Scheduler;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawCollectorUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RawCollectorUtil.class);
    private static final Map<String, String> EMPTY_ENV_VARS_MAP = Collections.emptyMap();
    private static final String SPACE = " ";
    private final Scheduler scheduler;
    static final String UTF_8_NAME = "UTF8";
    static final String CANONICAL_UTF_8_NAME = "UTF-8";
    public static final String ERROR_RESETTING_STREAM_LOG = "Encountered error resetting the stdout stream: {}";
    public static final String ERROR_CONVERTING_STDOUT_LOG = "Error converting stdout to JSON {}";
    public static final String MARK_UNSUPPORTED_LOG = "The stdout stream cannot be marked and reset to be processed when the collector script times out";
    public static final String DATA_FROM_TIMEOUT_LOG = "Even though the collector script timed out, we were still able to collect this data before the timeout {}";

    @Inject
    public RawCollectorUtil(@CollectorProcess Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public <T> Optional<T> runCollector(Class<T> rawDataClass, ICollectorProcessBuilder processBuilder, ObjectMapper objectMapper, long maxCollectionTimeMillis) {
        return this.runCollector(rawDataClass, processBuilder, objectMapper, (Optional<List<String>>)Optional.absent(), EMPTY_ENV_VARS_MAP, maxCollectionTimeMillis);
    }

    public <T> Optional<T> runCollector(Class<T> rawDataClass, ICollectorProcessBuilder processBuilder, ObjectMapper objectMapper, Optional<List<String>> processParameters, long maxCollectionTimeMillis) {
        return this.runCollector(rawDataClass, processBuilder, objectMapper, processParameters, EMPTY_ENV_VARS_MAP, maxCollectionTimeMillis);
    }

    void killProcessAndDescendants(Process process) {
        this.killProcessAndDescendants(process.toHandle(), 100);
    }

    private void killProcessAndDescendants(ProcessHandle process, int recurrenceLimit) {
        if (recurrenceLimit > 0) {
            List<ProcessHandle> children = process.children().collect(Collectors.toList());
            process.destroy();
            children.forEach(child -> this.killProcessAndDescendants((ProcessHandle)child, recurrenceLimit - 1));
        } else {
            log.error("Maximum recursion depth of" + recurrenceLimit + " reached while terminating child processes. Stopped terminating the processes. Potential infinite loop detected");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public <T> Optional<T> runCollector(Class<T> rawDataClass, ICollectorProcessBuilder processBuilder, ObjectMapper objectMapper, Optional<List<String>> processParameters, Map<String, String> environmentVars, long maxCollectionTimeMillis) {
        Process process;
        log.debug("Starting collector script with parameters: " + (processParameters.isPresent() ? String.join((CharSequence)", ", (Iterable)processParameters.get()) : ""));
        try {
            process = processBuilder.start(processParameters, environmentVars);
        }
        catch (IOException e) {
            log.error("Could not start process: ", (Throwable)e);
            return Optional.absent();
        }
        InputStream stdOutStream = process.getInputStream();
        InputStream stdErrStream = process.getErrorStream();
        ExecutorService stdOutExecutorService = Executors.newSingleThreadExecutor(r -> new Thread(r, "StdOut Reader"));
        ExecutorService stdErrExecutorService = Executors.newSingleThreadExecutor(r -> new Thread(r, "StdErr Reader"));
        CountDownLatch countDownLatch = new CountDownLatch(2);
        StringBuilder stdOut = new StringBuilder();
        StringBuilder stdErr = new StringBuilder();
        ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
        ScheduledFuture<?> timeoutTask = scheduler.schedule(() -> {
            log.warn("Timeout hit after {} ms", (Object)maxCollectionTimeMillis);
            try {
                this.killProcessAndDescendants(process);
                stdOutStream.close();
                stdErrStream.close();
            }
            catch (IOException e) {
                log.warn("Error closing streams", (Throwable)e);
            }
        }, maxCollectionTimeMillis, TimeUnit.MILLISECONDS);
        stdOutExecutorService.execute(() -> {
            BufferedReader reader = new BufferedReader(new InputStreamReader(stdOutStream));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    stdOut.append(line).append(System.lineSeparator());
                }
            }
            catch (IOException e) {
                log.warn("Interrupted reading from StdOut stream", (Throwable)e);
            }
            finally {
                timeoutTask.cancel(true);
                stdOutExecutorService.shutdown();
                countDownLatch.countDown();
            }
        });
        stdErrExecutorService.execute(() -> {
            BufferedReader reader = new BufferedReader(new InputStreamReader(stdErrStream));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    stdErr.append(line).append(System.lineSeparator());
                }
            }
            catch (IOException e) {
                log.warn("Interrupted reading from StdErr stream", (Throwable)e);
            }
            finally {
                stdErrExecutorService.shutdown();
                countDownLatch.countDown();
            }
        });
        log.debug("Waiting for collector process with parameters: " + (processParameters.isPresent() ? String.join((CharSequence)", ", (Iterable)processParameters.get()) : "") + "to finish");
        try {
            countDownLatch.await();
            String standardOutput = stdOut.toString();
            String standardError = stdErr.toString();
            if (!StringUtils.isBlank((CharSequence)standardError)) {
                log.debug("The collector script returned with these messages:\n {}", (Object)standardError);
            }
            log.trace("The stdout returned from the collector script ran with parameters:" + (processParameters.isPresent() ? String.join((CharSequence)", ", (Iterable)processParameters.get()) : "") + ": {}", (Object)standardOutput);
            Optional<T> optional = this.processRawData(rawDataClass, objectMapper, standardOutput);
            return optional;
        }
        catch (InterruptedException e) {
            log.warn("Interrupted processing Raw Data: " + e.getMessage());
        }
        finally {
            try {
                if (stdOutStream != null) {
                    stdOutStream.close();
                }
                if (stdErrStream != null) {
                    stdErrStream.close();
                }
            }
            catch (IOException e) {
                log.warn("Streams could not be closed but data was collected: ", (Throwable)e);
            }
            timeoutTask.cancel(true);
            scheduler.shutdown();
        }
        log.warn("Returning empty value due to problems with processing raw data");
        return Optional.absent();
    }

    private <T> T readValueBasedOnEncoding(Class<T> rawDataClass, ObjectMapper objectMapper, String stdout) throws IOException {
        String modifiedStdout = this.modifyStdoutIfJSONIsMalformed(stdout);
        return (T)objectMapper.readValue(modifiedStdout, rawDataClass);
    }

    private String modifyStdoutIfJSONIsMalformed(String stdout) {
        String modifiedStdout = RawCollectorUtil.fixJSONIfNecessary(stdout);
        if (!stdout.equals(modifiedStdout)) {
            log.warn("JSON payload was malformed so the modified stdout is: {}", (Object)modifiedStdout);
        }
        return modifiedStdout;
    }

    @VisibleForTesting
    <T> Optional<T> processRawData(Class<T> rawDataClass, ObjectMapper objectMapper, String stdout) {
        log.debug("Reading output from collector script");
        Object retVal = null;
        try {
            retVal = this.readValueBasedOnEncoding(rawDataClass, objectMapper, stdout);
        }
        catch (IOException e) {
            log.warn("An error occurred while running the collector script. Enable debug logging for more information", (Throwable)e);
        }
        return Optional.fromNullable(retVal);
    }

    @VisibleForTesting
    static String fixJSONIfNecessary(String stdout) {
        if (stdout == null || stdout.trim().isEmpty()) {
            return "{}";
        }
        int openCurlyBraceCounter = 0;
        int closedCurlyBraceCounter = 0;
        boolean inString = false;
        boolean escape = false;
        for (int i = 0; i < stdout.length(); ++i) {
            char c = stdout.charAt(i);
            if (c == '\"' && !escape) {
                boolean bl = inString = !inString;
            }
            if (!inString) {
                if (c == '{') {
                    ++openCurlyBraceCounter;
                }
                if (c == '}') {
                    ++closedCurlyBraceCounter;
                }
            }
            escape = c == '\\' && !escape;
        }
        if (closedCurlyBraceCounter == 0) {
            return "{}";
        }
        if (openCurlyBraceCounter == closedCurlyBraceCounter) {
            return stdout;
        }
        int lastBraceIndex = stdout.lastIndexOf("}");
        if (lastBraceIndex == -1) {
            return "{}";
        }
        String modifiedJSONString = stdout.substring(0, lastBraceIndex + 1);
        openCurlyBraceCounter = 0;
        closedCurlyBraceCounter = 0;
        inString = false;
        escape = false;
        for (int i = 0; i < modifiedJSONString.length(); ++i) {
            char c = modifiedJSONString.charAt(i);
            if (c == '\"' && !escape) {
                boolean bl = inString = !inString;
            }
            if (!inString) {
                if (c == '{') {
                    ++openCurlyBraceCounter;
                }
                if (c == '}') {
                    ++closedCurlyBraceCounter;
                }
            }
            escape = c == '\\' && !escape;
        }
        int missingClosings = openCurlyBraceCounter - closedCurlyBraceCounter;
        StringBuilder sb = new StringBuilder(modifiedJSONString);
        for (int i = 0; i < missingClosings; ++i) {
            sb.append("}");
        }
        return sb.toString();
    }

    public static interface ICollectorProcessBuilder {
        public Process start(Optional<List<String>> var1, Map<String, String> var2) throws IOException;

        public List<String> getCommand();

        public Optional<String> getCollectorScriptContent();
    }

    public static class LocalCollectorProcessBuilder
    implements ICollectorProcessBuilder {
        private List<String> command;
        private Optional<String> collectorScriptContent;

        @Override
        public Process start(Optional<List<String>> processParameters, Map<String, String> environmentVars) throws IOException {
            Process startProcess;
            List<String> commandToExecute = this.command;
            if (this.collectorScriptContent.isPresent()) {
                startProcess = this.createProcessBuilder(commandToExecute, environmentVars).start();
                try (OutputStream stdin = startProcess.getOutputStream();){
                    String machineAgentScriptString = (String)this.collectorScriptContent.get();
                    stdin.write(machineAgentScriptString.getBytes());
                    if (processParameters.isPresent()) {
                        Joiner joiner = Joiner.on((String)RawCollectorUtil.SPACE);
                        String parametersInString = joiner.join((Iterable)processParameters.get());
                        stdin.write(parametersInString.getBytes());
                    }
                }
                catch (IOException e) {
                    log.warn("Could not pipe into stdin", (Throwable)e);
                }
            } else {
                if (processParameters.isPresent()) {
                    commandToExecute = new LinkedList<String>(this.command);
                    commandToExecute.addAll((Collection)processParameters.get());
                }
                startProcess = this.createProcessBuilder(commandToExecute, environmentVars).start();
            }
            return startProcess;
        }

        ProcessBuilder createProcessBuilder(List<String> command, Map<String, String> environmentVars) {
            ProcessBuilder processBuilder = new ProcessBuilder(command);
            processBuilder.environment().putAll(environmentVars);
            return processBuilder;
        }

        @Override
        @Generated
        public List<String> getCommand() {
            return this.command;
        }

        @Override
        @Generated
        public Optional<String> getCollectorScriptContent() {
            return this.collectorScriptContent;
        }

        @Generated
        public void setCommand(List<String> command) {
            this.command = command;
        }

        @Generated
        public void setCollectorScriptContent(Optional<String> collectorScriptContent) {
            this.collectorScriptContent = collectorScriptContent;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LocalCollectorProcessBuilder)) {
                return false;
            }
            LocalCollectorProcessBuilder other = (LocalCollectorProcessBuilder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$command = this.getCommand();
            List<String> other$command = other.getCommand();
            if (this$command == null ? other$command != null : !((Object)this$command).equals(other$command)) {
                return false;
            }
            Optional<String> this$collectorScriptContent = this.getCollectorScriptContent();
            Optional<String> other$collectorScriptContent = other.getCollectorScriptContent();
            return !(this$collectorScriptContent == null ? other$collectorScriptContent != null : !this$collectorScriptContent.equals(other$collectorScriptContent));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LocalCollectorProcessBuilder;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $command = this.getCommand();
            result = result * 59 + ($command == null ? 43 : ((Object)$command).hashCode());
            Optional<String> $collectorScriptContent = this.getCollectorScriptContent();
            result = result * 59 + ($collectorScriptContent == null ? 43 : $collectorScriptContent.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "RawCollectorUtil.LocalCollectorProcessBuilder(command=" + String.valueOf(this.getCommand()) + ", collectorScriptContent=" + String.valueOf(this.getCollectorScriptContent()) + ")";
        }

        @Generated
        public LocalCollectorProcessBuilder(List<String> command, Optional<String> collectorScriptContent) {
            this.command = command;
            this.collectorScriptContent = collectorScriptContent;
        }
    }
}

