/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.collector;

import com.appdynamics.agent.sim.configuration.bootstrap.AgentHomeDir;
import com.appdynamics.agent.sim.encryption.DecryptionService;
import com.appdynamics.sim.agent.extensions.servers.collector.RawSimCollectorScriptPath;
import com.appdynamics.sim.agent.extensions.servers.model.RawCollector;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LocalSimCollectorScriptPathProvider
implements Provider<Optional<String>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LocalSimCollectorScriptPathProvider.class);
    private static final String COLLECTOR_SCRIPT_FILE_PREFIX = "appd-";
    private static final String SCRIPTS_DIRECTORY = File.separator + "scripts";
    private final String extractedCollectorScriptName;
    private final String collectorScriptFileSuffix;
    private final String agentInstallDir;
    private final String simCollectorScriptPath;
    private final Class<? extends RawCollector<?>> rawCollectorClass;
    private final DecryptionService decryptor;

    @Inject
    LocalSimCollectorScriptPathProvider(@AgentHomeDir String agentInstallDir, @RawSimCollectorScriptPath String simCollectorScriptPath, @NonNull Class<? extends RawCollector<?>> rawCollectorClass, @NonNull DecryptionService decryptor) {
        if (rawCollectorClass == null) {
            throw new NullPointerException("rawCollectorClass is marked non-null but is null");
        }
        if (decryptor == null) {
            throw new NullPointerException("decryptor is marked non-null but is null");
        }
        this.agentInstallDir = agentInstallDir;
        this.simCollectorScriptPath = simCollectorScriptPath;
        this.rawCollectorClass = rawCollectorClass;
        String fileNameWithoutEnc = FilenameUtils.removeExtension((String)simCollectorScriptPath);
        String extension = FilenameUtils.getExtension((String)fileNameWithoutEnc);
        this.collectorScriptFileSuffix = FilenameUtils.EXTENSION_SEPARATOR_STR + extension;
        this.extractedCollectorScriptName = "collector" + this.collectorScriptFileSuffix;
        this.decryptor = decryptor;
    }

    public Optional<String> get() {
        try {
            Optional<File> scriptsDirOpt = this.getScriptsDirIfAvailable();
            InputStream stream = this.getInputStreamFromPath(this.rawCollectorClass, this.simCollectorScriptPath);
            File collectorScript = scriptsDirOpt.isPresent() ? new File((File)scriptsDirOpt.get(), this.extractedCollectorScriptName) : this.createTempFile();
            Optional decryptedScriptContent = this.decryptor.decryptInputStream(stream);
            this.copyStringToFile(collectorScript, (Optional<String>)decryptedScriptContent);
            return Optional.of((Object)collectorScript.getAbsolutePath());
        }
        catch (IOException e) {
            log.error("Encountered error while extracting Machine Agent collector script {}", (Throwable)e);
            return Optional.absent();
        }
    }

    @VisibleForTesting
    File createTempFile() throws IOException {
        log.error("Could not find or create scripts directory. Fall back to temp directory");
        File collectorScript = File.createTempFile(COLLECTOR_SCRIPT_FILE_PREFIX, this.collectorScriptFileSuffix);
        collectorScript.deleteOnExit();
        log.error("Collector script will be written to {}", (Object)collectorScript);
        return collectorScript;
    }

    @VisibleForTesting
    Optional<File> getScriptsDirIfAvailable() {
        String scriptsDirAbsolutePath = Paths.get(this.agentInstallDir, SCRIPTS_DIRECTORY).toAbsolutePath().toString();
        File scriptsDir = new File(scriptsDirAbsolutePath);
        if (scriptsDir.exists() || scriptsDir.mkdirs()) {
            return Optional.of((Object)scriptsDir);
        }
        return Optional.absent();
    }

    @VisibleForTesting
    void copyStringToFile(File collectorScript, Optional<String> decryptedScriptContent) throws IOException {
        if (!decryptedScriptContent.isPresent()) {
            throw new IOException("Encountered error while decrypting Machine Agent collector script");
        }
        FileUtils.writeStringToFile((File)collectorScript, (String)((String)decryptedScriptContent.get()));
    }

    @VisibleForTesting
    InputStream getInputStreamFromPath(Class<?> rawCollectorClass, String simCollectorScriptPath) {
        return rawCollectorClass.getResourceAsStream(simCollectorScriptPath);
    }
}

