/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers;

import com.appdynamics.sim.agent.extensions.api.metrics.ExtensionMetricAggregatorType;
import com.appdynamics.sim.agent.extensions.api.metrics.ExtensionMetricClusterRollupType;
import com.appdynamics.sim.agent.extensions.api.metrics.ExtensionMetricHoleHandlingType;
import com.appdynamics.sim.agent.extensions.api.metrics.ExtensionMetricTimeRollupType;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataLong;
import com.appdynamics.sim.agent.extensions.servers.util.UnknownValueUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SimMetricsService
implements MetricsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SimMetricsService.class);
    private final MetricsService metricsService;

    @Inject
    SimMetricsService(MetricsService metricsService) {
        this.metricsService = metricsService;
    }

    public boolean reportMetric(String metricName, ExtensionMetricAggregatorType aggregatorType, ExtensionMetricTimeRollupType timeRollupType, ExtensionMetricClusterRollupType clusterRollupType, ExtensionMetricHoleHandlingType holeHandlingType, long value) {
        if (this.isNegativeOrUnknown(value)) {
            return this.logAndReturnFalse(metricName);
        }
        return this.metricsService.reportMetric(metricName, aggregatorType, timeRollupType, clusterRollupType, holeHandlingType, value);
    }

    public boolean reportMetric(String metricName, ExtensionMetricAggregatorType aggregatorType, ExtensionMetricTimeRollupType timeRollupType, ExtensionMetricClusterRollupType clusterRollupType, ExtensionMetricHoleHandlingType holeHandlingType, RawDataLong rawValue) {
        if (!rawValue.isPresent()) {
            this.logError(metricName, rawValue.getError());
            return false;
        }
        return this.reportMetric(metricName, aggregatorType, timeRollupType, clusterRollupType, holeHandlingType, rawValue.get());
    }

    public boolean reportMetric(String metricName, ExtensionMetricAggregatorType aggregatorType, ExtensionMetricHoleHandlingType holeHandlingType, long value) {
        if (this.isNegativeOrUnknown(value)) {
            return this.logAndReturnFalse(metricName);
        }
        return this.metricsService.reportMetric(metricName, aggregatorType, holeHandlingType, value);
    }

    public boolean reportMetric(String metricName, ExtensionMetricAggregatorType aggregatorType, ExtensionMetricHoleHandlingType holeHandlingType, RawDataLong rawValue) {
        if (!rawValue.isPresent()) {
            this.logError(metricName, rawValue.getError());
            return false;
        }
        return this.reportMetric(metricName, aggregatorType, holeHandlingType, rawValue.get());
    }

    public boolean reportMetric(String metricName, ExtensionMetricAggregatorType aggregatorType, long value) {
        if (this.isNegativeOrUnknown(value)) {
            return this.logAndReturnFalse(metricName);
        }
        return this.metricsService.reportMetric(metricName, aggregatorType, value);
    }

    public boolean reportMetric(String metricName, ExtensionMetricAggregatorType aggregatorType, RawDataLong value) {
        if (!value.isPresent()) {
            this.logError(metricName, value.getError());
            return false;
        }
        return this.reportMetric(metricName, aggregatorType, value.get());
    }

    @VisibleForTesting
    boolean logAndReturnFalse(String metricName) {
        log.debug("Not reporting metric with name {}, its value is unknown.", (Object)metricName);
        return false;
    }

    @VisibleForTesting
    void logError(String metricName, String errorMsg) {
        log.debug("Error while reporting metric '{}'. Error: {}", (Object)metricName, (Object)errorMsg);
    }

    private boolean isNegativeOrUnknown(long value) {
        return value < 0L || UnknownValueUtil.isUnknownValue(value);
    }
}

