/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers;

import com.appdynamics.agent.sim.configuration.bootstrap.BootstrapConfiguration;
import com.appdynamics.agent.sim.log.SimAgentRepetitiveLogger;
import com.appdynamics.sim.agent.extensions.api.scheduling.Scheduler;
import com.appdynamics.sim.agent.extensions.servers.DataCollectorConfig;
import com.appdynamics.sim.agent.extensions.servers.DataCollectorFactory;
import com.appdynamics.sim.agent.extensions.servers.IServersDataCollector;
import com.appdynamics.sim.agent.extensions.servers.config.ServersMonitorConfig;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import lombok.Generated;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServersDataCollectorManager
implements Runnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServersDataCollectorManager.class);
    @Generated
    private final Object $lock = new Object[0];
    private final Scheduler scheduler;
    private final SimAgentRepetitiveLogger repetitiveLogger;
    private DataCollectorFactory dataCollectorFactory;
    private Map<DataCollectorConfig, IServersDataCollector> dataCollectorConfigDataCollectorMap;
    private Supplier<Optional<ImmutableSet<DataCollectorConfig>>> dataCollectorConfigsSupplier;
    private final Provider<ServersMonitorConfig> monitorConfig;
    private volatile ScheduledFuture<?> managerScheduledfuture;
    private volatile long configurationCheckInterval;
    @VisibleForTesting
    private final BootstrapConfiguration bootstrapConfiguration;

    @Inject
    private ServersDataCollectorManager(Scheduler scheduler, BootstrapConfiguration bootstrapConfiguration, Provider<ServersMonitorConfig> monitorConfig, SimAgentRepetitiveLogger repetitiveLogger, DataCollectorFactory dataCollectorFactory, Supplier<Optional<ImmutableSet<DataCollectorConfig>>> dataCollectorConfigSupplier) {
        this.scheduler = scheduler;
        this.bootstrapConfiguration = bootstrapConfiguration;
        this.monitorConfig = monitorConfig;
        this.repetitiveLogger = repetitiveLogger;
        this.dataCollectorFactory = dataCollectorFactory;
        this.dataCollectorConfigsSupplier = dataCollectorConfigSupplier;
        this.dataCollectorConfigDataCollectorMap = new ConcurrentHashMap<DataCollectorConfig, IServersDataCollector>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    @VisibleForTesting
    protected void startMananger() {
        Object object = this.$lock;
        synchronized (object) {
            log.debug("Start Manager ServersDataCollectorManager");
            if (this.isInvalidDockerSetup()) {
                log.warn("Not starting ServersDataCollector Manager, Invalid Docker setup.");
                return;
            }
            if (this.managerScheduledfuture == null) {
                this.configurationCheckInterval = ((ServersMonitorConfig)this.monitorConfig.get()).getComponentsSamplingConfigurationCheckInterval();
                this.managerScheduledfuture = this.scheduler.scheduleAtFixedRate((Runnable)this, 0L, this.configurationCheckInterval, TimeUnit.MILLISECONDS);
            }
            this.logAdditionalInfo();
            log.debug("Start Manager ServersDataCollectorManager complete");
        }
    }

    @Override
    public void run() {
        log.debug("Run ServersDataCollectorManager");
        Optional currentDataCollectorConfigsOptional = (Optional)this.dataCollectorConfigsSupplier.get();
        if (currentDataCollectorConfigsOptional.isPresent()) {
            if (this.hasDataCollectorConfigsChanged((Set)currentDataCollectorConfigsOptional.get())) {
                this.stopServersDataCollectors();
                this.startServersDataCollectors((Set)currentDataCollectorConfigsOptional.get());
            }
        } else {
            this.repetitiveLogger.error(log, "Failed to apply changes in the components collection, DataCollectorConfigs not valid.", new Object[0]);
        }
        if (this.hasConfigurationCheckIntervalChanged(((ServersMonitorConfig)this.monitorConfig.get()).getComponentsSamplingConfigurationCheckInterval())) {
            this.stopManager();
            this.startMananger();
        }
        log.debug("Run ServersDataCollectorManager complete");
    }

    private void startServersDataCollectors(Set<DataCollectorConfig> currentDataCollectorConfigs) {
        log.info("Starting data collectors.");
        for (DataCollectorConfig dataCollectorConfig : currentDataCollectorConfigs) {
            if (this.isRunning(dataCollectorConfig)) continue;
            this.startDataCollector(dataCollectorConfig);
        }
        log.info("Starting data collectors complete.");
    }

    @VisibleForTesting
    void startDataCollector(DataCollectorConfig dataCollectorConfig) {
        log.debug("Starting servers data collector - {}.", (Object)dataCollectorConfig);
        IServersDataCollector dataCollector = this.dataCollectorFactory.make(dataCollectorConfig);
        log.debug("Servers data collector - {}.", (Object)dataCollector);
        this.dataCollectorConfigDataCollectorMap.put(dataCollectorConfig, dataCollector);
        dataCollector.start();
        log.debug("Starting servers data collector - {} complete.", (Object)dataCollectorConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopServersDataCollectors() {
        Object object = this.$lock;
        synchronized (object) {
            log.debug("Stopping data collectors.");
            Iterator<Map.Entry<DataCollectorConfig, IServersDataCollector>> entryIterator = this.dataCollectorConfigDataCollectorMap.entrySet().iterator();
            while (entryIterator.hasNext()) {
                Map.Entry<DataCollectorConfig, IServersDataCollector> entry = entryIterator.next();
                DataCollectorConfig dataCollectorConfig = entry.getKey();
                IServersDataCollector dataCollector = entry.getValue();
                log.debug("Stopping servers data collector - {}.", (Object)dataCollectorConfig);
                if (dataCollector != null) {
                    dataCollector.stop();
                }
                entryIterator.remove();
            }
            log.debug("Stopping data collectors complete.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected void stopManager() {
        Object object = this.$lock;
        synchronized (object) {
            if (this.managerScheduledfuture != null) {
                this.managerScheduledfuture.cancel(true);
                this.managerScheduledfuture = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    @VisibleForTesting
    protected void stopAll() {
        Object object = this.$lock;
        synchronized (object) {
            this.stopServersDataCollectors();
            this.stopManager();
        }
    }

    private boolean hasDataCollectorConfigsChanged(Set<DataCollectorConfig> dataCollectorConfigs) {
        if (!dataCollectorConfigs.equals(this.getCurrentRunningDataCollectorConfigs())) {
            log.info("There is change in components collection configurations.");
            return true;
        }
        return false;
    }

    @VisibleForTesting
    protected boolean hasConfigurationCheckIntervalChanged(long configurationCheckInterval) {
        if (this.configurationCheckInterval != configurationCheckInterval) {
            log.info("There is change in configuration check interval from {} to {}.", (Object)this.configurationCheckInterval, (Object)configurationCheckInterval);
            return true;
        }
        return false;
    }

    private boolean isRunning(DataCollectorConfig dataCollectorConfig) {
        return this.dataCollectorConfigDataCollectorMap.containsKey(dataCollectorConfig);
    }

    private Set<DataCollectorConfig> getCurrentRunningDataCollectorConfigs() {
        return this.dataCollectorConfigDataCollectorMap.keySet();
    }

    @VisibleForTesting
    Collection<IServersDataCollector> getCurrentRunningDataCollectors() {
        return this.dataCollectorConfigDataCollectorMap.values();
    }

    @VisibleForTesting
    boolean isInvalidDockerSetup() {
        boolean dockerEnabled = this.bootstrapConfiguration.getDockerEnabled();
        boolean containerdEnabled = this.bootstrapConfiguration.getContainerdEnabled();
        if ((containerdEnabled || dockerEnabled) && !this.fileExists(this.bootstrapConfiguration.getBindMountOfHostRoot())) {
            this.repetitiveLogger.error(log, "Docker monitoring is enabled but the physical server's root directory, specified to be mounted as {} on the container, does not exist. Metrics will not be collected.Physical server's root directory should be mounted as /hostroot for docker monitoring to work. \nTo remove this error: \n1. Make docker-enabled false if the machine agent is not running inside container.\n2. If machine agent is running inside the container, along with docker run add '--volume=/:/hostroot:ro' as specified in the documentation.", new Object[]{this.bootstrapConfiguration.getBindMountOfHostRoot()});
            return true;
        }
        return false;
    }

    @VisibleForTesting
    boolean fileExists(String filePath) {
        return Paths.get(filePath, new String[0]).toFile().exists();
    }

    @VisibleForTesting
    boolean isOsLinux() {
        return SystemUtils.IS_OS_LINUX;
    }

    @VisibleForTesting
    void logAdditionalInfo() {
        if (this.isOsLinux()) {
            try {
                this.printFreeCommandVersion();
            }
            catch (IOException e) {
                log.warn("Unable to get version of free command", (Throwable)e);
            }
        }
    }

    @VisibleForTesting
    void printFreeCommandVersion() throws IOException {
        ProcessBuilder builder = new ProcessBuilder((List<String>)ImmutableList.of((Object)"free", (Object)"-V"));
        Process process = builder.start();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String line = bufferedReader.readLine();
            if (line != null) {
                log.info("Version of free command : {}", (Object)line);
            }
        }
    }

    @Generated
    BootstrapConfiguration getBootstrapConfiguration() {
        return this.bootstrapConfiguration;
    }
}

