/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.gpu.nvml;

import com.appdynamics.agent.sim.gpu.GpuPerformanceMetricsTemplate;
import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.metrics.ExtensionMetricAggregatorType;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.gpu.GpuMetricDataReporter;
import com.appdynamics.sim.agent.extensions.gpu.nvml.GpuNvmlMetricData;
import com.appdynamics.sim.agent.extensions.servers.Sim;
import com.google.inject.Inject;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NvmlMetricReporter
implements GpuMetricDataReporter<GpuNvmlMetricData> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NvmlMetricReporter.class);
    private final MetricsService metricsService;
    private final MachineProperties machineProperties;

    @Inject
    NvmlMetricReporter(@Sim @NonNull MetricsService metricsService, @NonNull MachineProperties machineProperties) {
        if (metricsService == null) {
            throw new NullPointerException("metricsService is marked non-null but is null");
        }
        if (machineProperties == null) {
            throw new NullPointerException("machineProperties is marked non-null but is null");
        }
        this.metricsService = metricsService;
        this.machineProperties = machineProperties;
    }

    @Override
    public void report(GpuNvmlMetricData gpuRawData) {
        try {
            Map<String, GpuNvmlMetricData.GpuData> gpus = gpuRawData.getGpus();
            long gpu_utilization_pct = 0L;
            long gpu_memory_utilization_pct = 0L;
            long totalGpus = gpus.keySet().size();
            for (String gpuId : gpus.keySet()) {
                this.formatAndReportGpuData(gpuId, gpus.get(gpuId));
                gpu_utilization_pct += gpus.get(gpuId).getUtilization();
                gpu_memory_utilization_pct += gpus.get(gpuId).getMemory().getUtilization();
            }
            this.machineProperties.updateProperty("GPU|Total GPU Count", Long.toString(totalGpus));
            log.debug("Successfully reported each GPU metric data");
            this.reportAggregateData(gpu_utilization_pct / totalGpus, gpu_memory_utilization_pct / totalGpus);
            log.debug("Successfully reported aggregated GPU metric data for all the available {} GPUs", (Object)totalGpus);
        }
        catch (Exception e) {
            log.error("Error occurred while reporting GPU metrics: ", (Throwable)e);
        }
    }

    private void formatAndReportGpuData(String gpuId, GpuNvmlMetricData.GpuData gpuData) {
        this.metricsService.reportMetric(GpuPerformanceMetricsTemplate.format((String)"Hardware Resources|GPU|{0}|GPU|Utilization (%)", (String)gpuId), ExtensionMetricAggregatorType.OBSERVATION, gpuData.getUtilization());
        this.metricsService.reportMetric(GpuPerformanceMetricsTemplate.format((String)"Hardware Resources|GPU|{0}|GPU|Temperature (C)", (String)gpuId), ExtensionMetricAggregatorType.OBSERVATION, gpuData.getTemperature());
        this.metricsService.reportMetric(GpuPerformanceMetricsTemplate.format((String)"Hardware Resources|GPU|{0}|Power|Power Draw (W)", (String)gpuId), ExtensionMetricAggregatorType.OBSERVATION, gpuData.getPower().getDraw());
        this.metricsService.reportMetric(GpuPerformanceMetricsTemplate.format((String)"Hardware Resources|GPU|{0}|Power|Power Limit (W)", (String)gpuId), ExtensionMetricAggregatorType.OBSERVATION, gpuData.getPower().getLimit());
        this.metricsService.reportMetric(GpuPerformanceMetricsTemplate.format((String)"Hardware Resources|GPU|{0}|Power|Power Draw Instant (W)", (String)gpuId), ExtensionMetricAggregatorType.OBSERVATION, gpuData.getPower().getDraw_instant());
        this.metricsService.reportMetric(GpuPerformanceMetricsTemplate.format((String)"Hardware Resources|GPU|{0}|Power|Power Draw (%)", (String)gpuId), ExtensionMetricAggregatorType.OBSERVATION, gpuData.getPower().getDraw_pct());
        this.metricsService.reportMetric(GpuPerformanceMetricsTemplate.format((String)"Hardware Resources|GPU|{0}|Clock|Video Clock (MHz)", (String)gpuId), ExtensionMetricAggregatorType.OBSERVATION, gpuData.getClocks().getVideo());
        this.metricsService.reportMetric(GpuPerformanceMetricsTemplate.format((String)"Hardware Resources|GPU|{0}|Clock|Memory Clock (MHz)", (String)gpuId), ExtensionMetricAggregatorType.OBSERVATION, gpuData.getClocks().getMemory());
        this.metricsService.reportMetric(GpuPerformanceMetricsTemplate.format((String)"Hardware Resources|GPU|{0}|Clock|SM Clock (MHz)", (String)gpuId), ExtensionMetricAggregatorType.OBSERVATION, gpuData.getClocks().getSm());
        this.metricsService.reportMetric(GpuPerformanceMetricsTemplate.format((String)"Hardware Resources|GPU|{0}|Memory|Utilization (%)", (String)gpuId), ExtensionMetricAggregatorType.OBSERVATION, gpuData.getMemory().getUtilization());
        this.metricsService.reportMetric(GpuPerformanceMetricsTemplate.format((String)"Hardware Resources|GPU|{0}|Memory|Temperature (C)", (String)gpuId), ExtensionMetricAggregatorType.OBSERVATION, gpuData.getMemory().getTemperature());
        this.metricsService.reportMetric(GpuPerformanceMetricsTemplate.format((String)"Hardware Resources|GPU|{0}|Performance|P-State", (String)gpuId), ExtensionMetricAggregatorType.OBSERVATION, gpuData.getPerformance().getPstate());
        this.metricsService.reportMetric(GpuPerformanceMetricsTemplate.format((String)"Hardware Resources|GPU|{0}|Performance|PCIe Rx Throughput (MB/s)", (String)gpuId), ExtensionMetricAggregatorType.OBSERVATION, gpuData.getPerformance().getRx_throughput());
        this.metricsService.reportMetric(GpuPerformanceMetricsTemplate.format((String)"Hardware Resources|GPU|{0}|Performance|PCIe Tx Throughput (MB/s)", (String)gpuId), ExtensionMetricAggregatorType.OBSERVATION, gpuData.getPerformance().getTx_throughput());
        this.metricsService.reportMetric(GpuPerformanceMetricsTemplate.format((String)"Hardware Resources|GPU|{0}|Framebuffer Memory|Total", (String)gpuId), ExtensionMetricAggregatorType.OBSERVATION, gpuData.getFramebuffer_memory().getTotal());
        this.metricsService.reportMetric(GpuPerformanceMetricsTemplate.format((String)"Hardware Resources|GPU|{0}|Framebuffer Memory|Used", (String)gpuId), ExtensionMetricAggregatorType.OBSERVATION, gpuData.getFramebuffer_memory().getUsed());
        this.metricsService.reportMetric(GpuPerformanceMetricsTemplate.format((String)"Hardware Resources|GPU|{0}|Framebuffer Memory|Used (%)", (String)gpuId), ExtensionMetricAggregatorType.OBSERVATION, gpuData.getFramebuffer_memory().getUsed_pct());
        this.metricsService.reportMetric(GpuPerformanceMetricsTemplate.format((String)"Hardware Resources|GPU|{0}|BAR1 Memory|Used", (String)gpuId), ExtensionMetricAggregatorType.OBSERVATION, gpuData.getBar1_memory().getUsed());
    }

    private void reportAggregateData(long gpu_pct, long gpu_memory_pct) {
        this.metricsService.reportMetric("Hardware Resources|GPU|Utilization (%)", ExtensionMetricAggregatorType.OBSERVATION, gpu_pct);
        this.metricsService.reportMetric("Hardware Resources|GPU|Memory Utilization (%)", ExtensionMetricAggregatorType.OBSERVATION, gpu_memory_pct);
    }
}

