/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.gpu;

import com.appdynamics.sim.agent.extensions.gpu.GpuCollectorProcessBuilderProvider;
import com.appdynamics.sim.agent.extensions.gpu.GpuMonitor;
import com.appdynamics.sim.agent.extensions.gpu.GpuRawCollectorUtil;
import com.appdynamics.sim.agent.extensions.gpu.dcgm.DcgmMetricModule;
import com.appdynamics.sim.agent.extensions.gpu.nvml.NvmlMetricModule;
import com.appdynamics.voltron.extensions.api.ExtensionModule;
import com.google.common.base.Optional;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.singularity.ee.util.system.SystemUtilsTranslateable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExtensionModule
public class GpuMonitoringModule
extends AbstractModule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GpuMonitoringModule.class);
    private static final boolean DEFAULT_GPU_COLLECTION_NVML_ENABLED = false;

    protected void configure() {
        this.bind(GpuMonitor.class).asEagerSingleton();
        this.bind((TypeLiteral)new TypeLiteral<Optional<GpuRawCollectorUtil.ICollectorProcessBuilder>>(){}).toProvider(GpuCollectorProcessBuilderProvider.class);
        boolean nvmlBasedCollectionEnabled = SystemUtilsTranslateable.getBooleanProperty((String)"appdynamics.machine.agent.gpu.collection.nvml.enabled", (boolean)false);
        if (nvmlBasedCollectionEnabled) {
            this.install((Module)new NvmlMetricModule());
            log.info("GPU metric data collection via NVML enabled");
        } else {
            this.install((Module)new DcgmMetricModule());
            log.info("GPU metric data collection via DCGM Exporter enabled");
        }
    }
}

