/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.gpu;

import com.appdynamics.sim.agent.extensions.gpu.GpuMonitor;
import com.appdynamics.sim.agent.extensions.gpu.GpuRawCollectorUtil;
import com.google.common.base.Optional;
import com.google.inject.Provider;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GpuCollectorProcessBuilderProvider
implements Provider<Optional<GpuRawCollectorUtil.ICollectorProcessBuilder>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GpuCollectorProcessBuilderProvider.class);
    private static final String GPU_COLLECTOR_SCRIPT_PATH = "/collectorScript/gpu-collector.sh";
    private static final String COLLECTOR_SCRIPT_FILE_PREFIX = "appd-";
    private static final String COLLECTOR_SCRIPT_FILE_SUFFIX = ".sh";
    private static final String BASH = "bash";

    public Optional<GpuRawCollectorUtil.ICollectorProcessBuilder> get() {
        String extractedScriptPath = this.extractCollectorScript();
        List<String> command = Arrays.asList(BASH, extractedScriptPath);
        GpuRawCollectorUtil.LocalCollectorProcessBuilder collectorProcessBuilder = new GpuRawCollectorUtil.LocalCollectorProcessBuilder(command, (Optional<String>)Optional.absent());
        return Optional.of((Object)collectorProcessBuilder);
    }

    public String extractCollectorScript() {
        String collectorScriptStr = "";
        try (InputStream stream = GpuMonitor.class.getResourceAsStream(GPU_COLLECTOR_SCRIPT_PATH);){
            File tempScript = File.createTempFile(COLLECTOR_SCRIPT_FILE_PREFIX, COLLECTOR_SCRIPT_FILE_SUFFIX);
            tempScript.deleteOnExit();
            FileUtils.copyInputStreamToFile((InputStream)stream, (File)tempScript);
            collectorScriptStr = tempScript.getAbsolutePath();
        }
        catch (IOException e) {
            log.error("Encountered error while extracting GPU collector script ", (Throwable)e);
        }
        return collectorScriptStr;
    }
}

