/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.docker.util;

import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataConstants;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataFactory;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataLong;
import com.appdynamics.sim.agent.extensions.docker.util.UnknownValueUtil;
import com.google.common.collect.ImmutableMap;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;

public class NixRawDataProcessClassSummingCalculator {
    private static final String ERROR_STRING = "Error during sum calculation";
    public static final CpuUsage CPU_USAGE_CALC = new CpuUsage();
    public static final RatePerSecond RATE_CALC = new RatePerSecond();
    private final RawDataFactory factory;
    private final Calculation calculation;
    private ImmutableMap<RawDataLong, RawDataLong> previousPidToValue;
    private RawDataLong previousEpochTime;
    private RawDataLong lastCookedResult;

    public NixRawDataProcessClassSummingCalculator(RawDataFactory factory, Calculation calculation) {
        this.factory = factory;
        this.calculation = calculation;
        this.lastCookedResult = RawDataConstants.ZERO_LONG;
        this.previousEpochTime = RawDataConstants.ZERO_LONG;
    }

    public RawDataLong calculate(@NonNull ImmutableMap<RawDataLong, RawDataLong> inputMap, @NonNull RawDataLong currentEpochTime, @NonNull Set<RawDataLong> filteredProcessIdSet) {
        if (inputMap == null) {
            throw new NullPointerException("inputMap is marked non-null but is null");
        }
        if (currentEpochTime == null) {
            throw new NullPointerException("currentEpochTime is marked non-null but is null");
        }
        if (filteredProcessIdSet == null) {
            throw new NullPointerException("filteredProcessIdSet is marked non-null but is null");
        }
        if (!currentEpochTime.isPresent()) {
            currentEpochTime = RawDataConstants.ZERO_LONG;
        }
        if (this.previousPidToValue != null && this.previousEpochTime.isPresent() && currentEpochTime.get() > this.previousEpochTime.get()) {
            RawDataLong currentValue = RawDataConstants.ZERO_LONG;
            RawDataLong previousValue = RawDataConstants.ZERO_LONG;
            for (RawDataLong pid : filteredProcessIdSet) {
                if (!inputMap.containsKey((Object)pid)) continue;
                currentValue = currentValue.add((RawDataLong)inputMap.get((Object)pid));
                if (!this.previousPidToValue.containsKey((Object)pid)) continue;
                previousValue = previousValue.add((RawDataLong)this.previousPidToValue.get((Object)pid));
            }
            RawDataLong valueDifference = currentValue.subtract(previousValue);
            RawDataLong epochTimeDifference = currentEpochTime.subtract(this.previousEpochTime);
            long calculatedResult = this.calculation.process(valueDifference, epochTimeDifference);
            this.lastCookedResult = UnknownValueUtil.isUnknownValue(calculatedResult) ? this.factory.createLong(ERROR_STRING) : this.factory.createLong(Long.valueOf(calculatedResult));
        }
        this.previousEpochTime = currentEpochTime;
        this.previousPidToValue = inputMap;
        return this.lastCookedResult;
    }

    @Generated
    public RawDataLong getLastCookedResult() {
        return this.lastCookedResult;
    }

    public static interface Calculation {
        public long process(RawDataLong var1, RawDataLong var2);
    }

    private static class CpuUsage
    implements Calculation {
        private CpuUsage() {
        }

        @Override
        public long process(RawDataLong difference, RawDataLong timeDifference) {
            if (difference.isPresent() && timeDifference.isPresent()) {
                return Math.round(100.0 * (double)difference.get().longValue() / (double)timeDifference.get().longValue());
            }
            return UnknownValueUtil.getUnknownValue();
        }
    }

    private static class RatePerSecond
    implements Calculation {
        private RatePerSecond() {
        }

        @Override
        public long process(RawDataLong difference, RawDataLong timeDifference) {
            if (difference.isPresent() && timeDifference.isPresent()) {
                return Math.round(1.0 * (double)difference.get().longValue() / (double)timeDifference.get().longValue());
            }
            return UnknownValueUtil.getUnknownValue();
        }
    }
}

