/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.docker.metrics.dockerapi.model;

import com.appdynamics.agent.sim.docker.model.DockerApiContainerMetricsRawData;
import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.docker.configuration.DockerMonitorConfig;
import com.appdynamics.sim.agent.extensions.docker.metrics.dockerapi.model.DockerApiContainerNetwork;
import com.appdynamics.sim.agent.extensions.docker.metrics.model.ContainerNetwork;
import com.appdynamics.sim.agent.extensions.docker.metrics.model.ContainerNetworks;
import com.google.inject.Provider;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerApiContainerNetworks
extends ContainerNetworks<DockerApiContainerMetricsRawData> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DockerApiContainerNetworks.class);
    private final Provider<DockerMonitorConfig> dockerMonitorConfigProvider = new Provider<DockerMonitorConfig>(){

        public DockerMonitorConfig get() {
            return new DockerMonitorConfig();
        }
    };

    DockerApiContainerNetworks(@NonNull MetricsService metricsService, MachineProperties machineProperties) {
        super(metricsService, machineProperties);
        if (metricsService == null) {
            throw new NullPointerException("metricsService is marked non-null but is null");
        }
    }

    @Override
    public final void update(DockerApiContainerMetricsRawData dockerApiContainerMetricsRawData, MachineProperties serverHostProperties) {
        Set<String> currentIds = this.extractIds(dockerApiContainerMetricsRawData);
        this.components.keySet().retainAll(currentIds);
        Pattern blacklistRegexPattern = ((DockerMonitorConfig)this.dockerMonitorConfigProvider.get()).getNetworkMonitorConfig().getNetworkBlacklistPattern();
        for (String id : currentIds) {
            if (this.components.containsKey(id)) continue;
            if (blacklistRegexPattern.matcher(id).matches()) {
                log.debug("Newly discovered network name: " + id + " found, skipping this!");
                continue;
            }
            log.debug("Newly discovered network name: " + id + " found, reporting this component!");
            DockerApiContainerNetwork component = new DockerApiContainerNetwork(id, this.metricsService);
            this.components.put(id, component);
        }
        for (ContainerNetwork component : this.components.values()) {
            component.update(dockerApiContainerMetricsRawData, serverHostProperties);
        }
    }

    private Set<String> extractIds(DockerApiContainerMetricsRawData dockerApiContainerMetricsRawData) {
        LinkedHashSet ids = new LinkedHashSet(dockerApiContainerMetricsRawData.getNetworksInfoMap().keySet());
        return Collections.unmodifiableSet(ids);
    }
}

