/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.docker.metrics.dockerapi.model;

import com.appdynamics.agent.sim.docker.model.DockerApiContainerMetricsRawData;
import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.api.util.DeltaCalculatorUtil;
import com.appdynamics.sim.agent.extensions.docker.metrics.model.ContainerMemory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import io.dropwizard.util.SizeUnit;

public class DockerApiContainerMemory
extends ContainerMemory<DockerApiContainerMetricsRawData> {
    private final DeltaCalculatorUtil failedCountCalculator = new DeltaCalculatorUtil();
    private final DeltaCalculatorUtil pageMaFaultCountCalculator = new DeltaCalculatorUtil();
    private DockerApiContainerMetricsRawData.Memory memory;

    DockerApiContainerMemory(MetricsService metricsService, MachineProperties machineProperties) {
        super(metricsService, machineProperties);
    }

    @Override
    public void update(DockerApiContainerMetricsRawData rawData, MachineProperties serverHostProperties) {
        this.memory = rawData.getMemory();
        if (this.memory.getStatsObject() != null) {
            this.pageMaFaultCountCalculator.calculate(this.memory.getStatsObject().getPageMaFault());
        }
        this.failedCountCalculator.calculate(this.memory.getFailCount());
    }

    @Override
    @VisibleForTesting
    protected Optional<Long> getMemoryUsedPercentage() {
        return this.calculateEffectiveMemoryUsedPercentage((Optional<Long>)Optional.fromNullable((Object)this.memory.getMemUsage()), (Optional<Long>)Optional.fromNullable((Object)this.memory.getStatsObject().getCache()), (Optional<Long>)Optional.fromNullable((Object)this.memory.getMemLimit()));
    }

    @Override
    protected Optional<Long> getMemoryUsedMB() {
        Optional<Long> effectiveMemoryUsage = this.calculateEffectiveMemoryUsed((Optional<Long>)Optional.fromNullable((Object)this.memory.getMemUsage()), (Optional<Long>)Optional.fromNullable((Object)this.memory.getStatsObject().getCache()));
        return Optional.of((Object)SizeUnit.BYTES.toMegabytes(((Long)effectiveMemoryUsage.get()).longValue()));
    }

    @Override
    @VisibleForTesting
    protected Optional<Long> getMemoryLimit() {
        long memoryLimitInBytes = this.memory.getMemLimit();
        long memoryLimitInMB = SizeUnit.BYTES.toMegabytes(memoryLimitInBytes);
        return Optional.of((Object)memoryLimitInMB);
    }

    @Override
    protected Optional<Long> getPageMaFaultCount() {
        return Optional.of((Object)this.pageMaFaultCountCalculator.getLastResult());
    }

    @Override
    protected Optional<Long> getCacheSize() {
        if (this.memory.getStatsObject() != null) {
            return Optional.of((Object)SizeUnit.BYTES.toMegabytes(this.memory.getStatsObject().getCache()));
        }
        return Optional.absent();
    }

    @Override
    protected Optional<Long> getRssSize() {
        if (this.memory.getStatsObject() != null) {
            return Optional.of((Object)SizeUnit.BYTES.toMegabytes(this.memory.getStatsObject().getRss()));
        }
        return Optional.absent();
    }

    @Override
    protected Optional<Long> getFailedCount() {
        return Optional.of((Object)this.failedCountCalculator.getLastResult());
    }
}

