/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.docker.metrics.dockerapi.collector;

import com.appdynamics.agent.sim.docker.DockerService;
import com.appdynamics.agent.sim.docker.model.DockerApiContainerMetricsRawData;
import com.appdynamics.agent.sim.docker.model.DockerContainerFull;
import com.appdynamics.agent.sim.docker.model.IContainerProcessDtoFactory;
import com.appdynamics.agent.sim.log.SimAgentRepetitiveLogger;
import com.appdynamics.sim.agent.extensions.docker.DockerMonitoring;
import com.appdynamics.sim.agent.extensions.docker.configuration.DockerMonitorConfig;
import com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.collector.CGroupNetworkCollector;
import com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.model.CGroupContainerMetricsRawData;
import com.appdynamics.sim.agent.extensions.docker.metrics.collector.ContainerComponentName;
import com.appdynamics.sim.agent.extensions.docker.metrics.collector.ContainerMetricsRawCollector;
import com.appdynamics.sim.agent.extensions.docker.metrics.dockerapi.collector.DockerApiMetricCollectionCallable;
import com.appdynamics.sim.agent.extensions.docker.model.DockerProcessClassIdCreator;
import com.appdynamics.sim.agent.extensions.docker.util.NixProcessStateUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerApiMetricsRawCollector
implements ContainerMetricsRawCollector<DockerApiContainerMetricsRawData> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DockerApiMetricsRawCollector.class);
    private static final long DEFAULT_VALUE = 0L;
    private final ExecutorService executorService;
    private final Supplier<DockerService> dockerServiceSupplier;
    private final SimAgentRepetitiveLogger repetitiveLogger;
    private final CGroupNetworkCollector cGroupNetworkCollector;
    private IContainerProcessDtoFactory containerProcessDtoFactory;
    private final Provider<DockerMonitorConfig> dockerMonitorConfigProvider;
    private final DockerProcessClassIdCreator processClassIdCreator;
    private final NixProcessStateUtil procStateUtil;

    @Inject
    DockerApiMetricsRawCollector(@DockerMonitoring ExecutorService executorService, Supplier<DockerService> dockerServiceSupplier, SimAgentRepetitiveLogger repetitiveLogger, CGroupNetworkCollector cGroupNetworkCollector, IContainerProcessDtoFactory containerProcessDtoFactory, Provider<DockerMonitorConfig> dockerMonitorConfigProvider, DockerProcessClassIdCreator processClassIdCreator, @NonNull NixProcessStateUtil procStateUtil) {
        if (procStateUtil == null) {
            throw new NullPointerException("procStateUtil is marked non-null but is null");
        }
        this.executorService = executorService;
        this.dockerServiceSupplier = dockerServiceSupplier;
        this.repetitiveLogger = repetitiveLogger;
        this.cGroupNetworkCollector = cGroupNetworkCollector;
        this.containerProcessDtoFactory = containerProcessDtoFactory;
        this.dockerMonitorConfigProvider = dockerMonitorConfigProvider;
        this.processClassIdCreator = processClassIdCreator;
        this.procStateUtil = procStateUtil;
    }

    @Override
    public Map<String, DockerApiContainerMetricsRawData> collect(Map<String, DockerContainerFull> containerIdToContainerDtoMap, Set<ContainerComponentName> componentNames) {
        Set<String> containerIds = containerIdToContainerDtoMap.keySet();
        log.debug("Collecting Docker Statistics for containerIds - {} and components - {}", containerIds, componentNames);
        if (containerIds.isEmpty() || componentNames.isEmpty()) {
            return Maps.newHashMap();
        }
        ArrayList<DockerApiMetricCollectionCallable> metricCollectorTasks = new ArrayList<DockerApiMetricCollectionCallable>(containerIds.size());
        ImmutableMap.Builder idToContainerMetricsBuilder = ImmutableMap.builder();
        DockerService dockerService = (DockerService)this.dockerServiceSupplier.get();
        for (String string : containerIds) {
            metricCollectorTasks.add(new DockerApiMetricCollectionCallable(this.containerProcessDtoFactory, this.dockerMonitorConfigProvider, this.processClassIdCreator, this.procStateUtil, string, containerIdToContainerDtoMap.get(string).getHostId(), dockerService));
        }
        try {
            List containerIdToContainerStatsFutures = this.executorService.invokeAll(metricCollectorTasks);
            for (Future future : containerIdToContainerStatsFutures) {
                try {
                    Map containerMetrics = (Map)future.get();
                    this.preProcessNetworkData(containerMetrics);
                    idToContainerMetricsBuilder.putAll(containerMetrics);
                }
                catch (ExecutionException e) {
                    this.repetitiveLogger.warn(log, "Skip retrieving data for a container due to: ", new Object[]{e.getCause()});
                }
            }
        }
        catch (InterruptedException e) {
            log.warn("Docker Monitor Metric Collection is interrupted.");
            Thread.currentThread().interrupt();
        }
        return idToContainerMetricsBuilder.build();
    }

    @VisibleForTesting
    void preProcessNetworkData(Map<String, DockerApiContainerMetricsRawData> containerIdToMetricData) {
        for (Map.Entry<String, DockerApiContainerMetricsRawData> entry : containerIdToMetricData.entrySet()) {
            String containerId = entry.getKey();
            DockerApiContainerMetricsRawData rawData = entry.getValue();
            Map networkInfoMap = rawData.getNetworksInfoMap();
            if (networkInfoMap != null && !networkInfoMap.isEmpty()) continue;
            this.repetitiveLogger.debug(log, "Docker API did not report network metrics for container with Id : {}. Collecting the network metrics from /proc/<CONTAINER_PID>/net/dev file.", new Object[]{containerId});
            Map<String, CGroupContainerMetricsRawData.CGroupNetworkData> networksRawData = this.cGroupNetworkCollector.collectNetworkMetrics(containerId);
            Map<String, DockerApiContainerMetricsRawData.NetworkInfo> dockerApiNetworkMap = this.convertToDockerRawData(networksRawData);
            rawData.setNetworksInfoMap(dockerApiNetworkMap);
        }
    }

    @VisibleForTesting
    Map<String, DockerApiContainerMetricsRawData.NetworkInfo> convertToDockerRawData(Map<String, CGroupContainerMetricsRawData.CGroupNetworkData> cGroupNetworkDataMap) {
        HashMap<String, DockerApiContainerMetricsRawData.NetworkInfo> dockerApiNetworkMap = new HashMap<String, DockerApiContainerMetricsRawData.NetworkInfo>();
        if (cGroupNetworkDataMap != null && !cGroupNetworkDataMap.isEmpty()) {
            for (Map.Entry<String, CGroupContainerMetricsRawData.CGroupNetworkData> entry : cGroupNetworkDataMap.entrySet()) {
                CGroupContainerMetricsRawData.CGroupNetworkData cGroupNetworkData = entry.getValue();
                DockerApiContainerMetricsRawData.NetworkInfo networkInfo = DockerApiContainerMetricsRawData.NetworkInfo.builder().rxBytes(((Long)cGroupNetworkData.getRxBytes().or((Object)0L)).longValue()).txBytes(((Long)cGroupNetworkData.getTxBytes().or((Object)0L)).longValue()).rxPackets(((Long)cGroupNetworkData.getRxPackets().or((Object)0L)).longValue()).txPackets(((Long)cGroupNetworkData.getTxPackets().or((Object)0L)).longValue()).rxErrors(((Long)cGroupNetworkData.getRxErrors().or((Object)0L)).longValue()).txErrors(((Long)cGroupNetworkData.getTxErrors().or((Object)0L)).longValue()).rxDropped(((Long)cGroupNetworkData.getRxDropped().or((Object)0L)).longValue()).txDropped(((Long)cGroupNetworkData.getTxDropped().or((Object)0L)).longValue()).build();
                dockerApiNetworkMap.put(entry.getKey(), networkInfo);
            }
        }
        return dockerApiNetworkMap;
    }
}

