/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.model;

import com.appdynamics.agent.sim.docker.model.ContainerProcess;
import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataFactory;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataLong;
import com.appdynamics.sim.agent.extensions.docker.DockerProcessProperties;
import com.appdynamics.sim.agent.extensions.docker.configuration.DockerMonitorConfig;
import com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.model.CGroupContainerMetricsRawData;
import com.appdynamics.sim.agent.extensions.docker.metrics.model.ContainerProcessComponent;
import com.appdynamics.sim.agent.extensions.docker.model.filter.DockerProcessRankingMethod;
import com.appdynamics.sim.agent.extensions.docker.util.ExponentialMovingAverageUtil;
import com.appdynamics.sim.agent.extensions.docker.util.NixUtils;
import com.appdynamics.sim.agent.extensions.docker.util.Pair;
import com.appdynamics.sim.processes.common.rest.SimProcessObservationDto;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CGroupContainerProcess
extends ContainerProcessComponent<CGroupContainerMetricsRawData> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CGroupContainerProcess.class);
    private String containerHostId;
    private List<SimProcessObservationDto> observationsToReport;
    private Map<Long, SimProcessObservationDto> pidToSimProcessObservationDtoMap;
    private Map<Long, ContainerProcess> pidToContainerProcessMap;
    private RawDataLong hostCpuLogicalCores;
    private volatile Map<RawDataLong, Pair<RawDataLong, Double>> processPidToCpuMetricsMap = new HashMap<RawDataLong, Pair<RawDataLong, Double>>();
    private volatile Map<RawDataLong, Pair<RawDataLong, Double>> processPidToMemoryMetricsMap = new HashMap<RawDataLong, Pair<RawDataLong, Double>>();
    private Map<RawDataLong, String> processPidToCommandLineMap = new HashMap<RawDataLong, String>();
    private volatile Map<RawDataLong, ContainerProcessComponent.SimProcessObservationDtoMetrics> pidToSimProcessObservationDtoMetricsMap = new HashMap<RawDataLong, ContainerProcessComponent.SimProcessObservationDtoMetrics>();
    private final DockerProcessRankingMethod<CGroupContainerMetricsRawData> processRankingMethod;
    private Map<RawDataLong, Pair<Long, Long>> pidToCpuTimeAndEpochTime = new HashMap<RawDataLong, Pair<Long, Long>>();
    private static final long SLIDING_WINDOW_MILLIS = TimeUnit.MINUTES.toMillis(2L);
    private boolean isFirstTime = true;

    CGroupContainerProcess(MetricsService metricsService, DockerProcessRankingMethod<CGroupContainerMetricsRawData> processRankingMethod, DockerProcessProperties processProperties, Provider<DockerMonitorConfig> dockerMonitorConfigProvider, RawDataFactory factory) {
        super(metricsService, processProperties, dockerMonitorConfigProvider, factory);
        this.processRankingMethod = processRankingMethod;
    }

    @Override
    public void update(CGroupContainerMetricsRawData rawData, MachineProperties serverHostProperties) {
        if (((DockerMonitorConfig)this.dockerMonitorConfigProvider.get()).getProcessMonitorConfig().getEnabled().booleanValue()) {
            this.containerHostId = rawData.getContainerHostId();
            this.pidToSimProcessObservationDtoMap = rawData.getPidToSimProcessObservationDto();
            this.pidToContainerProcessMap = rawData.getPidToContainerProcessMap();
            this.hostCpuLogicalCores = this.factory.createLong(Long.valueOf(this.calculateHostLogicalCores(serverHostProperties.toMap())));
            this.updateProcessMetricsMap(new ArrayList<ContainerProcess>(this.pidToContainerProcessMap.values()));
        }
    }

    private void updateProcessMetricsMap(List<ContainerProcess> processes) {
        long epochTime = System.currentTimeMillis();
        HashMap<RawDataLong, ContainerProcessComponent.SimProcessObservationDtoMetrics> newSimProcessObservationDtoMetrics = new HashMap<RawDataLong, ContainerProcessComponent.SimProcessObservationDtoMetrics>();
        HashMap<RawDataLong, Pair<RawDataLong, Double>> newCpuData = new HashMap<RawDataLong, Pair<RawDataLong, Double>>();
        HashMap<RawDataLong, Pair<RawDataLong, Double>> newMemoryData = new HashMap<RawDataLong, Pair<RawDataLong, Double>>();
        HashMap<RawDataLong, String> newCommandLineMap = new HashMap<RawDataLong, String>();
        for (ContainerProcess process : processes) {
            RawDataLong pid = this.factory.createLong(process.getPid());
            double alpha = this.getAverageAlpha();
            ContainerProcessComponent.SimProcessObservationDtoMetrics metricsDto = this.pidToSimProcessObservationDtoMetricsMap.get(pid);
            if (metricsDto != null) {
                ExponentialMovingAverageUtil cpuAverage = metricsDto.getCpuUtilizationMovingAverage();
                ExponentialMovingAverageUtil memAverage = metricsDto.getMemKbMovingAverage();
                cpuAverage.average(alpha, Double.parseDouble(process.getCpuPercent()));
                memAverage.average(alpha, process.getMemoryUsedKb().longValue());
                newSimProcessObservationDtoMetrics.put(pid, metricsDto);
            } else {
                metricsDto = new ContainerProcessComponent.SimProcessObservationDtoMetrics(this.getPidToSimProcessObservationDtoMap().get(pid.get()));
            }
            newSimProcessObservationDtoMetrics.put(pid, metricsDto);
            Long cpuTime = 0L;
            try {
                cpuTime = TimeUnit.MILLISECONDS.toSeconds(NixUtils.getTimeInMilis(process.getCpuTime()));
            }
            catch (IllegalArgumentException | IllegalStateException ex) {
                log.warn(ex.getMessage());
            }
            RawDataLong memoryUsage = this.factory.createLong(Long.valueOf((long)Double.parseDouble(process.getMemoryPercent())));
            RawDataLong cpuUsage = null;
            if (this.pidToCpuTimeAndEpochTime.get(pid) != null) {
                Long oldCpuTime = (Long)this.pidToCpuTimeAndEpochTime.get((Object)pid).first;
                Long oldEpochTime = (Long)this.pidToCpuTimeAndEpochTime.get((Object)pid).second;
                if (epochTime > oldEpochTime) {
                    long cpuTimeDifference = cpuTime - oldCpuTime;
                    long epochTimeDifference = epochTime - oldEpochTime;
                    cpuUsage = this.factory.createLong(Long.valueOf(Math.round(100.0 * (double)cpuTimeDifference / (double)epochTimeDifference)));
                }
            }
            this.pidToCpuTimeAndEpochTime.put(pid, Pair.of(cpuTime, epochTime));
            newCommandLineMap.put(pid, process.getCommandLine());
            if (cpuUsage == null) continue;
            cpuUsage = this.getHostCpuLogicalCores().or(Long.valueOf(0L)) != 0L ? cpuUsage.divide(this.getHostCpuLogicalCores()) : cpuUsage;
            Double expoMovingCpuAverageValue = (double)cpuUsage.get().longValue() * 1.0;
            if (this.processPidToCpuMetricsMap.get(pid) != null) {
                Double oldCpuUsage = this.processPidToCpuMetricsMap.get(pid).getSecond();
                expoMovingCpuAverageValue = oldCpuUsage + alpha * (Double.valueOf(cpuUsage.get().longValue()) - oldCpuUsage);
            }
            newCpuData.put(pid, Pair.of(cpuUsage, expoMovingCpuAverageValue));
            if (memoryUsage == null) continue;
            Double expoMovingMemoryAverageValue = (double)memoryUsage.get().longValue() * 1.0;
            if (this.processPidToMemoryMetricsMap.get(pid) != null) {
                Double oldMemoryUsage = this.processPidToMemoryMetricsMap.get(pid).getSecond();
                expoMovingMemoryAverageValue = oldMemoryUsage + alpha * (Double.valueOf(memoryUsage.get().longValue()) - oldMemoryUsage);
            }
            newMemoryData.put(pid, Pair.of(memoryUsage, expoMovingMemoryAverageValue));
        }
        this.pidToSimProcessObservationDtoMetricsMap = newSimProcessObservationDtoMetrics;
        this.processPidToCommandLineMap = newCommandLineMap;
        this.processPidToCpuMetricsMap = newCpuData;
        this.processPidToMemoryMetricsMap = newMemoryData;
    }

    @VisibleForTesting
    private double getAverageAlpha() {
        long samplingInterval = ((DockerMonitorConfig)this.dockerMonitorConfigProvider.get()).getSamplingInterval();
        double numPeriods = SLIDING_WINDOW_MILLIS / samplingInterval;
        return ExponentialMovingAverageUtil.getAlpha(numPeriods);
    }

    @Override
    public void report() {
        if (((DockerMonitorConfig)this.dockerMonitorConfigProvider.get()).getProcessMonitorConfig().getEnabled().booleanValue()) {
            if (!this.isFirstTime) {
                int limit = ((DockerMonitorConfig)this.dockerMonitorConfigProvider.get()).getProcessMonitorConfig().getMaxNumberMonitoredProcesses();
                if (this.getPidToSimProcessObservationDtoMetricsMap().size() > limit) {
                    this.observationsToReport = new ArrayList<SimProcessObservationDto>(limit);
                    List<SimProcessObservationDto> rankedList = this.processRankingMethod.rank(this);
                    if (rankedList != null) {
                        this.observationsToReport = rankedList.subList(0, Math.min(limit, rankedList.size()));
                    }
                } else {
                    this.observationsToReport = new ArrayList<ContainerProcessComponent.SimProcessObservationDtoMetrics>(this.getPidToSimProcessObservationDtoMetricsMap().values());
                }
                super.report();
            }
            this.isFirstTime = false;
        } else {
            this.isFirstTime = true;
        }
    }

    @Override
    @Generated
    public String getContainerHostId() {
        return this.containerHostId;
    }

    @Override
    @Generated
    public List<SimProcessObservationDto> getObservationsToReport() {
        return this.observationsToReport;
    }

    @Override
    @Generated
    public Map<Long, SimProcessObservationDto> getPidToSimProcessObservationDtoMap() {
        return this.pidToSimProcessObservationDtoMap;
    }

    @Override
    @Generated
    public Map<Long, ContainerProcess> getPidToContainerProcessMap() {
        return this.pidToContainerProcessMap;
    }

    @Override
    @Generated
    public RawDataLong getHostCpuLogicalCores() {
        return this.hostCpuLogicalCores;
    }

    @Override
    @Generated
    public Map<RawDataLong, Pair<RawDataLong, Double>> getProcessPidToCpuMetricsMap() {
        return this.processPidToCpuMetricsMap;
    }

    @Override
    @Generated
    public Map<RawDataLong, Pair<RawDataLong, Double>> getProcessPidToMemoryMetricsMap() {
        return this.processPidToMemoryMetricsMap;
    }

    @Override
    @Generated
    public Map<RawDataLong, String> getProcessPidToCommandLineMap() {
        return this.processPidToCommandLineMap;
    }

    @Override
    @Generated
    public Map<RawDataLong, ContainerProcessComponent.SimProcessObservationDtoMetrics> getPidToSimProcessObservationDtoMetricsMap() {
        return this.pidToSimProcessObservationDtoMetricsMap;
    }
}

