/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.model;

import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.docker.configuration.DockerMonitorConfig;
import com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.model.CGroupContainerMetricsRawData;
import com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.model.CGroupContainerNetwork;
import com.appdynamics.sim.agent.extensions.docker.metrics.model.ContainerNetwork;
import com.appdynamics.sim.agent.extensions.docker.metrics.model.ContainerNetworks;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Provider;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CGroupContainerNetworks
extends ContainerNetworks<CGroupContainerMetricsRawData> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CGroupContainerNetworks.class);
    private static final String LOOPBACK_PREFIX = "lo";
    private final Provider<DockerMonitorConfig> dockerMonitorConfigProvider = new Provider<DockerMonitorConfig>(){

        public DockerMonitorConfig get() {
            return new DockerMonitorConfig();
        }
    };

    CGroupContainerNetworks(@NonNull MetricsService metricsService, MachineProperties machineProperties) {
        super(metricsService, machineProperties);
        if (metricsService == null) {
            throw new NullPointerException("metricsService is marked non-null but is null");
        }
    }

    @Override
    public void update(CGroupContainerMetricsRawData cGroupContainerMetricsRawData, MachineProperties machineProperties) {
        Set<String> currentIds = this.extractIds(cGroupContainerMetricsRawData);
        this.components.keySet().retainAll(currentIds);
        Pattern blacklistRegexPattern = ((DockerMonitorConfig)this.dockerMonitorConfigProvider.get()).getNetworkMonitorConfig().getNetworkBlacklistPattern();
        for (String id : currentIds) {
            if (this.components.containsKey(id)) continue;
            if (blacklistRegexPattern.matcher(id).matches()) {
                log.debug("Newly discovered network name:" + id + " found skipping this  ");
                continue;
            }
            log.debug("Newly discovered network name:" + id + " found reporting this component ");
            CGroupContainerNetwork component = new CGroupContainerNetwork(id, this.metricsService);
            this.components.put(id, component);
        }
        for (ContainerNetwork component : this.components.values()) {
            component.update(cGroupContainerMetricsRawData, machineProperties);
        }
    }

    @VisibleForTesting
    Set<String> extractIds(CGroupContainerMetricsRawData cGroupContainerMetricsRawData) {
        Set<String> ids = cGroupContainerMetricsRawData.getCGroupContainerNetworks().keySet();
        HashSet<String> idsToReport = new HashSet<String>();
        for (String id : ids) {
            if (id.startsWith(LOOPBACK_PREFIX)) continue;
            idsToReport.add(id);
        }
        return Collections.unmodifiableSet(idsToReport);
    }
}

