/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.model;

import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.api.util.DeltaCalculatorForOptionalUtil;
import com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.model.CGroupContainerMetricsRawData;
import com.appdynamics.sim.agent.extensions.docker.metrics.model.ContainerMemory;
import com.google.common.base.Optional;
import io.dropwizard.util.SizeUnit;

public class CGroupContainerMemory
extends ContainerMemory<CGroupContainerMetricsRawData> {
    private CGroupContainerMetricsRawData.CGroupMemoryData memoryData;
    private final DeltaCalculatorForOptionalUtil failedCountCalculator = new DeltaCalculatorForOptionalUtil();
    private final DeltaCalculatorForOptionalUtil pageMaFaultCountCalculator = new DeltaCalculatorForOptionalUtil();

    CGroupContainerMemory(MetricsService metricsService, MachineProperties machineProperties) {
        super(metricsService, machineProperties);
    }

    @Override
    public void update(CGroupContainerMetricsRawData rawData, MachineProperties serverHostProperties) {
        this.memoryData = rawData.getCGroupMemoryData();
        this.failedCountCalculator.calculate(this.memoryData.getFailedCount());
        this.pageMaFaultCountCalculator.calculate(this.memoryData.getPageFaultMajorCount());
    }

    @Override
    protected Optional<Long> getMemoryUsedMB() {
        Optional<Long> effectiveMemoryUsage = this.calculateEffectiveMemoryUsed(this.memoryData.getMemoryUsage(), this.memoryData.getCache());
        if (effectiveMemoryUsage.isPresent()) {
            return Optional.of((Object)SizeUnit.BYTES.toMegabytes(((Long)effectiveMemoryUsage.get()).longValue()));
        }
        return Optional.absent();
    }

    @Override
    protected Optional<Long> getMemoryUsedPercentage() {
        return this.calculateEffectiveMemoryUsedPercentage(this.memoryData.getMemoryUsage(), this.memoryData.getCache(), this.memoryData.getMemoryLimit());
    }

    @Override
    protected Optional<Long> getMemoryLimit() {
        Optional<Long> memoryLimitInBytes = this.memoryData.getMemoryLimit();
        if (memoryLimitInBytes.isPresent()) {
            long memoryLimitInMB = SizeUnit.BYTES.toMegabytes(((Long)memoryLimitInBytes.get()).longValue());
            return Optional.of((Object)memoryLimitInMB);
        }
        return Optional.absent();
    }

    @Override
    protected Optional<Long> getPageMaFaultCount() {
        return this.pageMaFaultCountCalculator.getLastResult();
    }

    @Override
    protected Optional<Long> getCacheSize() {
        Optional<Long> memoryCache = this.memoryData.getCache();
        if (memoryCache.isPresent()) {
            return Optional.of((Object)SizeUnit.BYTES.toMegabytes(((Long)memoryCache.get()).longValue()));
        }
        return Optional.absent();
    }

    @Override
    protected Optional<Long> getRssSize() {
        Optional<Long> memoryRss = this.memoryData.getRss();
        if (memoryRss.isPresent()) {
            return Optional.of((Object)SizeUnit.BYTES.toMegabytes(((Long)memoryRss.get()).longValue()));
        }
        return Optional.absent();
    }

    @Override
    protected Optional<Long> getFailedCount() {
        return this.failedCountCalculator.getLastResult();
    }
}

