/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.model;

import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.api.util.OptionalArithmeticUtil;
import com.appdynamics.sim.agent.extensions.api.util.RateCalculatorForOptionalUtil;
import com.appdynamics.sim.agent.extensions.api.util.SizeUnitUtil;
import com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.model.CGroupContainerMetricsRawData;
import com.appdynamics.sim.agent.extensions.docker.metrics.model.ContainerDisk;
import com.google.common.base.Optional;
import java.util.Map;

public class CGroupContainerDisk
extends ContainerDisk<CGroupContainerMetricsRawData> {
    private Map<String, CGroupContainerMetricsRawData.CGroupDiskData> diskDataMap;
    private final RateCalculatorForOptionalUtil diskReadCountPerSecCalculator = new RateCalculatorForOptionalUtil();
    private final RateCalculatorForOptionalUtil diskWriteCountPerSecCalculator = new RateCalculatorForOptionalUtil();
    private final RateCalculatorForOptionalUtil diskReadBytesPerSecCalculator = new RateCalculatorForOptionalUtil();
    private final RateCalculatorForOptionalUtil diskWriteBytesPerSecCalculator = new RateCalculatorForOptionalUtil();
    private final RateCalculatorForOptionalUtil diskServiceTimeInNanoSecRateCalculator = new RateCalculatorForOptionalUtil();
    private Optional<Long> diskQueueSize = Optional.absent();

    CGroupContainerDisk(MetricsService metricsService) {
        super(metricsService);
    }

    @Override
    public void update(CGroupContainerMetricsRawData rawData, MachineProperties machineProperties) {
        this.diskDataMap = rawData.getCGroupContainerDisks();
        Optional diskReadCount = Optional.absent();
        Optional diskWriteCount = Optional.absent();
        Optional diskReadBytes = Optional.absent();
        Optional diskWriteBytes = Optional.absent();
        Optional diskServiceTimeInNanoSec = Optional.absent();
        this.diskQueueSize = Optional.absent();
        for (String diskId : this.diskDataMap.keySet()) {
            CGroupContainerMetricsRawData.CGroupDiskData diskData = this.diskDataMap.get(diskId);
            diskReadCount = OptionalArithmeticUtil.addOptionalLongValues((Optional)diskReadCount, diskData.getReadCount());
            diskWriteCount = OptionalArithmeticUtil.addOptionalLongValues((Optional)diskWriteCount, diskData.getWriteCount());
            diskReadBytes = OptionalArithmeticUtil.addOptionalLongValues((Optional)diskReadBytes, diskData.getReadBytes());
            diskWriteBytes = OptionalArithmeticUtil.addOptionalLongValues((Optional)diskWriteBytes, diskData.getWriteBytes());
            this.diskQueueSize = OptionalArithmeticUtil.addOptionalLongValues(this.diskQueueSize, diskData.getQueueSize());
            diskServiceTimeInNanoSec = OptionalArithmeticUtil.addOptionalLongValues((Optional)diskServiceTimeInNanoSec, diskData.getServiceTime());
        }
        long timeStampInSeconds = rawData.getDiskCollectionTimestampInSeconds();
        this.diskReadCountPerSecCalculator.calculate(diskReadCount, timeStampInSeconds);
        this.diskWriteCountPerSecCalculator.calculate(diskWriteCount, timeStampInSeconds);
        this.diskReadBytesPerSecCalculator.calculate(diskReadBytes, timeStampInSeconds);
        this.diskWriteBytesPerSecCalculator.calculate(diskWriteBytes, timeStampInSeconds);
        this.diskServiceTimeInNanoSecRateCalculator.calculate(diskServiceTimeInNanoSec, timeStampInSeconds);
    }

    @Override
    protected Optional<Long> getDiskReadCountPerSec() {
        return this.diskReadCountPerSecCalculator.getLastResult();
    }

    @Override
    protected Optional<Long> getDiskWriteCountPerSec() {
        return this.diskWriteCountPerSecCalculator.getLastResult();
    }

    @Override
    protected Optional<Long> getDiskReadKbPerSec() {
        Optional readBytesPerSec = this.diskReadBytesPerSecCalculator.getLastResult();
        if (readBytesPerSec.isPresent()) {
            return Optional.of((Object)SizeUnitUtil.convertByteToDecimalKiloByte((long)((Long)readBytesPerSec.get())));
        }
        return Optional.absent();
    }

    @Override
    protected Optional<Long> getDiskWriteKbPerSec() {
        Optional writeBytesPerSec = this.diskWriteBytesPerSecCalculator.getLastResult();
        if (writeBytesPerSec.isPresent()) {
            return Optional.of((Object)SizeUnitUtil.convertByteToDecimalKiloByte((long)((Long)writeBytesPerSec.get())));
        }
        return Optional.absent();
    }

    @Override
    protected Optional<Long> getDiskQueueSize() {
        return this.diskQueueSize;
    }

    @Override
    protected Optional<Double> getDiskServiceTimePerSec() {
        Optional diskServiceTimeInNanoSecRate = this.diskServiceTimeInNanoSecRateCalculator.getLastResult();
        if (diskServiceTimeInNanoSecRate.isPresent()) {
            return Optional.of((Object)(1.0 * (double)((Long)diskServiceTimeInNanoSecRate.get()).longValue() * 1.0E-9));
        }
        return Optional.absent();
    }
}

