/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.collector;

import com.appdynamics.agent.sim.docker.model.DockerContainerFull;
import com.appdynamics.agent.sim.log.SimAgentRepetitiveLogger;
import com.appdynamics.sim.agent.extensions.docker.DockerMonitoring;
import com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.collector.CGroupFileSystemPath;
import com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.collector.CGroupMetricCollectionCallable;
import com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.collector.CGroupMetricCollectionCallableFactory;
import com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.model.CGroupContainerMetricsRawData;
import com.appdynamics.sim.agent.extensions.docker.metrics.collector.ContainerComponentName;
import com.appdynamics.sim.agent.extensions.docker.metrics.collector.ContainerMetricsRawCollector;
import com.appdynamics.sim.agent.extensions.docker.util.Pair;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CGroupMetricsRawCollector
implements ContainerMetricsRawCollector<CGroupContainerMetricsRawData> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CGroupMetricsRawCollector.class);
    private final ExecutorService executorService;
    private final SimAgentRepetitiveLogger repetitiveLogger;
    private final CGroupMetricCollectionCallableFactory cGroupMetricCollectionCallableFactory;
    private final Optional<String> cGroupFileSystemPathProvider;

    @Inject
    CGroupMetricsRawCollector(@DockerMonitoring ExecutorService executorService, SimAgentRepetitiveLogger repetitiveLogger, CGroupMetricCollectionCallableFactory cGroupMetricCollectionCallableFactory, @CGroupFileSystemPath Optional<String> cGroupFileSystemPathProvider) {
        this.executorService = executorService;
        this.repetitiveLogger = repetitiveLogger;
        this.cGroupMetricCollectionCallableFactory = cGroupMetricCollectionCallableFactory;
        this.cGroupFileSystemPathProvider = cGroupFileSystemPathProvider;
    }

    @Override
    public Map<String, CGroupContainerMetricsRawData> collect(Map<String, DockerContainerFull> containerIdToContainerDtoMap, Set<ContainerComponentName> componentNames) {
        Set<String> containerIds = containerIdToContainerDtoMap.keySet();
        log.debug("Collecting Docker Statistics for containerIds - {} and components - {}", containerIds, componentNames);
        if (containerIds.isEmpty() || componentNames.isEmpty()) {
            return Maps.newHashMap();
        }
        if (!this.cGroupFileSystemPathProvider.isPresent()) {
            this.repetitiveLogger.error(log, "Could not find cgroup file system path. Container metrics will not be collected using CGroups", new Object[0]);
            return Maps.newHashMap();
        }
        ArrayList<CGroupMetricCollectionCallable> metricCollectorTasks = new ArrayList<CGroupMetricCollectionCallable>(containerIds.size());
        ImmutableMap.Builder idToContainerMetricsBuilder = ImmutableMap.builder();
        for (String string : containerIds) {
            Pair<String, String> containerIdAndContainerHostId = Pair.of(string, containerIdToContainerDtoMap.get(string).getHostId());
            metricCollectorTasks.add(this.cGroupMetricCollectionCallableFactory.make(containerIdAndContainerHostId, componentNames));
        }
        try {
            List containerIdToContainerStatsFutures = this.executorService.invokeAll(metricCollectorTasks);
            for (Future future : containerIdToContainerStatsFutures) {
                try {
                    Map containerMetrics = (Map)future.get();
                    idToContainerMetricsBuilder.putAll(containerMetrics);
                }
                catch (ExecutionException e) {
                    this.repetitiveLogger.warn(log, "Skip retrieving data for a container due to: ", new Object[]{e.getCause()});
                }
            }
        }
        catch (InterruptedException e) {
            log.warn("Docker Monitor Metric Collection is interrupted.");
            Thread.currentThread().interrupt();
        }
        ImmutableMap idToStats = idToContainerMetricsBuilder.build();
        return idToStats;
    }
}

