/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.collector;

import com.appdynamics.agent.sim.log.SimAgentRepetitiveLogger;
import com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.collector.CGroupComponentCollector;
import com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.collector.CGroupCpuCollector;
import com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.collector.CGroupDiskCollector;
import com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.collector.CGroupMemoryCollector;
import com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.collector.CGroupNetworkCollector;
import com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.collector.CGroupProcessCollector;
import com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.model.CGroupContainerMetricsRawData;
import com.appdynamics.sim.agent.extensions.docker.metrics.collector.ContainerComponentName;
import com.appdynamics.sim.agent.extensions.docker.util.Pair;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CGroupMetricCollectionCallable
implements Callable<Map<String, CGroupContainerMetricsRawData>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CGroupMetricCollectionCallable.class);
    private final String containerId;
    private final String containerHostId;
    private final Map<ContainerComponentName, CGroupComponentCollector> componentsByNameMap;
    private final Set<ContainerComponentName> componentNames;
    private final SimAgentRepetitiveLogger repetitiveLogger;

    @Inject
    public CGroupMetricCollectionCallable(@Assisted @NonNull Pair<String, String> containerIdAndContainerHostId, @Assisted @NonNull Set<ContainerComponentName> componentNames, CGroupCpuCollector cGroupCpuCollector, CGroupProcessCollector cGroupProcessCollector, CGroupMemoryCollector cGroupMemoryCollector, CGroupNetworkCollector cGroupNetworkCollector, CGroupDiskCollector cGroupDiskCollector, SimAgentRepetitiveLogger repetitiveLogger) {
        if (containerIdAndContainerHostId == null) {
            throw new NullPointerException("containerIdAndContainerHostId is marked non-null but is null");
        }
        if (componentNames == null) {
            throw new NullPointerException("componentNames is marked non-null but is null");
        }
        this.containerId = containerIdAndContainerHostId.getFirst();
        this.containerHostId = containerIdAndContainerHostId.getSecond();
        this.componentNames = componentNames;
        this.repetitiveLogger = repetitiveLogger;
        this.componentsByNameMap = new HashMap<ContainerComponentName, CGroupComponentCollector>();
        this.componentsByNameMap.put(ContainerComponentName.CPUS, cGroupCpuCollector);
        this.componentsByNameMap.put(ContainerComponentName.PROCESS, cGroupProcessCollector);
        this.componentsByNameMap.put(ContainerComponentName.MEMORY, cGroupMemoryCollector);
        this.componentsByNameMap.put(ContainerComponentName.NETWORK, cGroupNetworkCollector);
        this.componentsByNameMap.put(ContainerComponentName.DISK, cGroupDiskCollector);
    }

    @Override
    public Map<String, CGroupContainerMetricsRawData> call() throws Exception {
        ImmutableMap.Builder resultBuilder = ImmutableMap.builder();
        CGroupContainerMetricsRawData containerMetricsRawData = new CGroupContainerMetricsRawData();
        containerMetricsRawData.setContainerHostId(this.containerHostId);
        for (ContainerComponentName componentName : this.componentNames) {
            CGroupComponentCollector componentCollector = this.componentsByNameMap.get((Object)componentName);
            if (componentCollector != null) {
                try {
                    componentCollector.collectAndUpdate(this.containerId, containerMetricsRawData);
                }
                catch (Exception e) {
                    this.repetitiveLogger.warn(log, "Failed collecting metrics for containerId: {} for component: {}  with error {}", new Object[]{this.containerId, componentName, e.getCause()});
                }
                continue;
            }
            this.repetitiveLogger.warn(log, "Component - {} is not supported with CGroup collection", new Object[]{componentName});
        }
        log.trace("Collected container metrics for containerId {} - {}", (Object)this.containerId, (Object)containerMetricsRawData);
        resultBuilder.put((Object)this.containerId, (Object)containerMetricsRawData);
        return resultBuilder.build();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CGroupMetricCollectionCallable)) {
            return false;
        }
        CGroupMetricCollectionCallable other = (CGroupMetricCollectionCallable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$containerId = this.containerId;
        String other$containerId = other.containerId;
        if (this$containerId == null ? other$containerId != null : !this$containerId.equals(other$containerId)) {
            return false;
        }
        String this$containerHostId = this.containerHostId;
        String other$containerHostId = other.containerHostId;
        if (this$containerHostId == null ? other$containerHostId != null : !this$containerHostId.equals(other$containerHostId)) {
            return false;
        }
        Map<ContainerComponentName, CGroupComponentCollector> this$componentsByNameMap = this.componentsByNameMap;
        Map<ContainerComponentName, CGroupComponentCollector> other$componentsByNameMap = other.componentsByNameMap;
        if (this$componentsByNameMap == null ? other$componentsByNameMap != null : !((Object)this$componentsByNameMap).equals(other$componentsByNameMap)) {
            return false;
        }
        Set<ContainerComponentName> this$componentNames = this.componentNames;
        Set<ContainerComponentName> other$componentNames = other.componentNames;
        if (this$componentNames == null ? other$componentNames != null : !((Object)this$componentNames).equals(other$componentNames)) {
            return false;
        }
        SimAgentRepetitiveLogger this$repetitiveLogger = this.repetitiveLogger;
        SimAgentRepetitiveLogger other$repetitiveLogger = other.repetitiveLogger;
        return !(this$repetitiveLogger == null ? other$repetitiveLogger != null : !this$repetitiveLogger.equals(other$repetitiveLogger));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CGroupMetricCollectionCallable;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $containerId = this.containerId;
        result = result * 59 + ($containerId == null ? 43 : $containerId.hashCode());
        String $containerHostId = this.containerHostId;
        result = result * 59 + ($containerHostId == null ? 43 : $containerHostId.hashCode());
        Map<ContainerComponentName, CGroupComponentCollector> $componentsByNameMap = this.componentsByNameMap;
        result = result * 59 + ($componentsByNameMap == null ? 43 : ((Object)$componentsByNameMap).hashCode());
        Set<ContainerComponentName> $componentNames = this.componentNames;
        result = result * 59 + ($componentNames == null ? 43 : ((Object)$componentNames).hashCode());
        SimAgentRepetitiveLogger $repetitiveLogger = this.repetitiveLogger;
        result = result * 59 + ($repetitiveLogger == null ? 43 : $repetitiveLogger.hashCode());
        return result;
    }
}

