/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.collector;

import com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.collector.CGroupComponentCollector;
import com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.collector.CGroupFileReader;
import com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.model.CGroupContainerMetricsRawData;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import io.dropwizard.util.SizeUnit;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CGroupMemoryCollector
implements CGroupComponentCollector {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CGroupMemoryCollector.class);
    private static final String MEMORY_USAGE_FILE = "memory.usage_in_bytes";
    private static final String MEMORY_LIMIT_FILE = "memory.limit_in_bytes";
    private static final String HOST_MEMORY_PROC_INFO = "proc/meminfo";
    private static final String HOST_MEM_TOTAL = "MemTotal";
    private static final String MEMORY_FAILED_COUNT_FILE = "memory.failcnt";
    private static final String MEMORY_STAT_FILE = "memory.stat";
    private static final String CACHE = "cache";
    private static final String RSS = "rss";
    private static final String PAGE_FAULT_MAJOR = "pgmajfault";
    private static final String WHITE_SPACE_PATTERN = "\\s+";
    private final CGroupFileReader cGroupFileReader;

    @Inject
    @VisibleForTesting
    CGroupMemoryCollector(CGroupFileReader cGroupFileReader) {
        this.cGroupFileReader = cGroupFileReader;
    }

    @Override
    public void collectAndUpdate(String containerId, CGroupContainerMetricsRawData cGroupContainerMetricsRawData) {
        CGroupContainerMetricsRawData.CGroupMemoryData cGroupMemoryData = cGroupContainerMetricsRawData.getCGroupMemoryData();
        Optional<Long> memoryUsage = this.cGroupFileReader.getValueFrom(containerId, MEMORY_USAGE_FILE);
        Optional<Long> memoryLimit = this.cGroupFileReader.getValueFrom(containerId, MEMORY_LIMIT_FILE);
        Optional<Long> memoryFailedCount = this.cGroupFileReader.getValueFrom(containerId, MEMORY_FAILED_COUNT_FILE);
        Map<String, Optional<Long>> memoryStatMap = this.cGroupFileReader.getValuesMapFrom(containerId, MEMORY_STAT_FILE);
        List<String> hostMemoryProcInfoLines = this.cGroupFileReader.getFileLines(HOST_MEMORY_PROC_INFO);
        Optional<Long> hostTotalMemory = this.getHostMemoryTotal(hostMemoryProcInfoLines);
        cGroupMemoryData.setMemoryLimit(this.getMemoryLimit(hostTotalMemory, memoryLimit));
        cGroupMemoryData.setMemoryUsage(memoryUsage);
        cGroupMemoryData.setFailedCount(memoryFailedCount);
        if (memoryStatMap.get(CACHE) != null) {
            cGroupMemoryData.setCache(memoryStatMap.get(CACHE));
        }
        if (memoryStatMap.get(RSS) != null) {
            cGroupMemoryData.setRss(memoryStatMap.get(RSS));
        }
        if (memoryStatMap.get(PAGE_FAULT_MAJOR) != null) {
            cGroupMemoryData.setPageFaultMajorCount(memoryStatMap.get(PAGE_FAULT_MAJOR));
        }
    }

    @VisibleForTesting
    Optional<Long> getMemoryLimit(Optional<Long> hostTotalMemory, Optional<Long> containerLimit) {
        Optional<Long> memoryLimit = hostTotalMemory;
        if (hostTotalMemory.isPresent() && containerLimit.isPresent() && (Long)containerLimit.get() < (Long)hostTotalMemory.get()) {
            memoryLimit = containerLimit;
        }
        return memoryLimit;
    }

    @VisibleForTesting
    Optional<Long> getHostMemoryTotal(List<String> hostMemoryProcInfoLines) {
        Optional memoryTotal = Optional.absent();
        for (String line : hostMemoryProcInfoLines) {
            if (!line.startsWith(HOST_MEM_TOTAL)) continue;
            String[] splitString = line.split(WHITE_SPACE_PATTERN);
            try {
                memoryTotal = Optional.of((Object)SizeUnit.KILOBYTES.toBytes(Long.valueOf(splitString[1]).longValue()));
            }
            catch (NumberFormatException e) {
                log.error("Failed to parse host memory value - {} with error {}", (Object)line, (Object)e.getCause());
            }
            break;
        }
        return memoryTotal;
    }
}

