/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.collector;

import com.appdynamics.agent.sim.configuration.bootstrap.BootstrapConfiguration;
import com.appdynamics.sim.agent.extensions.api.util.EasyFileReaderUtils;
import com.appdynamics.sim.agent.extensions.docker.configuration.DockerMonitoringBootstrapConfig;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CGroupFileSystemRootProvider
implements Provider<Optional<String>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CGroupFileSystemRootProvider.class);
    private static final String SYS_FS_CGROUP_PATH = "/sys/fs/cgroup";
    private static final String CGROUP_PATH = "/cgroup";
    private static final List<String> CGROUP_FILE_PATHS = ImmutableList.of((Object)"/sys/fs/cgroup", (Object)"/cgroup");
    private final DockerMonitoringBootstrapConfig dockerMonitoringBootstrapConfig;
    private final EasyFileReaderUtils easyFileReaderUtils;
    private final BootstrapConfiguration bootstrapConfiguration;

    @Inject
    CGroupFileSystemRootProvider(DockerMonitoringBootstrapConfig dockerMonitoringBootstrapConfig, EasyFileReaderUtils easyFileReaderUtils, BootstrapConfiguration bootstrapConfiguration) {
        this.dockerMonitoringBootstrapConfig = dockerMonitoringBootstrapConfig;
        this.easyFileReaderUtils = easyFileReaderUtils;
        this.bootstrapConfiguration = bootstrapConfiguration;
    }

    public Optional<String> get() {
        String cgroupFileSystemPath;
        Optional cgroupPath;
        block6: {
            block5: {
                cgroupPath = Optional.absent();
                cgroupFileSystemPath = this.dockerMonitoringBootstrapConfig.getCgroupFileSystemRootPath();
                if (cgroupFileSystemPath == null) break block5;
                if (!this.easyFileReaderUtils.isNonEmptyDirectory(this.bootstrapConfiguration.getBindMountOfHostRoot(), new String[]{cgroupFileSystemPath})) break block6;
                cgroupPath = Optional.of((Object)cgroupFileSystemPath);
                break block6;
            }
            for (String path : CGROUP_FILE_PATHS) {
                if (!this.easyFileReaderUtils.isNonEmptyDirectory(this.bootstrapConfiguration.getBindMountOfHostRoot(), new String[]{path})) continue;
                cgroupPath = Optional.of((Object)path);
                break;
            }
        }
        if (cgroupPath.isPresent()) {
            log.info("Using the path: {} to collect CGroup metrics", cgroupPath.get());
        } else if (this.bootstrapConfiguration.getDockerEnabled().booleanValue()) {
            log.error("Could not find CGroup files in the following path(s): {}", cgroupFileSystemPath == null ? CGROUP_FILE_PATHS : cgroupFileSystemPath);
        } else {
            log.debug("Docker monitoring is disabled; skipping CGroup path discovery.");
        }
        return cgroupPath;
    }
}

