/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.collector;

import com.appdynamics.agent.sim.configuration.bootstrap.BootstrapConfiguration;
import com.appdynamics.agent.sim.log.SimAgentRepetitiveLogger;
import com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.collector.CGroupFilePathResolver;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CGroupFileReader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CGroupFileReader.class);
    private final SimAgentRepetitiveLogger repetitiveLogger;
    private final CGroupFilePathResolver cGroupFilePathResolver;
    private final BootstrapConfiguration bootstrapConfiguration;

    @Inject
    CGroupFileReader(SimAgentRepetitiveLogger repetitiveLogger, CGroupFilePathResolver cGroupFilePathResolver, BootstrapConfiguration bootstrapConfiguration) {
        this.repetitiveLogger = repetitiveLogger;
        this.cGroupFilePathResolver = cGroupFilePathResolver;
        this.bootstrapConfiguration = bootstrapConfiguration;
    }

    public List<String> getFileLines(@NonNull String basePath, @NonNull String containerId, @NonNull String fileName) {
        if (basePath == null) {
            throw new NullPointerException("basePath is marked non-null but is null");
        }
        if (containerId == null) {
            throw new NullPointerException("containerId is marked non-null but is null");
        }
        if (fileName == null) {
            throw new NullPointerException("fileName is marked non-null but is null");
        }
        String filePath = Paths.get(this.bootstrapConfiguration.getBindMountOfHostRoot(), basePath, containerId, fileName).toString();
        return this.readFileLines(filePath);
    }

    public List<String> getFileLines(@NonNull String containerId, @NonNull String fileName) {
        if (containerId == null) {
            throw new NullPointerException("containerId is marked non-null but is null");
        }
        if (fileName == null) {
            throw new NullPointerException("fileName is marked non-null but is null");
        }
        Optional<String> basePath = this.cGroupFilePathResolver.resolveFilePathTemplateByName(fileName, containerId);
        Object fileLines = ImmutableList.of();
        if (basePath.isPresent()) {
            fileLines = this.getFileLines((String)basePath.get(), containerId, fileName);
        } else {
            this.repetitiveLogger.warn(log, "Could not resolve the file path for containerId: {} and file name: {}", new Object[]{containerId, fileName});
        }
        return fileLines;
    }

    public List<String> getFileLines(@NonNull String fileName) {
        if (fileName == null) {
            throw new NullPointerException("fileName is marked non-null but is null");
        }
        String filePath = Paths.get(this.bootstrapConfiguration.getBindMountOfHostRoot(), fileName).toString();
        return this.readFileLines(filePath);
    }

    @VisibleForTesting
    List<String> readFileLines(@NonNull String filePath) {
        if (filePath == null) {
            throw new NullPointerException("filePath is marked non-null but is null");
        }
        ArrayList<String> lines = new ArrayList();
        File file = new File(filePath);
        if (file.exists()) {
            try {
                lines = FileUtils.readLines((File)file, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                log.error("Failed to read file {} with error {}", (Object)file.getName(), (Object)e.getCause());
            }
        } else {
            log.warn("File with path {} does not exist", (Object)filePath);
        }
        return lines;
    }

    public Optional<Long> getValueFrom(@NonNull String basePath, @NonNull String containerId, @NonNull String fileName) {
        if (basePath == null) {
            throw new NullPointerException("basePath is marked non-null but is null");
        }
        if (containerId == null) {
            throw new NullPointerException("containerId is marked non-null but is null");
        }
        if (fileName == null) {
            throw new NullPointerException("fileName is marked non-null but is null");
        }
        List<String> lines = this.getFileLines(basePath, containerId, fileName);
        Optional lineValue = Optional.absent();
        if (lines.size() == 1) {
            String line = lines.get(0);
            try {
                lineValue = Optional.fromNullable((Object)Long.valueOf(line));
            }
            catch (NumberFormatException e) {
                log.debug("Failed to parse value for container {}, filename {}, value {}", new Object[]{containerId, fileName, line});
            }
        }
        return lineValue;
    }

    public Optional<Long> getValueFrom(@NonNull String containerId, @NonNull String fileName) {
        if (containerId == null) {
            throw new NullPointerException("containerId is marked non-null but is null");
        }
        if (fileName == null) {
            throw new NullPointerException("fileName is marked non-null but is null");
        }
        Optional<String> basePath = this.cGroupFilePathResolver.resolveFilePathTemplateByName(fileName, containerId);
        if (basePath.isPresent()) {
            return this.getValueFrom((String)basePath.get(), containerId, fileName);
        }
        this.repetitiveLogger.warn(log, "Could not resolve the file path for containerId: {} and file name: {}", new Object[]{containerId, fileName});
        return Optional.absent();
    }

    public Map<String, Optional<Long>> getValuesMapFrom(@NonNull String basePath, @NonNull String containerId, @NonNull String fileName) {
        if (basePath == null) {
            throw new NullPointerException("basePath is marked non-null but is null");
        }
        if (containerId == null) {
            throw new NullPointerException("containerId is marked non-null but is null");
        }
        if (fileName == null) {
            throw new NullPointerException("fileName is marked non-null but is null");
        }
        List<String> lines = this.getFileLines(basePath, containerId, fileName);
        HashMap<String, Optional<Long>> valueMap = new HashMap<String, Optional<Long>>();
        for (String line : lines) {
            String[] splitString = line.split(" ");
            Optional value = Optional.absent();
            try {
                value = Optional.fromNullable((Object)Long.valueOf(splitString[1]));
            }
            catch (NumberFormatException e) {
                log.debug("Failed to parse value for container {}, filename {}, value {}", new Object[]{containerId, fileName, splitString[1]});
            }
            valueMap.put(splitString[0], (Optional<Long>)value);
        }
        return valueMap;
    }

    public Map<String, Optional<Long>> getValuesMapFrom(@NonNull String containerId, @NonNull String fileName) {
        if (containerId == null) {
            throw new NullPointerException("containerId is marked non-null but is null");
        }
        if (fileName == null) {
            throw new NullPointerException("fileName is marked non-null but is null");
        }
        HashMap<String, Optional<Long>> valueMap = new HashMap();
        Optional<String> basePath = this.cGroupFilePathResolver.resolveFilePathTemplateByName(fileName, containerId);
        if (basePath.isPresent()) {
            valueMap = this.getValuesMapFrom((String)basePath.get(), containerId, fileName);
        } else {
            this.repetitiveLogger.warn(log, "Could not resolve the file path for containerId: {} and file name: {}", new Object[]{containerId, fileName});
        }
        return valueMap;
    }
}

