/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.collector;

import com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.model.CGroupComponentName;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class CGroupFilePathDictionary {
    public static final String CPU_STAT_FILE = "cpu.stat";
    public static final String CPU_ACCT_USAGE_FILE = "cpuacct.usage";
    public static final String CPU_ACCT_USAGE_PERCPU_FILE = "cpuacct.usage_percpu";
    public static final String PROCESS_PROCS_FILE = "cgroup.procs";
    public static final String MEMORY_STAT_FILE = "memory.stat";
    public static final String MEMORY_USAGE_IN_BYTES_FILE = "memory.usage_in_bytes";
    public static final String MEMORY_LIMIT_IN_BYTES_FILE = "memory.limit_in_bytes";
    public static final String MEMORY_FAIL_CNT_FILE = "memory.failcnt";
    public static final String BLKIO_THROTTLE_IO_SERVICED = "blkio.throttle.io_serviced";
    public static final String BLKIO_THROTTLE_IO_SERVICE_BYTES = "blkio.throttle.io_service_bytes";
    public static final String BLKIO_IO_SERVICE_TIME_RECURSIVE = "blkio.io_service_time_recursive";
    public static final String BLKIO_IO_QUEUED_RECURSIVE = "blkio.io_queued_recursive";
    private static final String CPU_DOCKER_PATH = "cpu/docker";
    private static final String CPU_ACCT_DOCKER_PATH = "cpuacct/docker";
    private static final String PROCESS_DOCKER_PATH = "pids/docker";
    private static final String MEMORY_DOCKER_PATH = "memory/docker";
    private static final String BLKIO_DOCKER_PATH = "blkio/docker";
    private static final List<String> CPU_POSSIBLE_PATHS = ImmutableList.of((Object)"cpu/docker", (Object)"cpuacct/docker");
    private static final List<String> PROCESS_POSSIBLE_PATHS = ImmutableList.of((Object)"pids/docker");
    private static final List<String> MEMORY_POSSIBLE_PATHS = ImmutableList.of((Object)"memory/docker");
    private static final List<String> BLKIO_POSSIBLE_PATHS = ImmutableList.of((Object)"blkio/docker");
    @VisibleForTesting
    private final Map<CGroupComponentName, List<String>> componentNameToPossiblePathsMap;
    @VisibleForTesting
    private final Map<String, CGroupComponentName> fileNameToComponentNameMap;

    @Inject
    CGroupFilePathDictionary() {
        this.fileNameToComponentNameMap = new HashMap<String, CGroupComponentName>();
        this.componentNameToPossiblePathsMap = new HashMap<CGroupComponentName, List<String>>();
        this.populateFileNameToComponentNameMap();
        this.populateComponentNameToPossiblePathsMap();
    }

    @VisibleForTesting
    CGroupFilePathDictionary(Map<String, CGroupComponentName> fileNameToComponentNameMap, Map<CGroupComponentName, List<String>> componentNameToPossiblePathsMap) {
        this.fileNameToComponentNameMap = fileNameToComponentNameMap;
        this.componentNameToPossiblePathsMap = componentNameToPossiblePathsMap;
    }

    @VisibleForTesting
    void populateFileNameToComponentNameMap() {
        this.fileNameToComponentNameMap.put(CPU_STAT_FILE, CGroupComponentName.CPUS);
        this.fileNameToComponentNameMap.put(CPU_ACCT_USAGE_FILE, CGroupComponentName.CPUS);
        this.fileNameToComponentNameMap.put(CPU_ACCT_USAGE_PERCPU_FILE, CGroupComponentName.CPUS);
        this.fileNameToComponentNameMap.put(PROCESS_PROCS_FILE, CGroupComponentName.PROCESS);
        this.fileNameToComponentNameMap.put(MEMORY_STAT_FILE, CGroupComponentName.MEMORY);
        this.fileNameToComponentNameMap.put(MEMORY_USAGE_IN_BYTES_FILE, CGroupComponentName.MEMORY);
        this.fileNameToComponentNameMap.put(MEMORY_LIMIT_IN_BYTES_FILE, CGroupComponentName.MEMORY);
        this.fileNameToComponentNameMap.put(MEMORY_FAIL_CNT_FILE, CGroupComponentName.MEMORY);
        this.fileNameToComponentNameMap.put(BLKIO_THROTTLE_IO_SERVICED, CGroupComponentName.DISKS);
        this.fileNameToComponentNameMap.put(BLKIO_THROTTLE_IO_SERVICE_BYTES, CGroupComponentName.DISKS);
        this.fileNameToComponentNameMap.put(BLKIO_IO_SERVICE_TIME_RECURSIVE, CGroupComponentName.DISKS);
        this.fileNameToComponentNameMap.put(BLKIO_IO_QUEUED_RECURSIVE, CGroupComponentName.DISKS);
    }

    @VisibleForTesting
    void populateComponentNameToPossiblePathsMap() {
        this.componentNameToPossiblePathsMap.put(CGroupComponentName.CPUS, CPU_POSSIBLE_PATHS);
        this.componentNameToPossiblePathsMap.put(CGroupComponentName.PROCESS, PROCESS_POSSIBLE_PATHS);
        this.componentNameToPossiblePathsMap.put(CGroupComponentName.MEMORY, MEMORY_POSSIBLE_PATHS);
        this.componentNameToPossiblePathsMap.put(CGroupComponentName.DISKS, BLKIO_POSSIBLE_PATHS);
    }

    @VisibleForTesting
    List<String> getPossiblePathsForFile(String fileName) {
        CGroupComponentName componentName;
        if (this.fileNameToComponentNameMap.containsKey(fileName) && (componentName = this.fileNameToComponentNameMap.get(fileName)) != null && this.componentNameToPossiblePathsMap.containsKey((Object)componentName)) {
            return this.componentNameToPossiblePathsMap.get((Object)componentName);
        }
        return ImmutableList.of();
    }

    @Generated
    public Map<CGroupComponentName, List<String>> getComponentNameToPossiblePathsMap() {
        return this.componentNameToPossiblePathsMap;
    }

    @Generated
    public Map<String, CGroupComponentName> getFileNameToComponentNameMap() {
        return this.fileNameToComponentNameMap;
    }
}

