/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.collector;

import com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.collector.CGroupComponentCollector;
import com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.collector.CGroupFileReader;
import com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.model.CGroupContainerMetricsRawData;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CGroupDiskCollector
implements CGroupComponentCollector {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CGroupDiskCollector.class);
    private static final String BLKIO_SERVICED_FILE = "blkio.throttle.io_serviced";
    private static final String BLKIO_SERVICE_BYTES_FILE = "blkio.throttle.io_service_bytes";
    private static final String BLKIO_SERVICE_TIME_FILE = "blkio.io_service_time_recursive";
    private static final String BLKIO_QUEUE_SIZE_FILE = "blkio.io_queued_recursive";
    private static final String WHITE_SPACE_PATTERN = "\\s+";
    private static final String READ = "Read";
    private static final String WRITE = "Write";
    private static final String TOTAL = "Total";
    private final CGroupFileReader fileReader;

    @Inject
    public CGroupDiskCollector(CGroupFileReader fileReader) {
        this.fileReader = fileReader;
    }

    @Override
    public void collectAndUpdate(String containerId, CGroupContainerMetricsRawData cGroupContainerMetricsRawData) {
        CGroupContainerMetricsRawData.CGroupDiskData diskInfo;
        HashMap<String, CGroupContainerMetricsRawData.CGroupDiskData> diskDataMap = new HashMap<String, CGroupContainerMetricsRawData.CGroupDiskData>();
        List<String> blkioServicedLines = this.fileReader.getFileLines(containerId, BLKIO_SERVICED_FILE);
        List<String> blkioServiceBytesLines = this.fileReader.getFileLines(containerId, BLKIO_SERVICE_BYTES_FILE);
        List<String> blkioServiceTimeLines = this.fileReader.getFileLines(containerId, BLKIO_SERVICE_TIME_FILE);
        List<String> blkioQueueSizeLines = this.fileReader.getFileLines(containerId, BLKIO_QUEUE_SIZE_FILE);
        Map<String, Map<String, Long>> diskServicedMap = this.parseBlkioFileLinesPerDisk(blkioServicedLines);
        Map<String, Map<String, Long>> diskServiceBytesMap = this.parseBlkioFileLinesPerDisk(blkioServiceBytesLines);
        Map<String, Map<String, Long>> diskServiceTimeMap = this.parseBlkioFileLinesPerDisk(blkioServiceTimeLines);
        Map<String, Map<String, Long>> diskQueueSizeMap = this.parseBlkioFileLinesPerDisk(blkioQueueSizeLines);
        for (String diskId : diskServicedMap.keySet()) {
            diskInfo = this.getDiskDataById(diskDataMap, diskId);
            diskInfo.setReadCount((Optional<Long>)Optional.fromNullable((Object)diskServicedMap.get(diskId).get(READ)));
            diskInfo.setWriteCount((Optional<Long>)Optional.fromNullable((Object)diskServicedMap.get(diskId).get(WRITE)));
        }
        for (String diskId : diskServiceBytesMap.keySet()) {
            diskInfo = this.getDiskDataById(diskDataMap, diskId);
            diskInfo.setReadBytes((Optional<Long>)Optional.fromNullable((Object)diskServiceBytesMap.get(diskId).get(READ)));
            diskInfo.setWriteBytes((Optional<Long>)Optional.fromNullable((Object)diskServiceBytesMap.get(diskId).get(WRITE)));
        }
        for (String diskId : diskServiceTimeMap.keySet()) {
            diskInfo = this.getDiskDataById(diskDataMap, diskId);
            diskInfo.setServiceTime((Optional<Long>)Optional.fromNullable((Object)diskServiceTimeMap.get(diskId).get(TOTAL)));
        }
        for (String diskId : diskQueueSizeMap.keySet()) {
            diskInfo = this.getDiskDataById(diskDataMap, diskId);
            diskInfo.setQueueSize((Optional<Long>)Optional.fromNullable((Object)diskQueueSizeMap.get(diskId).get(TOTAL)));
        }
        long timestampInSeconds = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
        cGroupContainerMetricsRawData.setDiskCollectionTimestampInSeconds(timestampInSeconds);
        cGroupContainerMetricsRawData.setCGroupContainerDisks(diskDataMap);
    }

    @VisibleForTesting
    Map<String, Map<String, Long>> parseBlkioFileLinesPerDisk(List<String> fileLines) {
        HashMap<String, Map<String, Long>> diskMap = new HashMap<String, Map<String, Long>>();
        for (String line : fileLines) {
            String[] splitString = line.split(WHITE_SPACE_PATTERN);
            if (splitString.length != 3) continue;
            String diskId = splitString[0];
            HashMap<String, Long> diskOpValueMap = (HashMap<String, Long>)diskMap.get(diskId);
            if (diskOpValueMap == null) {
                diskOpValueMap = new HashMap<String, Long>();
                diskMap.put(diskId, diskOpValueMap);
            }
            diskOpValueMap.put(splitString[1], Long.valueOf(splitString[2]));
        }
        return diskMap;
    }

    private CGroupContainerMetricsRawData.CGroupDiskData getDiskDataById(Map<String, CGroupContainerMetricsRawData.CGroupDiskData> diskDataMap, String diskId) {
        CGroupContainerMetricsRawData.CGroupDiskData diskData = diskDataMap.get(diskId);
        if (diskData == null) {
            diskData = new CGroupContainerMetricsRawData.CGroupDiskData();
            diskDataMap.put(diskId, diskData);
        }
        return diskData;
    }
}

