/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.collector;

import com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.collector.CGroupComponentCollector;
import com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.collector.CGroupFileReader;
import com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.model.CGroupContainerMetricsRawData;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CGroupCpuCollector
implements CGroupComponentCollector {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CGroupCpuCollector.class);
    private static final String THROTTLED_TIME = "throttled_time";
    private static final String PROC_STAT_FILE = "/proc/stat";
    private static final String SYSTEM_CPU_LINE = "cpu ";
    private static final long CPU_TICKS_PER_SECOND = 100L;
    private static final String WHITE_SPACE_PATTERN = "\\s+";
    private final CGroupFileReader cGroupFileReader;

    @Inject
    @VisibleForTesting
    CGroupCpuCollector(CGroupFileReader cGroupFileReader) {
        this.cGroupFileReader = cGroupFileReader;
    }

    @Override
    public void collectAndUpdate(String containerId, CGroupContainerMetricsRawData cGroupContainerMetricsRawData) {
        CGroupContainerMetricsRawData.CGroupCPUData cGroupCPUData = cGroupContainerMetricsRawData.getCGroupCPUData();
        Map<String, Optional<Long>> cpuStatMap = this.cGroupFileReader.getValuesMapFrom(containerId, "cpu.stat");
        Optional<Long> totalCpuUsage = this.cGroupFileReader.getValueFrom(containerId, "cpuacct.usage");
        List<String> procStatLines = this.cGroupFileReader.getFileLines(PROC_STAT_FILE);
        Optional<Long> systemUsage = this.getSystemUsage(procStatLines);
        List<String> cpuUsagePerCpuLines = this.cGroupFileReader.getFileLines(containerId, "cpuacct.usage_percpu");
        cGroupCPUData.setCpuUsagePerCpu(this.getCpuUsagePerCpu(cpuUsagePerCpuLines));
        if (cpuStatMap.get(THROTTLED_TIME) != null) {
            cGroupCPUData.setThrottledTime(cpuStatMap.get(THROTTLED_TIME));
        }
        cGroupCPUData.setCpuUsageSystem(systemUsage);
        cGroupCPUData.setCpuTotalUsage(totalCpuUsage);
    }

    private List<Long> getCpuUsagePerCpu(List<String> cpuUsagePerCpuLines) {
        ArrayList<Long> perCpuUsage = new ArrayList<Long>();
        if (!cpuUsagePerCpuLines.isEmpty()) {
            String perCpuLine = cpuUsagePerCpuLines.get(0);
            String[] splitString = perCpuLine.split(WHITE_SPACE_PATTERN);
            try {
                for (String perCpuString : splitString) {
                    perCpuUsage.add(Long.valueOf(perCpuString));
                }
            }
            catch (NumberFormatException e) {
                log.error("Failed to parse per cpu line - {} with error {}", (Object)splitString, (Object)e.getCause());
                perCpuUsage.clear();
            }
        }
        return perCpuUsage;
    }

    private Optional<Long> getSystemUsage(List<String> procStatLines) {
        Optional systemUsage = Optional.absent();
        for (String line : procStatLines) {
            long totalClocks = 0L;
            if (!line.startsWith(SYSTEM_CPU_LINE)) continue;
            String[] splitString = line.split(WHITE_SPACE_PATTERN);
            try {
                for (int index = 1; index <= 7; ++index) {
                    totalClocks += Long.valueOf(splitString[index]).longValue();
                }
            }
            catch (NumberFormatException e) {
                log.error("Failed to parse system usage value - {} with error {}", (Object)line, (Object)e.getCause());
            }
            long cpuValue = TimeUnit.SECONDS.toNanos(totalClocks) / 100L;
            systemUsage = Optional.of((Object)cpuValue);
            break;
        }
        return systemUsage;
    }
}

