/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.docker.configuration;

import com.appdynamics.sim.agent.extensions.docker.configuration.DockerMonitorConfig;
import com.appdynamics.voltron.utils.overrides.OverrideIfBlank;
import com.appdynamics.voltron.utils.overrides.RegexValidation;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkMonitorConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NetworkMonitorConfig.class);
    private static final String DEFAULT_NETWORK_BLACKLIST_SELECTOR_REGEX = "^$";
    @RegexValidation
    @OverrideIfBlank(value="^$")
    private String blacklistSelectorRegex = "^$";

    public String getNetworkBlacklistSelectorRegex() {
        try {
            String val;
            ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
            DockerMonitorConfig dockerMonitorConfig = (DockerMonitorConfig)mapper.readValue(new File("extensions/DockerMonitoring/conf/DockerMonitoring.yml"), DockerMonitorConfig.class);
            this.blacklistSelectorRegex = val = dockerMonitorConfig.getNetworkMonitorConfig().getBlacklistSelectorRegex();
        }
        catch (IOException e) {
            log.debug("Error occurred while reading Blacklist selector regex for docker containernetworks: " + String.valueOf(e));
        }
        return this.blacklistSelectorRegex;
    }

    public Pattern getNetworkBlacklistPattern() {
        try {
            return Pattern.compile(this.getNetworkBlacklistSelectorRegex());
        }
        catch (Exception e) {
            log.debug("Incorrect  blacklist regex, not blacklisting any docker networks");
            return Pattern.compile(DEFAULT_NETWORK_BLACKLIST_SELECTOR_REGEX);
        }
    }

    @Generated
    public String getBlacklistSelectorRegex() {
        return this.blacklistSelectorRegex;
    }

    @Generated
    public void setBlacklistSelectorRegex(String blacklistSelectorRegex) {
        this.blacklistSelectorRegex = blacklistSelectorRegex;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NetworkMonitorConfig)) {
            return false;
        }
        NetworkMonitorConfig other = (NetworkMonitorConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$blacklistSelectorRegex = this.getBlacklistSelectorRegex();
        String other$blacklistSelectorRegex = other.getBlacklistSelectorRegex();
        return !(this$blacklistSelectorRegex == null ? other$blacklistSelectorRegex != null : !this$blacklistSelectorRegex.equals(other$blacklistSelectorRegex));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof NetworkMonitorConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $blacklistSelectorRegex = this.getBlacklistSelectorRegex();
        result = result * 59 + ($blacklistSelectorRegex == null ? 43 : $blacklistSelectorRegex.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "NetworkMonitorConfig(blacklistSelectorRegex=" + this.getBlacklistSelectorRegex() + ")";
    }

    @Generated
    public NetworkMonitorConfig() {
    }

    @Generated
    public NetworkMonitorConfig(String blacklistSelectorRegex) {
        this.blacklistSelectorRegex = blacklistSelectorRegex;
    }
}

