/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.docker.configuration;

import com.appdynamics.sim.agent.extensions.docker.configuration.IProcessMonitorConfig;
import com.appdynamics.sim.agent.extensions.docker.model.transformer.TransformerConfig;
import com.appdynamics.voltron.utils.annotations.FollowObject;
import com.appdynamics.voltron.utils.overrides.OverrideIfBlank;
import com.appdynamics.voltron.utils.overrides.RegexValidation;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerProcessMonitorConfig
implements IProcessMonitorConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DockerProcessMonitorConfig.class);
    private static final int DEFAULT_MAX_CLASS_ID_LENGTH = 50;
    private static final String DEFAULT_PROCESS_SELECTOR_REGEX = "^.+[^]]$";
    private static final long DEFAULT_MINIMUM_LIVE_TIME_BEFORE_MONITORING = 60000L;
    private static final int DEFAULT_MAX_NUM_MONITORED_PROCESSES = 0;
    private static final String DEFAULT_PROCESS_CLASS_SELECTOR = "";
    private static final String DEFAULT_PROCESS_CLASS_WHITELIST_REGEX = "";
    private static final List<TransformerConfig> DEFAULT_TRANSFORMERS = Collections.emptyList();
    private static final Optional<Pattern> DEFAULT_PROCESS_CLASS_SELECTOR_PATTERN = Optional.absent();
    private static final Map<String, String> DEFAULT_PROCESS_CLASS_SELECTOR_REGEX_MAP = Collections.emptyMap();
    private static final boolean DEFAULT_ENABLED = true;
    private static final String DEFAULT_CRITICAL_PROCESS_SELECTOR_REGEX = "redis|postgres|nginx|mysql|apache2|httpd|java|python|node|docker";
    private static final Pattern DEFAULT_CRITICAL_PROCESS_SELECTOR_PATTERN = Pattern.compile("redis|postgres|nginx|mysql|apache2|httpd|java|python|node|docker");
    @NotNull
    @OverrideIfBlank(value="true")
    private Boolean enabled;
    @NotNull
    @Min(value=60000L)
    @OverrideIfBlank(value="60000")
    private @NotNull @Min(value=60000L) Long reportingInterval;
    @Max(value=200L)
    @OverrideIfBlank(value="50")
    private @Max(value=200L) int maxClassIdLength;
    @NotNull
    @OverrideIfBlank(value="^.+[^]]$")
    private String processSelectorRegex;
    @Min(value=0L)
    @OverrideIfBlank(value="60000")
    private @Min(value=0L) long minLiveTimeMillisBeforeMonitoring;
    @Min(value=0L)
    @OverrideIfBlank(value="0")
    @VisibleForTesting
    private @Min(value=0L) int maxNumberMonitoredProcesses;
    @NotNull
    @OverrideIfBlank(value="")
    @RegexValidation
    private String defaultProcessClassSelector;
    @NotNull
    @JsonIgnore
    private Optional<Pattern> defaultProcessClassSelectorPattern;
    @NotNull
    @OverrideIfBlank(value="redis|postgres|nginx|mysql|apache2|httpd|java|python|node|docker")
    @RegexValidation
    private String criticalProcessSelectorRegex;
    @NotNull
    private Pattern criticalProcessSelectorPattern;
    @NotNull
    @RegexValidation
    private Map<String, String> processClassSelectorRegexList;
    @NotNull
    @FollowObject
    private List<TransformerConfig> commandLineTransformers;

    private DockerProcessMonitorConfig(boolean enabled, Long reportingInterval, int maxClassIdLength, long minLiveTimeMillisBeforeMonitoring, String processSelectorRegex, int maxNumberMonitoredProcesses, String defaultProcessClassSelector, Map<String, String> processClassSelectorRegexList, List<TransformerConfig> commandLineTransformers, String criticalProcessSelectorRegex) {
        this.enabled = enabled;
        this.reportingInterval = reportingInterval;
        this.maxClassIdLength = maxClassIdLength;
        this.minLiveTimeMillisBeforeMonitoring = minLiveTimeMillisBeforeMonitoring;
        this.setProcessSelectorRegex(processSelectorRegex);
        this.maxNumberMonitoredProcesses = maxNumberMonitoredProcesses;
        this.setDefaultProcessClassSelector(defaultProcessClassSelector);
        this.processClassSelectorRegexList = processClassSelectorRegexList;
        this.setCommandLineTransformers(commandLineTransformers);
        this.setCriticalProcessSelectorRegex(criticalProcessSelectorRegex);
    }

    private void setCommandLineTransformers(List<TransformerConfig> commandLineTransformers) {
        this.commandLineTransformers = (List)Optional.fromNullable(commandLineTransformers).or(DEFAULT_TRANSFORMERS);
    }

    private void setDefaultProcessClassSelector(String defaultProcessClassSelector) {
        if (StringUtils.isBlank((CharSequence)defaultProcessClassSelector)) {
            this.defaultProcessClassSelector = "";
            this.defaultProcessClassSelectorPattern = DEFAULT_PROCESS_CLASS_SELECTOR_PATTERN;
        } else {
            this.defaultProcessClassSelector = defaultProcessClassSelector;
            this.defaultProcessClassSelectorPattern = Optional.of((Object)Pattern.compile(defaultProcessClassSelector));
        }
    }

    public void setProcessSelectorRegex(String processSelectorRegex) {
        try {
            Pattern.compile(processSelectorRegex);
            this.processSelectorRegex = processSelectorRegex;
        }
        catch (Exception e) {
            this.processSelectorRegex = DEFAULT_PROCESS_SELECTOR_REGEX;
            log.warn("DockerMonitoring.yml contains invalid input for processSelectorRegex: " + processSelectorRegex + ". Use default value: ^.+[^]]$");
        }
    }

    public void setCriticalProcessSelectorRegex(String criticalProcessSelectorRegex) {
        if (StringUtils.isBlank((CharSequence)criticalProcessSelectorRegex)) {
            this.criticalProcessSelectorRegex = DEFAULT_CRITICAL_PROCESS_SELECTOR_REGEX;
            this.criticalProcessSelectorPattern = DEFAULT_CRITICAL_PROCESS_SELECTOR_PATTERN;
        } else {
            try {
                Pattern.compile(criticalProcessSelectorRegex);
                this.criticalProcessSelectorRegex = criticalProcessSelectorRegex;
                this.criticalProcessSelectorPattern = Pattern.compile(criticalProcessSelectorRegex);
            }
            catch (Exception e) {
                this.criticalProcessSelectorRegex = DEFAULT_CRITICAL_PROCESS_SELECTOR_REGEX;
                this.criticalProcessSelectorPattern = DEFAULT_CRITICAL_PROCESS_SELECTOR_PATTERN;
                log.warn("DockerMonitoring.yml contains invalid input for criticalProcessSelectorRegex: " + criticalProcessSelectorRegex + ". Using default regex value: redis|postgres|nginx|mysql|apache2|httpd|java|python|node|docker");
            }
        }
    }

    @Generated
    private static Boolean $default$enabled() {
        return true;
    }

    @Generated
    private static Long $default$reportingInterval() {
        return 60000L;
    }

    @Generated
    private static int $default$maxClassIdLength() {
        return 50;
    }

    @Generated
    private static String $default$processSelectorRegex() {
        return DEFAULT_PROCESS_SELECTOR_REGEX;
    }

    @Generated
    private static long $default$minLiveTimeMillisBeforeMonitoring() {
        return 60000L;
    }

    @Generated
    private static int $default$maxNumberMonitoredProcesses() {
        return 0;
    }

    @Generated
    private static String $default$defaultProcessClassSelector() {
        return "";
    }

    @Generated
    private static Optional<Pattern> $default$defaultProcessClassSelectorPattern() {
        return DEFAULT_PROCESS_CLASS_SELECTOR_PATTERN;
    }

    @Generated
    private static String $default$criticalProcessSelectorRegex() {
        return DEFAULT_CRITICAL_PROCESS_SELECTOR_REGEX;
    }

    @Generated
    private static Pattern $default$criticalProcessSelectorPattern() {
        return DEFAULT_CRITICAL_PROCESS_SELECTOR_PATTERN;
    }

    @Generated
    private static Map<String, String> $default$processClassSelectorRegexList() {
        return DEFAULT_PROCESS_CLASS_SELECTOR_REGEX_MAP;
    }

    @Generated
    private static List<TransformerConfig> $default$commandLineTransformers() {
        return DEFAULT_TRANSFORMERS;
    }

    @Generated
    public static DockerProcessMonitorConfigBuilder builder() {
        return new DockerProcessMonitorConfigBuilder();
    }

    @Generated
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setReportingInterval(Long reportingInterval) {
        this.reportingInterval = reportingInterval;
    }

    @Generated
    public void setMaxClassIdLength(int maxClassIdLength) {
        this.maxClassIdLength = maxClassIdLength;
    }

    @Generated
    public void setMinLiveTimeMillisBeforeMonitoring(long minLiveTimeMillisBeforeMonitoring) {
        this.minLiveTimeMillisBeforeMonitoring = minLiveTimeMillisBeforeMonitoring;
    }

    @Generated
    public void setProcessClassSelectorRegexList(Map<String, String> processClassSelectorRegexList) {
        this.processClassSelectorRegexList = processClassSelectorRegexList;
    }

    @Generated
    public String toString() {
        return "DockerProcessMonitorConfig(enabled=" + this.getEnabled() + ", reportingInterval=" + this.getReportingInterval() + ", maxClassIdLength=" + this.getMaxClassIdLength() + ", processSelectorRegex=" + this.getProcessSelectorRegex() + ", minLiveTimeMillisBeforeMonitoring=" + this.getMinLiveTimeMillisBeforeMonitoring() + ", maxNumberMonitoredProcesses=" + this.getMaxNumberMonitoredProcesses() + ", defaultProcessClassSelector=" + this.getDefaultProcessClassSelector() + ", defaultProcessClassSelectorPattern=" + String.valueOf(this.getDefaultProcessClassSelectorPattern()) + ", criticalProcessSelectorRegex=" + this.getCriticalProcessSelectorRegex() + ", criticalProcessSelectorPattern=" + String.valueOf(this.getCriticalProcessSelectorPattern()) + ", processClassSelectorRegexList=" + String.valueOf(this.getProcessClassSelectorRegexList()) + ", commandLineTransformers=" + String.valueOf(this.getCommandLineTransformers()) + ")";
    }

    @Generated
    public DockerProcessMonitorConfig(Boolean enabled, Long reportingInterval, int maxClassIdLength, String processSelectorRegex, long minLiveTimeMillisBeforeMonitoring, int maxNumberMonitoredProcesses, String defaultProcessClassSelector, Optional<Pattern> defaultProcessClassSelectorPattern, String criticalProcessSelectorRegex, Pattern criticalProcessSelectorPattern, Map<String, String> processClassSelectorRegexList, List<TransformerConfig> commandLineTransformers) {
        this.enabled = enabled;
        this.reportingInterval = reportingInterval;
        this.maxClassIdLength = maxClassIdLength;
        this.processSelectorRegex = processSelectorRegex;
        this.minLiveTimeMillisBeforeMonitoring = minLiveTimeMillisBeforeMonitoring;
        this.maxNumberMonitoredProcesses = maxNumberMonitoredProcesses;
        this.defaultProcessClassSelector = defaultProcessClassSelector;
        this.defaultProcessClassSelectorPattern = defaultProcessClassSelectorPattern;
        this.criticalProcessSelectorRegex = criticalProcessSelectorRegex;
        this.criticalProcessSelectorPattern = criticalProcessSelectorPattern;
        this.processClassSelectorRegexList = processClassSelectorRegexList;
        this.commandLineTransformers = commandLineTransformers;
    }

    @Generated
    public DockerProcessMonitorConfig() {
        this.enabled = DockerProcessMonitorConfig.$default$enabled();
        this.reportingInterval = DockerProcessMonitorConfig.$default$reportingInterval();
        this.maxClassIdLength = DockerProcessMonitorConfig.$default$maxClassIdLength();
        this.processSelectorRegex = DockerProcessMonitorConfig.$default$processSelectorRegex();
        this.minLiveTimeMillisBeforeMonitoring = DockerProcessMonitorConfig.$default$minLiveTimeMillisBeforeMonitoring();
        this.maxNumberMonitoredProcesses = DockerProcessMonitorConfig.$default$maxNumberMonitoredProcesses();
        this.defaultProcessClassSelector = DockerProcessMonitorConfig.$default$defaultProcessClassSelector();
        this.defaultProcessClassSelectorPattern = DockerProcessMonitorConfig.$default$defaultProcessClassSelectorPattern();
        this.criticalProcessSelectorRegex = DockerProcessMonitorConfig.$default$criticalProcessSelectorRegex();
        this.criticalProcessSelectorPattern = DockerProcessMonitorConfig.$default$criticalProcessSelectorPattern();
        this.processClassSelectorRegexList = DockerProcessMonitorConfig.$default$processClassSelectorRegexList();
        this.commandLineTransformers = DockerProcessMonitorConfig.$default$commandLineTransformers();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DockerProcessMonitorConfig)) {
            return false;
        }
        DockerProcessMonitorConfig other = (DockerProcessMonitorConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxClassIdLength() != other.getMaxClassIdLength()) {
            return false;
        }
        if (this.getMinLiveTimeMillisBeforeMonitoring() != other.getMinLiveTimeMillisBeforeMonitoring()) {
            return false;
        }
        if (this.getMaxNumberMonitoredProcesses() != other.getMaxNumberMonitoredProcesses()) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        Long this$reportingInterval = this.getReportingInterval();
        Long other$reportingInterval = other.getReportingInterval();
        if (this$reportingInterval == null ? other$reportingInterval != null : !((Object)this$reportingInterval).equals(other$reportingInterval)) {
            return false;
        }
        String this$processSelectorRegex = this.getProcessSelectorRegex();
        String other$processSelectorRegex = other.getProcessSelectorRegex();
        if (this$processSelectorRegex == null ? other$processSelectorRegex != null : !this$processSelectorRegex.equals(other$processSelectorRegex)) {
            return false;
        }
        String this$defaultProcessClassSelector = this.getDefaultProcessClassSelector();
        String other$defaultProcessClassSelector = other.getDefaultProcessClassSelector();
        if (this$defaultProcessClassSelector == null ? other$defaultProcessClassSelector != null : !this$defaultProcessClassSelector.equals(other$defaultProcessClassSelector)) {
            return false;
        }
        String this$criticalProcessSelectorRegex = this.getCriticalProcessSelectorRegex();
        String other$criticalProcessSelectorRegex = other.getCriticalProcessSelectorRegex();
        if (this$criticalProcessSelectorRegex == null ? other$criticalProcessSelectorRegex != null : !this$criticalProcessSelectorRegex.equals(other$criticalProcessSelectorRegex)) {
            return false;
        }
        Pattern this$criticalProcessSelectorPattern = this.getCriticalProcessSelectorPattern();
        Pattern other$criticalProcessSelectorPattern = other.getCriticalProcessSelectorPattern();
        if (this$criticalProcessSelectorPattern == null ? other$criticalProcessSelectorPattern != null : !this$criticalProcessSelectorPattern.equals(other$criticalProcessSelectorPattern)) {
            return false;
        }
        Map<String, String> this$processClassSelectorRegexList = this.getProcessClassSelectorRegexList();
        Map<String, String> other$processClassSelectorRegexList = other.getProcessClassSelectorRegexList();
        if (this$processClassSelectorRegexList == null ? other$processClassSelectorRegexList != null : !((Object)this$processClassSelectorRegexList).equals(other$processClassSelectorRegexList)) {
            return false;
        }
        List<TransformerConfig> this$commandLineTransformers = this.getCommandLineTransformers();
        List<TransformerConfig> other$commandLineTransformers = other.getCommandLineTransformers();
        return !(this$commandLineTransformers == null ? other$commandLineTransformers != null : !((Object)this$commandLineTransformers).equals(other$commandLineTransformers));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DockerProcessMonitorConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxClassIdLength();
        long $minLiveTimeMillisBeforeMonitoring = this.getMinLiveTimeMillisBeforeMonitoring();
        result = result * 59 + (int)($minLiveTimeMillisBeforeMonitoring >>> 32 ^ $minLiveTimeMillisBeforeMonitoring);
        result = result * 59 + this.getMaxNumberMonitoredProcesses();
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        Long $reportingInterval = this.getReportingInterval();
        result = result * 59 + ($reportingInterval == null ? 43 : ((Object)$reportingInterval).hashCode());
        String $processSelectorRegex = this.getProcessSelectorRegex();
        result = result * 59 + ($processSelectorRegex == null ? 43 : $processSelectorRegex.hashCode());
        String $defaultProcessClassSelector = this.getDefaultProcessClassSelector();
        result = result * 59 + ($defaultProcessClassSelector == null ? 43 : $defaultProcessClassSelector.hashCode());
        String $criticalProcessSelectorRegex = this.getCriticalProcessSelectorRegex();
        result = result * 59 + ($criticalProcessSelectorRegex == null ? 43 : $criticalProcessSelectorRegex.hashCode());
        Pattern $criticalProcessSelectorPattern = this.getCriticalProcessSelectorPattern();
        result = result * 59 + ($criticalProcessSelectorPattern == null ? 43 : $criticalProcessSelectorPattern.hashCode());
        Map<String, String> $processClassSelectorRegexList = this.getProcessClassSelectorRegexList();
        result = result * 59 + ($processClassSelectorRegexList == null ? 43 : ((Object)$processClassSelectorRegexList).hashCode());
        List<TransformerConfig> $commandLineTransformers = this.getCommandLineTransformers();
        result = result * 59 + ($commandLineTransformers == null ? 43 : ((Object)$commandLineTransformers).hashCode());
        return result;
    }

    @Override
    @Generated
    public Boolean getEnabled() {
        return this.enabled;
    }

    @Override
    @Generated
    public Long getReportingInterval() {
        return this.reportingInterval;
    }

    @Generated
    public int getMaxClassIdLength() {
        return this.maxClassIdLength;
    }

    @Generated
    public String getProcessSelectorRegex() {
        return this.processSelectorRegex;
    }

    @Generated
    public long getMinLiveTimeMillisBeforeMonitoring() {
        return this.minLiveTimeMillisBeforeMonitoring;
    }

    @Generated
    public int getMaxNumberMonitoredProcesses() {
        return this.maxNumberMonitoredProcesses;
    }

    @Generated
    public void setMaxNumberMonitoredProcesses(int maxNumberMonitoredProcesses) {
        this.maxNumberMonitoredProcesses = maxNumberMonitoredProcesses;
    }

    @Generated
    public String getDefaultProcessClassSelector() {
        return this.defaultProcessClassSelector;
    }

    @Generated
    public Optional<Pattern> getDefaultProcessClassSelectorPattern() {
        return this.defaultProcessClassSelectorPattern;
    }

    @Generated
    public String getCriticalProcessSelectorRegex() {
        return this.criticalProcessSelectorRegex;
    }

    @Generated
    public Pattern getCriticalProcessSelectorPattern() {
        return this.criticalProcessSelectorPattern;
    }

    @Generated
    public Map<String, String> getProcessClassSelectorRegexList() {
        return this.processClassSelectorRegexList;
    }

    @Generated
    public List<TransformerConfig> getCommandLineTransformers() {
        return this.commandLineTransformers;
    }

    @Generated
    public static class DockerProcessMonitorConfigBuilder {
        @Generated
        private boolean enabled$set;
        @Generated
        private Boolean enabled$value;
        @Generated
        private boolean reportingInterval$set;
        @Generated
        private Long reportingInterval$value;
        @Generated
        private boolean maxClassIdLength$set;
        @Generated
        private int maxClassIdLength$value;
        @Generated
        private boolean processSelectorRegex$set;
        @Generated
        private String processSelectorRegex$value;
        @Generated
        private boolean minLiveTimeMillisBeforeMonitoring$set;
        @Generated
        private long minLiveTimeMillisBeforeMonitoring$value;
        @Generated
        private boolean maxNumberMonitoredProcesses$set;
        @Generated
        private int maxNumberMonitoredProcesses$value;
        @Generated
        private boolean defaultProcessClassSelector$set;
        @Generated
        private String defaultProcessClassSelector$value;
        @Generated
        private boolean defaultProcessClassSelectorPattern$set;
        @Generated
        private Optional<Pattern> defaultProcessClassSelectorPattern$value;
        @Generated
        private boolean criticalProcessSelectorRegex$set;
        @Generated
        private String criticalProcessSelectorRegex$value;
        @Generated
        private boolean criticalProcessSelectorPattern$set;
        @Generated
        private Pattern criticalProcessSelectorPattern$value;
        @Generated
        private boolean processClassSelectorRegexList$set;
        @Generated
        private Map<String, String> processClassSelectorRegexList$value;
        @Generated
        private boolean commandLineTransformers$set;
        @Generated
        private List<TransformerConfig> commandLineTransformers$value;
        @Generated
        private boolean enabled;
        @Generated
        private Long reportingInterval;
        @Generated
        private int maxClassIdLength;
        @Generated
        private long minLiveTimeMillisBeforeMonitoring;
        @Generated
        private String processSelectorRegex;
        @Generated
        private int maxNumberMonitoredProcesses;
        @Generated
        private String defaultProcessClassSelector;
        @Generated
        private Map<String, String> processClassSelectorRegexList;
        @Generated
        private List<TransformerConfig> commandLineTransformers;
        @Generated
        private String criticalProcessSelectorRegex;

        @Generated
        DockerProcessMonitorConfigBuilder() {
        }

        @Generated
        public DockerProcessMonitorConfigBuilder enabled(Boolean enabled) {
            this.enabled$value = enabled;
            this.enabled$set = true;
            return this;
        }

        @Generated
        public DockerProcessMonitorConfigBuilder reportingInterval(Long reportingInterval) {
            this.reportingInterval$value = reportingInterval;
            this.reportingInterval$set = true;
            return this;
        }

        @Generated
        public DockerProcessMonitorConfigBuilder maxClassIdLength(int maxClassIdLength) {
            this.maxClassIdLength$value = maxClassIdLength;
            this.maxClassIdLength$set = true;
            return this;
        }

        @Generated
        public DockerProcessMonitorConfigBuilder processSelectorRegex(String processSelectorRegex) {
            this.processSelectorRegex$value = processSelectorRegex;
            this.processSelectorRegex$set = true;
            return this;
        }

        @Generated
        public DockerProcessMonitorConfigBuilder minLiveTimeMillisBeforeMonitoring(long minLiveTimeMillisBeforeMonitoring) {
            this.minLiveTimeMillisBeforeMonitoring$value = minLiveTimeMillisBeforeMonitoring;
            this.minLiveTimeMillisBeforeMonitoring$set = true;
            return this;
        }

        @Generated
        public DockerProcessMonitorConfigBuilder maxNumberMonitoredProcesses(int maxNumberMonitoredProcesses) {
            this.maxNumberMonitoredProcesses$value = maxNumberMonitoredProcesses;
            this.maxNumberMonitoredProcesses$set = true;
            return this;
        }

        @Generated
        public DockerProcessMonitorConfigBuilder defaultProcessClassSelector(String defaultProcessClassSelector) {
            this.defaultProcessClassSelector$value = defaultProcessClassSelector;
            this.defaultProcessClassSelector$set = true;
            return this;
        }

        @JsonIgnore
        @Generated
        public DockerProcessMonitorConfigBuilder defaultProcessClassSelectorPattern(Optional<Pattern> defaultProcessClassSelectorPattern) {
            this.defaultProcessClassSelectorPattern$value = defaultProcessClassSelectorPattern;
            this.defaultProcessClassSelectorPattern$set = true;
            return this;
        }

        @Generated
        public DockerProcessMonitorConfigBuilder criticalProcessSelectorRegex(String criticalProcessSelectorRegex) {
            this.criticalProcessSelectorRegex$value = criticalProcessSelectorRegex;
            this.criticalProcessSelectorRegex$set = true;
            return this;
        }

        @Generated
        public DockerProcessMonitorConfigBuilder criticalProcessSelectorPattern(Pattern criticalProcessSelectorPattern) {
            this.criticalProcessSelectorPattern$value = criticalProcessSelectorPattern;
            this.criticalProcessSelectorPattern$set = true;
            return this;
        }

        @Generated
        public DockerProcessMonitorConfigBuilder processClassSelectorRegexList(Map<String, String> processClassSelectorRegexList) {
            this.processClassSelectorRegexList$value = processClassSelectorRegexList;
            this.processClassSelectorRegexList$set = true;
            return this;
        }

        @Generated
        public DockerProcessMonitorConfigBuilder commandLineTransformers(List<TransformerConfig> commandLineTransformers) {
            this.commandLineTransformers$value = commandLineTransformers;
            this.commandLineTransformers$set = true;
            return this;
        }

        @Generated
        public DockerProcessMonitorConfig build() {
            Boolean enabled$value = this.enabled$value;
            if (!this.enabled$set) {
                enabled$value = DockerProcessMonitorConfig.$default$enabled();
            }
            Long reportingInterval$value = this.reportingInterval$value;
            if (!this.reportingInterval$set) {
                reportingInterval$value = DockerProcessMonitorConfig.$default$reportingInterval();
            }
            int maxClassIdLength$value = this.maxClassIdLength$value;
            if (!this.maxClassIdLength$set) {
                maxClassIdLength$value = DockerProcessMonitorConfig.$default$maxClassIdLength();
            }
            String processSelectorRegex$value = this.processSelectorRegex$value;
            if (!this.processSelectorRegex$set) {
                processSelectorRegex$value = DockerProcessMonitorConfig.$default$processSelectorRegex();
            }
            long minLiveTimeMillisBeforeMonitoring$value = this.minLiveTimeMillisBeforeMonitoring$value;
            if (!this.minLiveTimeMillisBeforeMonitoring$set) {
                minLiveTimeMillisBeforeMonitoring$value = DockerProcessMonitorConfig.$default$minLiveTimeMillisBeforeMonitoring();
            }
            int maxNumberMonitoredProcesses$value = this.maxNumberMonitoredProcesses$value;
            if (!this.maxNumberMonitoredProcesses$set) {
                maxNumberMonitoredProcesses$value = DockerProcessMonitorConfig.$default$maxNumberMonitoredProcesses();
            }
            String defaultProcessClassSelector$value = this.defaultProcessClassSelector$value;
            if (!this.defaultProcessClassSelector$set) {
                defaultProcessClassSelector$value = DockerProcessMonitorConfig.$default$defaultProcessClassSelector();
            }
            Optional<Pattern> defaultProcessClassSelectorPattern$value = this.defaultProcessClassSelectorPattern$value;
            if (!this.defaultProcessClassSelectorPattern$set) {
                defaultProcessClassSelectorPattern$value = DockerProcessMonitorConfig.$default$defaultProcessClassSelectorPattern();
            }
            String criticalProcessSelectorRegex$value = this.criticalProcessSelectorRegex$value;
            if (!this.criticalProcessSelectorRegex$set) {
                criticalProcessSelectorRegex$value = DockerProcessMonitorConfig.$default$criticalProcessSelectorRegex();
            }
            Pattern criticalProcessSelectorPattern$value = this.criticalProcessSelectorPattern$value;
            if (!this.criticalProcessSelectorPattern$set) {
                criticalProcessSelectorPattern$value = DockerProcessMonitorConfig.$default$criticalProcessSelectorPattern();
            }
            Map<String, String> processClassSelectorRegexList$value = this.processClassSelectorRegexList$value;
            if (!this.processClassSelectorRegexList$set) {
                processClassSelectorRegexList$value = DockerProcessMonitorConfig.$default$processClassSelectorRegexList();
            }
            List<TransformerConfig> commandLineTransformers$value = this.commandLineTransformers$value;
            if (!this.commandLineTransformers$set) {
                commandLineTransformers$value = DockerProcessMonitorConfig.$default$commandLineTransformers();
            }
            return new DockerProcessMonitorConfig(enabled$value, reportingInterval$value, maxClassIdLength$value, processSelectorRegex$value, minLiveTimeMillisBeforeMonitoring$value, maxNumberMonitoredProcesses$value, defaultProcessClassSelector$value, defaultProcessClassSelectorPattern$value, criticalProcessSelectorRegex$value, criticalProcessSelectorPattern$value, processClassSelectorRegexList$value, commandLineTransformers$value);
        }

        @Generated
        public String toString() {
            return "DockerProcessMonitorConfig.DockerProcessMonitorConfigBuilder(enabled$value=" + this.enabled$value + ", reportingInterval$value=" + this.reportingInterval$value + ", maxClassIdLength$value=" + this.maxClassIdLength$value + ", processSelectorRegex$value=" + this.processSelectorRegex$value + ", minLiveTimeMillisBeforeMonitoring$value=" + this.minLiveTimeMillisBeforeMonitoring$value + ", maxNumberMonitoredProcesses$value=" + this.maxNumberMonitoredProcesses$value + ", defaultProcessClassSelector$value=" + this.defaultProcessClassSelector$value + ", defaultProcessClassSelectorPattern$value=" + String.valueOf(this.defaultProcessClassSelectorPattern$value) + ", criticalProcessSelectorRegex$value=" + this.criticalProcessSelectorRegex$value + ", criticalProcessSelectorPattern$value=" + String.valueOf(this.criticalProcessSelectorPattern$value) + ", processClassSelectorRegexList$value=" + String.valueOf(this.processClassSelectorRegexList$value) + ", commandLineTransformers$value=" + String.valueOf(this.commandLineTransformers$value) + ")";
        }
    }
}

