/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.docker.configuration;

import com.appdynamics.sim.agent.extensions.docker.configuration.DockerMonitoringBootstrapConfig;
import com.appdynamics.sim.agent.extensions.docker.configuration.DockerMonitoringConfiguration;
import com.appdynamics.voltron.utils.overrides.Overrider;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;

public class DockerMonitoringBootstrapConfigProvider
implements Provider<DockerMonitoringBootstrapConfig> {
    private final Validator validator;
    private final Overrider overrider;
    private final DockerMonitoringBootstrapConfig configValue;

    @Inject
    DockerMonitoringBootstrapConfigProvider(@DockerMonitoringConfiguration Validator validator, @DockerMonitoringConfiguration Overrider overrider) {
        this.validator = validator;
        this.overrider = overrider;
        this.configValue = new DockerMonitoringBootstrapConfig();
    }

    public DockerMonitoringBootstrapConfig get() {
        this.overrider.override((Object)this.configValue);
        Set violations = this.validator.validate((Object)this.configValue, new Class[0]);
        if (violations.size() > 0) {
            String msg = this.buildValidationExceptionMessage(violations);
            throw new ProvisionException("Docker Monitoring configuration failed to validate.", (Throwable)new ConstraintViolationException(msg, violations));
        }
        return this.configValue;
    }

    private String buildValidationExceptionMessage(Set<ConstraintViolation<DockerMonitoringBootstrapConfig>> violations) {
        StringBuilder sb = new StringBuilder("Error occurred while validating Docker Monitoring configuration:\n");
        for (ConstraintViolation<DockerMonitoringBootstrapConfig> violation : violations) {
            sb.append("    property '").append(violation.getPropertyPath()).append("': ").append(violation.getMessage()).append(" Found value '").append(violation.getInvalidValue()).append("'.").append("\n");
        }
        return sb.toString();
    }
}

