/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.docker;

import com.appdynamics.sim.agent.extensions.api.HostId;
import com.appdynamics.sim.agent.extensions.docker.DockerProcessProperties;
import com.appdynamics.sim.processes.agent.rest.SimProcessesAgentService;
import com.appdynamics.sim.processes.common.rest.SimProcessObservationDto;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.List;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoubleBufferedDockerProcessProperties
implements DockerProcessProperties {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DoubleBufferedDockerProcessProperties.class);
    private final String hostId;
    private final SimProcessesAgentService processesAgentService;
    @VisibleForTesting
    private volatile Optional<List<SimProcessObservationDto>> currentProcessObservations;
    @VisibleForTesting
    private volatile ImmutableList.Builder<SimProcessObservationDto> nextProcessObservationsBuilder;

    @Inject
    public DoubleBufferedDockerProcessProperties(@HostId @NonNull String hostId, @Nullable SimProcessesAgentService processesAgentService) {
        if (hostId == null) {
            throw new NullPointerException("hostId is marked non-null but is null");
        }
        this.hostId = hostId;
        this.processesAgentService = processesAgentService;
        this.currentProcessObservations = Optional.absent();
        this.nextProcessObservationsBuilder = ImmutableList.builder();
    }

    @Override
    public void addProcessObservations(List<SimProcessObservationDto> containerObservations) {
        this.nextProcessObservationsBuilder.addAll(containerObservations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readyToReport() {
        DoubleBufferedDockerProcessProperties doubleBufferedDockerProcessProperties = this;
        synchronized (doubleBufferedDockerProcessProperties) {
            this.currentProcessObservations = Optional.of((Object)this.nextProcessObservationsBuilder.build());
            this.nextProcessObservationsBuilder = ImmutableList.builder();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportProcesses() {
        Optional<List<SimProcessObservationDto>> currentProcessObservationsToReport;
        DoubleBufferedDockerProcessProperties doubleBufferedDockerProcessProperties = this;
        synchronized (doubleBufferedDockerProcessProperties) {
            currentProcessObservationsToReport = this.currentProcessObservations;
            this.currentProcessObservations = Optional.absent();
        }
        if (this.processesAgentService != null && currentProcessObservationsToReport.isPresent() && !((List)currentProcessObservationsToReport.get()).isEmpty()) {
            this.processesAgentService.updateProcessMetadata("Container|Processes|" + this.hostId, (List)currentProcessObservationsToReport.get());
        }
    }

    @Generated
    Optional<List<SimProcessObservationDto>> getCurrentProcessObservations() {
        return this.currentProcessObservations;
    }

    @Generated
    ImmutableList.Builder<SimProcessObservationDto> getNextProcessObservationsBuilder() {
        return this.nextProcessObservationsBuilder;
    }
}

