/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.docker;

import com.appdynamics.agent.sim.configuration.bootstrap.BootstrapConfiguration;
import com.appdynamics.sim.agent.extensions.api.scheduling.Scheduler;
import com.appdynamics.sim.agent.extensions.docker.DockerMonitor;
import com.appdynamics.sim.agent.extensions.docker.DockerProcessProperties;
import com.appdynamics.sim.agent.extensions.docker.configuration.DockerMonitorConfig;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerProcessMonitor
implements Runnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DockerProcessMonitor.class);
    @Generated
    private final Object $lock = new Object[0];
    @VisibleForTesting
    public static final long PROCESS_METADATA_REPORTING_INTERVAL = 60000L;
    private final Scheduler scheduler;
    private final BootstrapConfiguration bootstrapConfiguration;
    private final DockerMonitor dockerMonitor;
    private final Provider<DockerMonitorConfig> dockerMonitorConfigProvider;
    private final DockerProcessProperties processProperties;
    private volatile ScheduledFuture<?> future;
    private static long previousReportingIntervalValue;
    private boolean isFirstTime = true;

    @Inject
    private DockerProcessMonitor(Scheduler scheduler, BootstrapConfiguration bootstrapConfiguration, DockerMonitor dockerMonitor, Provider<DockerMonitorConfig> dockerMonitorConfigProvider, @NonNull DockerProcessProperties processProperties) {
        if (processProperties == null) {
            throw new NullPointerException("processProperties is marked non-null but is null");
        }
        this.scheduler = scheduler;
        this.bootstrapConfiguration = bootstrapConfiguration;
        this.dockerMonitor = dockerMonitor;
        this.dockerMonitorConfigProvider = dockerMonitorConfigProvider;
        this.processProperties = processProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    private void startMonitor() {
        Object object = this.$lock;
        synchronized (object) {
            boolean dockerEnabled = this.bootstrapConfiguration.getDockerEnabled();
            boolean containerdEnabled = this.bootstrapConfiguration.getContainerdEnabled();
            if (this.dockerMonitor.isDockerMonitoringSupportedOnCurrentOS() && this.future == null) {
                if (dockerEnabled && containerdEnabled) {
                    return;
                }
                if (this.dockerMonitor.runDockerMonitoring()) {
                    previousReportingIntervalValue = ((DockerMonitorConfig)this.dockerMonitorConfigProvider.get()).getProcessMonitorConfig().getReportingInterval();
                    this.future = this.scheduler.scheduleAtFixedRate((Runnable)this, 0L, ((DockerMonitorConfig)this.dockerMonitorConfigProvider.get()).getProcessMonitorConfig().getReportingInterval().longValue(), TimeUnit.MILLISECONDS);
                    log.debug("Started Monitoring Docker Container Processes every {} ms", (Object)((DockerMonitorConfig)this.dockerMonitorConfigProvider.get()).getProcessMonitorConfig().getReportingInterval());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    private void stopMonitor() {
        Object object = this.$lock;
        synchronized (object) {
            if (this.future != null) {
                this.future.cancel(true);
                this.future = null;
                log.debug("Stopped Monitoring Docker Container Processes");
            }
        }
    }

    @Override
    public void run() {
        if (!this.isFirstTime) {
            log.debug("Docker Container Processes Monitoring {}", (Object)(((DockerMonitorConfig)this.dockerMonitorConfigProvider.get()).getProcessMonitorConfig().getEnabled() != false ? "enabled" : "disabled"));
            if (((DockerMonitorConfig)this.dockerMonitorConfigProvider.get()).getProcessMonitorConfig().getEnabled().booleanValue()) {
                if (previousReportingIntervalValue != ((DockerMonitorConfig)this.dockerMonitorConfigProvider.get()).getProcessMonitorConfig().getReportingInterval()) {
                    this.stopMonitor();
                    this.startMonitor();
                    return;
                }
                try {
                    this.processProperties.reportProcesses();
                }
                catch (Throwable e) {
                    log.warn("DockerProcessMonitor::Caught exception during collection and reporting.", e);
                }
            }
        }
        this.isFirstTime = false;
    }

    @Generated
    static long getPROCESS_METADATA_REPORTING_INTERVAL() {
        return 60000L;
    }
}

